#if !defined(_ASIC_DEFS_)

#define _ASIC_DEFS_

#define TEST_ASIC

typedef enum {
  TRIGGER_FAST_0,
  TRIGGER_FAST_1,
  TRIGGER_RANDOM,
  TRIGGER_SLOW,
  TRIGGER_UNKNOWN
} TRIGGER_TYPE ;

#if defined(TEST_ASIC)

#define ASIC_STATUS_ADDR (unsigned int *)0x0
#define ASIC_CONTROL_ADDR (unsigned int *)0x0

#define ASIC_COUNT_ALL (unsigned int *)0x0

#define SLOW_STATUS_MASK 0x10
#define FAST_STATUS_MASK 0x20
#define SLOW_SYNC_MASK 0xF
#define FAST_SYNC_MASK 0xF

#define FAST_TRIGGER_ENABLE 0x1
#define SLOW_TRIGGER_ENABLE 0x1
#define RANDOM_TRIGGER_ENABLE 0x1
#define FAST_TRIGGER_DISABLE 0x0
#define SLOW_TRIGGER_DISABLE 0x0
#define RANDOM_TRIGGER_DISABLE 0x0

#else

#define ASIC_STATUS_ADDR (unsigned int *)0x0
#define ASIC_CONTROL_ADDR (unsigned int *)0x0

#define SLOW_STATUS_MASK 0x1
#define FAST_STATUS_MASK 0x2


#if defined(_ASIC_LIB_MAIN_)
#else
#endif

#endif
error_code asic_get_status( unsigned int *status ) ;
error_code asic_clear_trigger( TRIGGER_TYPE trig ) ;
error_code asic_enable_trigger( TRIGGER_TYPE trig ) ;
error_code asic_disable_trigger( TRIGGER_TYPE trig ) ;
error_code asic_slow_get_size( unsigned int *nbytes) ;
error_code asic_fast_set_addr( unsigned int *addr ) ;
TRIGGER_TYPE asic_which_trigger() ;
error_code asic_set_thresholdss( TRIGGER_TYPE trig, unsigned int p1,
				 unsigned int p2 ) ;
error_code
asic_set_times( TRIGGER_TYPE trig, unsigned int p1,
		     unsigned int p2 ) ;

#endif
