
# if !defined(_AUGER_IRQ_DEFS_)

#define _AUGER_IRQ_DEFS_

#define AUGER_IRQ_VECTOR 5 /* Toutes les IT externes sont vecteur 5 ( ? ) */

#define AUGER_IRQ_PRIOR 20

/* The EVTCLKF It ( FAST It) is ext1, 1PPS It is ext3.
   Both on positive edge.
*/

#define AUGER_FAST_ENABLE 0x8
#define AUGER_FAST_DISABLE 0xFFFFFFF7

#define AUGER_PPS_ENABLE 0x2
#define AUGER_PPS_DISABLE 0xFFFFFFFD

#define AUGER_IRQ_MASK 0xCCFFFFFF
#define AUGER_IRQ_ENABLE (AUGER_PPS_ENABLE | AUGER_FAST_ENABLE)
#define AUGER_IRQ_DISABLE (AUGER_PPS_DISABLE & AUGER_FAST_DISABLE)

#define AUGER_IRQ_IOCR 0x33000000     /* Positive Edge sensitive */

extern u_int32 getexier() ;
extern u_int32 setexier() ;

extern u_int32 getexisr() ;
extern u_int32 setexisr() ;

extern u_int32 getiocr() ;
extern u_int32 setiocr() ;

#if 0
u_int32 IntIocrMask[5] = {
  0x3FFFFFFF, 0xCFFFFFFF, 0xF3FFFFFF, 0xFCFFFFFF, 0xFF3FFFFF
} ;
u_int32 IntEdge[5] = {
  0x80000000, 0x20000000, 0x08000000, 0x02000000, 0x00800000
} ;
u_int32 IntSign[5] = {
  0x40000000, 0x10000000, 0x04000000, 0x01000000, 0x00400000
} ;
u_int32 IntEnable[5] = {
  0x10, 0x8, 0x4, 0x2, 0x1
} ;
u_int32 IntDisable[5] = {
  0xFFFFFFEF, 0xFFFFFFF7, 0xFFFFFFFB, 0xFFFFFFFD, 0xFFFFFFFE
} ;

#endif
  
#endif
