/*
  central_local.h : Used by both Central & Local Softwares
  ---------------   Pierre Auger Project

              JM Brunet, L Gugliemi, G Tristram
	           College de France - Paris

   Created  : 10/09/97
   Modified : 29/07/98 : Version 2
            : 16/03/99 : Version 2.2
            : 22/02/00 : Version 2.3
	    : 24/05/00 : Version 2.4
	    : 07/09/00 : Version 2.6
*/


#ifndef _CENTRAL_LOCAL_
#define _CENTRAL_LOCAL_

                        /* Completion definition */
#define COMPLETION_ALL    0x00
#define COMPLETION_FIRST  0x40
#define COMPLETION_NEXT   0x80
#define COMPLETION_LAST   0xC0

typedef enum {
  WAIT_STATE= 0,
  START_RUN_REQUESTED,    RUN_STARTED,
  STOP_RUN_REQUESTED,     RUN_STOPPED,
  PAUSE_RUN_REQUESTED,    RUN_PAUSED,
  CONTINUE_RUN_REQUESTED,
  REBOOT
} run_status;


typedef enum {          /* Event Serveur Error Codes */
  NO_ERROR, M_T3_LOST, M_T3_NOT_FOUND, M_T3_TOO_YOUNG, M_T3_ALREADY
} ErrorCode;

typedef enum{           /* MsgSvrIn Error codes      */
  MSGIN_LEN, MSGIN_TYP, MSGIN_ALR, MSGIN_LOST
} MsgError;

typedef enum{           /* CalMon Error codes      */
  BUFFER_OK, NO_MONIT_BUFFER, NO_CALIB_BUFFER
} CalMonError;

typedef enum {          /* Messages from Local to Central station */
  M_READY,              /* from Control to CS      */
  M_DOWNLOAD_ACK,       /*      Control to CS      */
  M_OS9_CMD_ACK,        /*      Control to CS      */
  M_MODULE2FLASH_ACK,   /*      Control to CS      */
  M_LOG_SEND,           /*      Control to CS      */
  M_RUN_START_ACK,      /*      Control    CS      */
  M_RUN_PAUSE_ACK,      /*      Control    CS      */
  M_RUN_CONTINUE_ACK,   /*      Control    CS      */
  M_RUN_STOP_ACK,       /*      Control    CS      */
  M_T2_YES,             /*      Trigger2   CS      */
  M_T3_EVT,             /*      EvtSvr     CS      */
  M_T3_MUONS,           /*      EvtSvr     CS      */
  M_CONFIG_SET_ACK,     /*      Control    CS      */
  M_MONIT_REQ_ACK,      /*      CalMon     CS      */
  M_MONIT_SEND,         /*      CalMon     CS      */
  M_CALIB_REQ_ACK,      /*      CalMon     CS      */
  M_CALIB_SEND,         /*      CalMon     CS      */
  M_BAD_SEQUENCE,       /*      Control    CS      */
  M_BAD_VERSION,        /*      Control    CS      */
  M_MSG_ERROR,          /*      MsgSvrIn   CS      */
  M_UNKNOWN             /*      Control    CS      */
} MsgTypeOut;


typedef enum {          /* Messages from Central to Local station */
  M_REBOOT,             /* from CS      to Control */
  M_WAKEUP,             /*      CS         Control */
  M_DOWNLOAD,           /*      CS         Control */
  M_OS9_CMD,            /*      CS         Control */
  M_MODULE2FLASH,       /*      CS         Control */
  M_LOG_REQ,            /*      CS         Control */
  M_RUN_ENABLE,         /*      CS         Control */
  M_RUN_START_REQ,      /*      CS         Control */
  M_RUN_PAUSE_REQ,      /*      CS         Control */
  M_RUN_CONTINUE_REQ,   /*      CS         Control */
  M_RUN_STOP_REQ,       /*      CS         Control */
  M_T3_YES,             /*      CS         EvtSvr  */
  M_CONFIG_SET,         /*      CS         Control */
  M_FLASH_TO_CONFIG,    /*      CS         Control */
  M_CONFIG_TO_FLASH,    /*      CS         Control */
  M_MONIT_REQ,          /*      CS         CalMon  */
  M_CALIB_REQ,          /*      CS         CalMon  */
  M_GPS                 /*      CS         GPS     - Must be the LAST *****/
} MsgTypeIn;

#define BUFCOMSIZE 150     /* Maximun data size in comms packet */
#define PACKETSIZE 265     /* Maximun size of comms packet      */

#ifdef MAIN
  unsigned char BufCom[PACKETSIZE];
#else
  extern unsigned char BufCom[];
#endif

#endif

