/*
  config.h : Used by both Central & Local Softwares
  ---------- Pierre Auger Project

              JM Brunet, L Gugliemi, C Le Gall, G Tristram
	               College de France - Paris

   Created  : 11/09/97
   Modified :

*/

#ifndef _CONFIG_
#define _CONFIG_

#define ENABLE_T1A  0x01
#define ENABLE_T1B  0x02
#define ENABLE_T1C  0x04
#define ENABLE_T1D  0x08
#define ENABLE_T1E  0x10
#define ENABLE_T1F  0x20
#define ENABLE_T1G  0x40

/* Param type definition
   --------------------- */

#define ParamTypeChar   0x01
#define ParamTypeShort  0x02
#define ParamTypeInt4   0x04
#define ParamTypeInt8   0x08
#define ParamTypeFloat  0x14
#define ParamTypeDouble 0x18

typedef struct {
  char name[10];
  unsigned char num;
  unsigned char type;
} PARAMCONFIG;

PARAMCONFIG ParamConfig[]= { "Trg1Rate  ", 0, ParamTypeInt,
			     "Trg2Rate  ", 1, ParamTypeInt,
			     "Trg2Algo  ", 2, ParamTypeInt
};

/* Config Structure definition
   --------------------------- */
typedef struct {
  u_int16 EnableT1;
  int Rate;
} trg1_config;

typedef struct {
#if defined (_TEST_DAS)
  int Rate;
#endif
  int Algorithm;
} trg2_config;

typedef struct {
  trig1_config trg1;
  trig2_config trg2;
} CONFIG;

#ifdef MAIN
char ConfigModName= "Config";

CONFIG *CfData;
mh_com *CfHeader;

#else

extern char *ConfigModName;
extern CONFIG *CfData;

#endif

#endif
