#if !defined(_DMA_LIB_DEFS_)

#define _DMA_LIB_DEFS_

/* Channel 0 is for FAST buffer, Channel 1 for SLOW buffer */
/* DMA Status Register */

#define DMA_FAST_END 0x80000000
#define DMA_SLOW_END 0x40000000

/* DMA Control Register */

#define DMA_ENABLE    0x80000000
#define DMA_IT_ENABLE 0x40000000
#define DMA_TO_MEM    0x20000000
#define DMA_INTERNAL  0x10000000
#define DMA_WIDTH32   0x08000000
#define DMA_DEST_INCR 0x02000000
#define DMA_SRCE_INCR 0x01000000
#define DMA_BUS_PRIOR 0x00800000
#define DMA_FLYBY     0x00200000
#define DMA_BUFFERED  0x00000000
#define DMA_SOFT_MEM  0x00400000
#define DMA_HARD_MEM  0x00600000
#define DMA_STUP_3    0x00180000
#define DMA_WAIT_63   0x0007E000
#define DMA_PHC_7     0x00001C00
#define DMA_ETD       0x00000200    /* programmed as TC output pin */
#define DMA_TCE       0x00000100
#define DMA_CHAIN     0x00000080
#define DMA_BURST     0x00000040
#define DMA_ECE       0x00000020
#define DMA_TCD       0x00000010

u_int32 set_dmacr_fast() ;
u_int32 set_dmada_fast() ;
u_int32 set_dmact_fast() ;
u_int32 set_dmacr_slow() ;
u_int32 set_dmada_slow() ;
u_int32 set_dmact_slow() ;
u_int32 set_dmasr() ;
u_int32 get_dmacr_fast() ;
u_int32 get_dmada_fast() ;
u_int32 get_dmact_fast() ;
u_int32 get_dmacr_slow() ;
u_int32 get_dmada_slow() ;
u_int32 get_dmact_slow() ;
u_int32 get_dmasr() ;

void dma_setup_test( int, int ) ;
void dma_setup( void ) ;
void dma_set_fast( u_int32 *buff, int nwords ) ;
void dma_wait_fast( void ) ;
void dma_start_fast( void ) ;
void dma_stop_fast( void ) ;
void dma_set_slow( u_int32 *buff, int nwords ) ;
void dma_wait_slow( void ) ;
void dma_start_slow( void ) ;
void dma_stop_slow( void ) ;

#endif
