#if !defined(_EVBLIB_DEFS_)

#define _EVBLIB_DEFS_

#include "versions.h"

/*** #include "t3defs.h" ***/
#include "feevts.h"

typedef unsigned int EvbId ;

int EvbVersionId() ;

char *EvbVersion() ;

char *EvbError( error_code ok ) ;

error_code EvbInit( EvbId *evbid, char *name, int size ) ;

error_code EvbFinish( EvbId *evbid ) ;

error_code EvbAlloc( EvbId evbid, void **buffer, int size ) ;
#if EVB_VERSION<5
error_code EvbReady( EvbId evbid, void *buffer, int size ) ;
#else
error_code EvbReady( EvbId evbid, void *buffer, int size,
		     unsigned char *tag ) ;
#endif

error_code EvbCancel( EvbId evbid, void *buffer ) ;

error_code EvbFree( EvbId evbid, int nb ) ;

error_code EvbReset( EvbId evbid ) ;

#if EVB_VERSION<5
error_code EvbFind( EvbId evbid, void *buffer, int *size, int *status,
		    TimeStamp *wanted, int delta ) ;

error_code EvbFindNext( EvbId evbid, void *data, int *size, int *status,
			TimeStamp *req, int delta ) ;
#else
error_code
EvbFindTag( EvbId evbid, void *pdat, int *size,
	    int (*compare)( void *, unsigned char),
	    int index, unsigned char tag, unsigned char newtag ) ;
error_code
EvbFind( EvbId evbid, void *pdat, int *size,
	    int (*compare)( void *, unsigned char) ) ;
error_code
EvbGetFirstTag( EvbId evbid, void *pdat, int *size, int index,
		unsigned char tag, unsigned char newtag ) ;
error_code
EvbGetLastTag( EvbId evbid, void *pdat, int *size, int index,
		unsigned char tag, unsigned char newtag ) ;
error_code
EvbSetTag( EvbId evbid, void *pdata, int index, unsigned char tag ) ;

#endif
void EvbDump( EvbId evbid, FILE *out, int part ) ;

error_code EvbFirst( EvbId evbid, void **pbf, void **data ) ;

error_code EvbNext( EvbId evbid, void **pbf, void **data ) ;

#endif
