/*
* augerevts.h
*   definition des differents FE buffers
*/

#if !defined(_EVT_DEFS_)
#define   _EVT_DEFS_

#define FAST_SAMPLE_NUMBER 0x400 /* Maximum nb de samples pour Fast events */
#define SLOW_MUON_NUMBER   0x300 /* Maximum number of muons in a slow buffer */

typedef struct {
  int second ;
  int nano ;
} TimeStamp ;

typedef struct {
  unsigned char sumd8, pmt3, pmt2, pmt1 ;
  unsigned short time_tag ;
  unsigned char lowd8, low ;
} FAST_SAMPLE ;

typedef struct {
  TimeStamp datep;     /* time stamp of first particle (second-micro) */
  TimeStamp date0;     /* time stamp at EVTCLKF high-low transition   */
  unsigned int time_tag ;
  unsigned short T2T1_type;
  unsigned short nsamples ;
  FAST_SAMPLE data[FAST_SAMPLE_NUMBER];
} FAST_EVENT;

typedef struct {
  unsigned char sum, pmt3, pmt2, pmt1 ;
} SLOW_SAMPLE ;

typedef struct {
  unsigned int time_tag ;
  SLOW_SAMPLE sample0, sample1, sample2, sample3 ;
} SLOW_MUON ;

typedef struct {
  TimeStamp date ;
  unsigned int time_tag ;
  unsigned int nmuons ;
  SLOW_MUON data[SLOW_MUON_NUMBER];
} SLOW_EVENT;

#endif
