#if !defined(_GPS_DEFS_H_)

#define _GPS_DEFS_H_

/* GPS Board registers.
   Les bits Ma2, MA3 et MA4 sont utilises pour differencier les registres.
   MA4 MA3 MA2 Usage
    0   0   0   M1 (calibration 100 MHz)
    0   0   1   M2 (EVTCLKF compteur 100 MHz)
    0   1   0   M3 (EVTCLKF compteur 1PPS)
    0   1   1   M4 (EVTCLKS compteur 100 MHz)
    1   1   1   M5 (EVTCLKS compteur 1 PPS)
    1   0   0   M6 (calibration 40 MHz)

   M1 et M6 = compteurs sur 27 bits.
   M2 et M4 = idem
   M3 et M5 = compteurs sur 24 bits

   Les 4 bits de haut poids contiennent le numero du registre (de 1 a 6)

   */

#define GPS_BASE_ADDR 0xF3000000

#define GPS_IDENT_MASK 0xF8000000
#define GPS_IDENT_SHIFT 28
/* 27 bits for the calibration register */
#define GPS_CALIB_MASK 0x7FFFFFF
#define GPS_VALUE_MASK 0x7FFFFFF

#define GPS_CALIB     (unsigned int *)(GPS_BASE_ADDR)
#define GPS_FAST_NANOS  (unsigned int *)(GPS_BASE_ADDR+4)
#define GPS_FAST_SECOND (unsigned int *)(GPS_BASE_ADDR+0x8)
#define GPS_SLOW_NANOS  (unsigned int *)(GPS_BASE_ADDR+0xC)
#define GPS_SLOW_SECOND (unsigned int *)(GPS_BASE_ADDR+0x1C)
#define GPS_CALIB40    (unsigned int *)(GPS_BASE_ADDR+0x10)

#define GPS_RESET     (unsigned int *)GPS_BASE_ADDR

#define PPS_EVENT_NAME    "PPSEvent"

#endif
