/* monitor.h : Local Station Software - Pierre Auger Project
   ----------
              JM Brunet, L Gugliemi, G Tristram
                  College de France - Paris

   The structure defined in this include file are contained in the date
   module 'Monitor'

   Created    10/09/99 - JMB
   Modified : 24/05/00 - Version 2.4

-------------------------------------------------------------------- */

#ifndef _MONITOR_
#define _MONITOR_

#define FAKE_OLEG         /*** TAKE FAKE OLEG FUNCTIONS ***/

   /* 32 ADCs : bits 0-11 : ADC value
                bit    13 : Warning Red
                bit    14 : Warning Orange
                bit    15 : ADC not in use
   Meanning :
     Chan[ 0]:Tpmt1        Chan[ 1]:Ipmt2          Chan[ 2]:Ipmt3
     Chan[ 3]:Tpmt2        Chan[ 4]:Ipmt1          Chan[ 5]:Vpmt3
     Chan[ 6]:Vpmt1        Chan[ 7]:Vpmt2          Chan[ 8]:GND
     Chan[ 9]:Tfree        Chan[10]:Telect         Chan[11]:3.3 V
     Chan[12]:Twater       Chan[13]:Tair out       Chan[14]:Tpmt3
     Chan[15]:Tair in      Chan[16]:V1sol panel    Chan[17]:I2battery
     Chan[18]:T2battery    Chan[19]:V2sol panel    Chan[20]:I1battery
     Chan[21]:V2battery    Chan[22]:T1battery      Chan[23]:V1battery
     Chan[24]:5 V          Chan[25]:Pwater         Chan[26]:Patm out
     Chan[27]:12 V ou pot  Chan[28]:Vcloud offset  Chan[29]:Vcloud therm
     Chan[30]:Vcloud comp  Chan[31]:Vcloud uncomp
   */

typedef struct {   /* ADCs */
  unsigned short Chan[NADC];
  unsigned short InputRegister;
} MONITOR_READ;



   /* 8 DACs 12 bits : stored in 16 bits.
      **************
      Chan[0] : Vpmt1     Chan[1] : Vpmt2       Chan[2] : Vpmt3
      Chan[3] : LED       Chan[4] : ElecCalib   Chan[5] :
      Chan[6] :           Chan[7] :
   Remark : ElecCalib is a calibration signal that can be send to PM bases
   */

typedef struct {   /* DACs */
  unsigned short Chan[NDAC];
  unsigned short OutputRegister;
} MONITOR_WRITE;

   /* 32 bits Summary :
                 - bit  0 : = 1 : at least 1 ADC error
                 - bit  1 :       at least 1 ADC warning
                 - bit 16 :       GPS State in Alarm
                 - bit 17 :       GPS State unknown
                 - bit 18 :       No 1 pps from GPS
                 - bit 31 :       Run not enable in this station
   */


typedef struct {         /* Content of the monitoring buffer */
  unsigned int   Second; /* Starting time */
  unsigned int   ItemNb; /* mean done on this number of items */
  unsigned int   Summary;
  MONITOR_READ   Read;
  MONITOR_WRITE  Write;
} MONITOR;

#if defined (_OS9000)

#define MAX_MONIT_BUFFER  50
#define MONIT_BUFFER_NAME "MonitBuffer"
#define NB_MONIT_RELEASE  5
#define MONIT_SIZE  MAX_MONIT_BUFFER*sizeof(MONITOR)

typedef enum { TAG_REQ_ACK= 1, TAG_SEND, TAG_DATA_SVR=5, TAG_SPY } TAGTYPE;

#ifdef _MONITOR_MAIN_

EvbId MonitId;

#else

extern EvbId MonitId;

#endif
#endif

#ifdef FAKE_OLEG
error_code ReadADC( unsigned short *pchan, unsigned int InUse,
                    int IsTPC);
error_code ReadDAC( unsigned short *pchan, unsigned char InUse,
                    int IsTPC);
error_code WriteDAC( unsigned short *pchan, unsigned char InUse,
                    int IsTPC);
error_code ReadRegister( unsigned short *preg, int IsIn);
error_code WriteRegister( unsigned short reg);
#else

#include "slowcontrol.h"

#endif
#endif
