/*
  msgdefs.h : Used by both MsgSvrIn & MsgSvrOut
  ---------   Pierre Auger Project

              JM Brunet, L Gugliemi, G Tristram
	               College de France - Paris

   Created  : 11/08/97
   Modified : 29/09/97 : split MsgSvr into MsgSvrIn & MsgSvrOut
                         Implement mechanism for Communication Buffer
              17/03/99 : Version 2.2
	      22/02/00 : Version 2.3
---------------------------------------------------------------------------
   Messages are sent via MailBoxes. The message format is defined
   in the structure MESSAGE:
          - int :  Message total nb. of bytes
          - byte : Message Type
          - unsigned char * : data field
---------------------------------------------------------------------------


*/

#ifndef _MSGDEFS_
#define _MSGDEFS_

#include <stdio.h>
#include <errno.h>
#include <cglob.h>
#include <modes.h>
#include <types.h>
#include <signal.h>

#include "postlib.h"
#include "central_local.h"

#define FAKE_SU
#ifndef E_SUCCESS
#define E_SUCCESS 0
#endif
                                 /* Buffer & Mailbox sizes in bytes */
#define BUFSIZEM 160
#define BUFSIZEL 800
#define BUFSIZEX 9600            /* 150x64 : see MsgSvrIn */
#define SIZEM    BUFSIZEM*20
#define SIZEL    BUFSIZEL*20
#define SIZEX    BUFSIZEX*4


typedef enum { TRIGGER2, EVTSVR, CONTROL, CALMON, GPS, CS, MSGSVRIN,
               MSGSVROUT} MSGPROCS;

typedef enum { SIG_MSG_IN=33, SIG_MSG_OUT, SIG_TRG2,  SIG_SVR,
               SIG_CTRL,        SIG_CALMON,  SIG_GPS,   SIG_STOP,
               SIG_PAUSE
} MSGSIG;


typedef struct {
  int length;
  unsigned char completion, slice, type, version;
} MESSAGE_HEADER;


typedef struct {
  MESSAGE_HEADER mheader;
  unsigned char buf[BUFSIZEX];
} MESSAGE;

#define PROCESS_NB 5

typedef struct {               /*--- Mailboxes description for a process ---*/
  MSGPROCS procs;              /* process name */
  char is_in, is_out;          /* Is there a Mailbox (in and out) ? */
  MailboxId mbx_in, mbx_out;   /* Mailbox Ids  */
  int Msize_in, Msize_out;     /* Mailbox size */
  int Bsize_in, Bsize_out;     /* Buffer-mailbox size */
  post_notify *notify;         /* Pointer on post_notify structure */
  char *pnamein, *pnameout;    /* Mailbox name */
  int prev_read;               /* used in msgsvrout */
  unsigned char prev_slice;    /* used in msgsvrout */
  unsigned char prev_type;     /* used in msgsvrout */
  unsigned char prev_version;  /* used in msgsvrout */
  unsigned char *prev_pdata;   /* used in msgsvrout */
  unsigned char messnb;        /* used in msgsvrout */
} PROCESS;


#ifdef MAIN
  PROCESS *myprocess(  MSGPROCS);            /* See Util/myprocess.c */
  MESSAGE *pMessage;

    char PnameMsgCtrl[]=   "MsgCtrl";
    char PnameMsgEvtSvr[]= "MsgEvtSvr";
    char PnameMsgCalMon[]= "MsgCalMon";
    char PnameMsgGps[]=    "MsgGps";
    char PnameCtrlMsg[]=   "CtrlMsg";
    char PnameTrg2Msg[]=   "Trg2Msg";
    char PnameEvtSvrMsg[]= "EvtSvrMsg";
    char PnameCalMonMsg[]= "CalMonMsg";
    char PnameGpsMsg[]=    "GpsMsg";

    post_notify NtfyCtrl  = { POST_NTFY_SIGNAL, SIG_CTRL,    0 };
    post_notify NtfyTrg2  = { POST_NTFY_SIGNAL, SIG_TRG2,    0 };
    post_notify NtfySvr   = { POST_NTFY_SIGNAL, SIG_SVR,     0 };
    post_notify NtfyCalMon= { POST_NTFY_SIGNAL, SIG_CALMON,  0 };
    post_notify NtfyGps   = { POST_NTFY_SIGNAL, SIG_GPS,     0 };
    post_notify NoNotify  = { POST_NTFY_NONE,   0,           0 };


  PROCESS Process[]= {     /* Mailboxes description for all processes */
    TRIGGER2, 0, 1, 0, 0, 0,     SIZEL,      0,              BUFSIZEL,
              &NtfyTrg2,  NULL,              PnameTrg2Msg,   0, 0, 0, 0, 0, 0,
    EVTSVR,   1, 1, 0, 0, SIZEM, SIZEX,      BUFSIZEM,       BUFSIZEX,
              &NtfySvr,   PnameMsgEvtSvr,    PnameEvtSvrMsg, 0, 0, 0, 0, 0, 0,
    CONTROL,  1, 1, 0, 0, SIZEM, SIZEM,      BUFSIZEM,       BUFSIZEM,
              &NtfyCtrl,  PnameMsgCtrl,      PnameCtrlMsg,   0, 0, 0, 0, 0, 0,
    CALMON,   1, 1, 0, 0, SIZEX, SIZEX,      BUFSIZEX,       BUFSIZEX,
              &NtfyCalMon,PnameMsgCalMon,    PnameCalMonMsg, 0, 0, 0, 0, 0, 0,
    GPS,      1, 1, 0, 0, SIZEL, SIZEL,      BUFSIZEL,       BUFSIZEL,
              &NtfyGps,   PnameMsgGps,       PnameGpsMsg,    0, 0, 0, 0, 0, 0
  };

#ifdef FAKE_SU
  char *RS232ToCentral=   "./pipe/ToCentral";
  char *RS232FromCentral= "./pipe/FromCentral";
#else
  char *RS232ToCentral=   "./tsu";
  char *RS232FromCentral= "./tsu";
#endif

#else
  extern post_notify NtfyCtrl, NtfyTrg2, NtfySvr, NtfyCalMon, NtfyGps;
  extern PROCESS Process[];

    extern char PnameMsgCtrl[], PnameMsgEvtSvr[], PnameMsgCalMon[],
                PnameMsgGps[];
    extern char PnameCtrlMsg[],   PnameTrg2Msg[], 
                PnameEvtSvrMsg[], PnameCalMonMsg[], PnameGpsMsg[];
    extern char *RS232ToCentral,  *RS232FromCentral;

#endif

#endif
