/* run_config.h : Local Station Software - Pierre Auger Project
   ------------
              JM Brunet, L Gugliemi, C Le Gall, G Tristram
                       College de France - Paris

   The structures defined in this include file are contained in the data
   module 'Config'


   Created    03/03/99 - JMB : Version 2.3
   Modified   24/05/00 - JMB : Version 2.4

-------------------------------------------------------------------- */

#ifndef _CONFIG_
#define _CONFIG_


#define NADC  32
#define NPMT   3
#define NDAC   8

#include "monitor.h"

typedef enum {              /* For M_CONFIG_SET message */
  CONF_UPDATE_ALL= 0,       CONF_UPDATE_FE_PARAMS,
  CONF_UPDATE_ACQ_PARAMS,   CONF_UPDATE_GPS_PARAMS,
  CONF_UPDATE_MONIT_PARAMS, CONF_UPDATE_CALIB_PARAMS
} UPDATE_PARAMS;

typedef struct { 
  unsigned int Width, Occupancy, Thresh, Delay;
} FAST_WINDOW;

typedef struct {
  unsigned int Width, ZeroSupThresh, MuZeroSup, MuGateWidth;
} SLOW_WINDOW;

typedef struct {            /* FrontEnd electronics parameters */
  unsigned char IsFast0Enabled, IsFast1Enabled, 
                IsSlowEnabled,  IsRandomEnabled;
  FAST_WINDOW fast0;
  FAST_WINDOW fast1;
  SLOW_WINDOW slow;
  unsigned int FastZeroSupThresh, FastRandomTriggerDelay,
    FastExternTriggerDelay;
  unsigned int Scaler1LowThresh, Scaler2LowThresh, Scaler3LowThresh;
} FE_PARAMS;

typedef struct {            /* Acquisition parameters */
  unsigned short HardAddress, LogicalAddress;
  unsigned short VEMmin;
  unsigned char Trigger2Algorithm, RunEnable;
} ACQ_PARAMS;

typedef struct {            /* Position for hold_position    */ 
  unsigned char Lat[4]   ;  /* latitude in mas milli arc sec */
  unsigned char Longi[4] ;  /* longitude   mas               */
  unsigned char Height[4];  /* cm  with respect to GPS ellipsoid */
  unsigned char Htype    ;  /* GPS ellips. reference         */
} POSIT_H;         


typedef struct {            /* GPS parameters */
  unsigned char AlarmLim[2] ; /* Alarm limit in 100s of nsec */
  unsigned char CabDel[4]   ; /* Antenna cable delay nsec    */ 
  unsigned char Mask        ; /* Mask angle degrees  0.. 89  */
  POSIT_H Posit_h           ; /* Position for hold_position  */ 
} GPS_PARAMS;


typedef struct {            /* Monitor parameters */
  unsigned short ReadRate;         /* Read ADCs frequency in second */
  unsigned char Times;             /* number of reads before a buffer write */
  unsigned char IsSendRegular;
  unsigned char IsTPC;             /* If Tank Power Control */
  unsigned char DACinUSE;          /* On / Off */
  unsigned short Dac[NDAC];        /* 12 bits DACs */
  unsigned short OutputRegister;   /* 16 bits register */
  unsigned short MinOrange[NADC], MaxOrange[NADC];
  unsigned short MinRed[NADC],    MaxRed[NADC];
  unsigned int ADCinUSE;           /* On / Off */
} MONIT_PARAMS;


typedef struct {            /* Monitor parameters for PMTs */
  unsigned short Dac[NPMT];        /* 12 bits DACs */
  unsigned short MinOrange[NPMT], MaxOrange[NPMT];
  unsigned short MinRed[NPMT],    MaxRed[NPMT];
} PMT_PARAMS;


typedef struct {
  FE_PARAMS  FeParams;
  ACQ_PARAMS AcqParams;
  GPS_PARAMS GpsParams;
  MONIT_PARAMS MonitParams;
} CONFIG;  


#if defined (_OS9000)
#ifdef _CONFIG_MAIN_

char *ConfigModName= "Config";

CONFIG   *CfData;
mh_com   *CfHeader;

#else 

extern char *ConfigModName;
extern CONFIG   *CfData;
extern mh_com   *CfHeader;

#endif
#endif
#endif
