#ifndef __LIB_H__
#define __LIB_H__

/******************************************

  $Author: os9 $
  $Date: 2000/10/16 09:57:19 $
  $Revision: 1.6 $

  $Log: slowcontrol.h,v $
  Revision 1.6  2000/10/16 09:57:19  os9
  Cosmetique

******************************************/

/******************************************
 * possible software errors on ADC use
 ******************************************/
typedef enum
{
  ADCError_first = 0,

  ADCError_none = ADCError_first,
  ADCError_state,
  ADCError_busy,
  ADCError_voie,

  ADCError_last = ADCError_voie,
  ADCError_max

} ADCErrors;

#define ADC_MUX 4
#define ADC_MUXVOIES 8
#define ADC_NBVOIE ADC_MUX * ADC_MUXVOIES
#define ADC_LASTVOIE ADC_NBVOIE - 1


/******************************************
 * possible ADC states
 ******************************************/
typedef enum
{
  ADCState_first = 0,

  ADCState_awake = ADCState_first,
  ADCState_nap,
  ADCState_sleep,

  ADCState_last = ADCState_sleep,
  ADCState_max

} ADCState;

/******************************************
 * adresses needed to change ADC states
 ******************************************/
#define ADCState_adresses \
	SCAD0, \
	SCAD1, \
	SCAD2


/******************************************
 * DAC
 ******************************************/
#define DAC_CHANNELS 4

/******************************************
 * possible software errors on DAC use
 ******************************************/
typedef enum
{
  DACError_first = 0,

  DACError_none = DACError_first,
  DACError_enum,
  DACError_channel,

  DACError_last = DACError_channel,
  DACError_max

} DACErrors;


/******************************************
 * DACs enum
 ******************************************/
typedef enum
{
  DACEnum_first = 0,

  DACEnum_0 = DACEnum_first,
  DACEnum_1,

  DACEnum_last = DACEnum_1,
  DACEnum_max

} DACEnum;

#define DAC_NBVOIE DAC_CHANNELS * DACEnum_max


/******************************************
 * prototypes
 ******************************************/

int is_ADC_done();
void wait_10micsec();
ADCErrors get_ADC_error();
unsigned int set_ADC_state( ADCState state );
unsigned int nap_ADC();
unsigned int sleep_ADC();
unsigned int awake_ADC();
unsigned int read_nap_ADC( unsigned int voie );
unsigned int read_sleep_ADC( unsigned int voie );
unsigned int read_awake_ADC( unsigned int voie );
int is_ADC_sleeping();
unsigned int read_ADC( unsigned int voie, ADCState state );

ADCErrors ReadADC( unsigned short *pchan, unsigned int InUse /* , int IsTPC */ );

DACErrors get_DAC_error();
DACErrors mV_write_DAC( DACEnum dac, int channel, unsigned int val );
DACErrors raw_write_DAC( DACEnum dac, int channel, unsigned int val );
unsigned int mV_readback_DAC( DACEnum dac, int channel );
unsigned int raw_readback_DAC( DACEnum dac, int channel );

DACErrors ReadDAC ( unsigned short *pchan, unsigned char InUse /* , int IsTPC */ );
DACErrors WriteDAC( unsigned short *pchan, unsigned char InUse /*, int IsTPC */ );

unsigned int read_digital_input();
unsigned int readback_digital_output();
void write_digital_output( unsigned int val );

unsigned short WriteRegister( unsigned short preg );
unsigned short ReadRegister ();

#endif
