/* status.h : Local Station Software - Pierre Auger Project
   ----------
              JM Brunet, L Gugliemi, C Le Gall, G Tristram
                       College de France - Paris

   The structures defined in this include file are contained in the date
   module 'Status'

   Created    01/06/97 - JMB
   Modified : 18/06/98 - Version-2

-------------------------------------------------------------------- */

#ifndef _STATUS_
#define _STATUS_

#define FAKE_OLEG
#define FAKE_SU
#define FAKE_GPS
#define FAKE_IDENTIFICATION_FILE
#define EA_BUFFER

#if defined (_OS9000)

#include <types.h>
#include <signal.h>
#include <events.h>
#include <time.h>
#include <stdio.h>
#include <cglob.h>
#include "dmlib.h"
#include "central_local.h"
#include "fastlib.h"   /* Fast  buffer management  */
#include "slowlib.h"   /* Slow  buffer management  */
#include "augererr.h"
#include "evblib.h"    /* Event buffer management  */

#define SIG_MONITOR   42
#define SIG_CALIB     43

#else

  typedef int event_id;
  typedef int u_int32;

#endif

typedef struct {
  int T1Fast0, T1Fast1, T1Random, T1Slow;
  int T1SlowMiss, T1FastMiss ;
  int T1DeadTime, FastSec, SlowSec;
} inter_status;  /* Interrupt routines part */

typedef struct {
  int T1Fast0, T1Fast1;
  int T2;
  int second;
  int NEvtBusy;
} trg2_status;

typedef struct {
  int T1Slow, second;
} mufill_status;

typedef struct {
  int T1Random;
  int PidCalMon;     /* Pid calmon server */
} calmon_status;

typedef struct {
  int T3Asked, T3Found, T3Already, T3Lost, T3Muon;
  int T3NotFound, T3TooYoung;
  int second;
} evtsvr_status;

typedef struct {
  int FastUsed, FastMin, FastMax, FastLost;
  int SlowUsed, SlowMin, SlowMax, SlowLost;
  int EvbUsed,  EvbMin,  EvbMax,  EvbLost;
  int MubUsed,  MubMin,  MubMax,  MubLost;
} buffer_status;

typedef struct {
  event_id IdT1Mu,     IdT1Trigger2;
  char EvNameT1Mu[10], EvNameT1Tg2[10];
} event_status;

typedef struct {
  int bunch, CpuStartRun;
  char StartAcq[50];
  u_int32 ticks;
  int RunNumber;
  int FastBufState;
  int SlowBufState;
  FAST_EVENT FastEvent;
  SLOW_EVENT SlowEvent;
} Fmr;

typedef struct {
  int nb, cursize, totsize;
} Com;

typedef struct {
  int            GpsState;
  int            IsChangeDac;
  run_status     RunStatus;
  inter_status   inter;
  trg2_status    trg2;
  mufill_status  mufill;
  calmon_status  calmon;
  evtsvr_status  evtsvr;
  buffer_status  buffer;
  event_status   event;
  Fmr            fmr;
  Com            ComIn;
  Com            ComOut;
  int            Freeze;
} STATUS;

#if defined (_OS9000)

int PrtLog( char *str, int we);

#ifdef _STATUS_MAIN_

char *StatModName= "Status";

STATUS   *StData;
mh_com   *StHeader;
FAST_EVENT AugerEvent;       /* A changer quand new Event Buffer */
#else 

extern char *StatModName;

extern STATUS   *StData;
extern mh_com   *StHeader;
extern FAST_EVENT AugerEvent;       /* A changer quand new Event Buffer */
#endif

#endif
#endif
