/* svrdm.h : Local Station Software - Pierre Auger Project
   ---------
              JM Brunet, L Gugliemi, C Le Gall, G Tristram
                       College de France - Paris

   The structures defined in this include file are contained in the data
   module 'SvrDm' used by msgsvrin & msgsvrout.

   Created    06/01/2000 - JMB
   Modified : 18/10/2000 - RS-232 Communication Protocol V2.0

-------------------------------------------------------------------- */

#ifndef _SVRDM_
#define _SVRDM_
#include <events.h>

#define COMBUFMAX 270
#define SIG_SVR   44

typedef struct {
  unsigned short BSid, LSid;    /* Base Station & Local Station Identifiers */
  unsigned char PacketNumberRec;
  unsigned char PacketNumberSent;
  unsigned char NetworkStatus;
  char IsControlCommand;
  char IsDataAck,         IsSent;
  char IsSoftReset,       IsVersionReq;
  char IsGpsStatusReq;
  char IsStationIdReq;
  char IsEchoReq,         EchoData[250];
  char IsCommandInvalid,  SendCommandInvalid;
  char IsFail;
  int  Pid;               /* msgsvrout pid */
  char IsStop, IsSpy;     /* Only for tests : tosu & fromsu */
  int NbEchoReceived;
} SVRDM;


typedef enum { SU_DATA= 0x44,    SU_DATA_ACK= 0x64,
	       SU_ECHO= 0x45,    SU_ECHO_ACK= 0x65, 
	       SU_CONTROL= 0x43, SU_CONTROL_ACK= 0x63,
	       SU_POWER= 0x46,
	       SU_RESET= 0x52,   SU_RESET_ACK= 0x72,
	       SU_STATUS= 0x53,  
	       SU_VERSION= 0x56, SU_VERSION_ACK= 0x76,
	       SU_GPS= 0x47,     SU_GPS_ACK= 0x67,
	       SU_ID= 0x54,      SU_ID_REPLY= 0x74,
	       SU_NETWORK= 0x4e, SU_NETWORK_REPLY= 0x6e,
	       SU_INVALID= 0x49
} SUSCRIBER;



char *SvrModName= "SvrDm";

SVRDM    *SvrData;
mh_com   *SvrHeader;

#endif

/*
  PacketNumberRec  : Packet number received from Central
  PacketNumberSent : Packet number sent to Central
  IsControlCommand :
                 * Set by msgsvrin when a control command is issued by
		   the SU.
		 * msgsvrout must then send a 'Control Ack Response' and 
		   reset this variable.
  IsDataAck:     * Set by msgsvrin when a Data Packet is sent by SU
                 * msgsvrout must then send an acknowledge to SU and reset 
		   IsDataAck
  IsSent   :     * Set by msgsvrout when a Data Packet is sent to SU
                 * Reset by msgsvrin when receiving a Data Acknowledge
                 * If this variable is still set, msgsvrout must resend the 
		   previous Data Packet.
  IsSoftReset :  * Set by msgsvrin when receiving a 'Software Reset Command'
                 * msgsvrout must then send a 'Software Reset Acknowledge 
		   Response' and reboot the Controller.
  IsVersionReq : 
                 * Set by msgsvrin when receiving a 'Version Request Command'
		 * msgsvrout must send a 'Version Reply' and reset 
		   IsVersionReq.
  IsGpsStatusReq :
                 * Set by msgsvrin when a 'GPS 1PPS Status Request' is issued
		   by the SU.
		 * msgsvrout must issued a 'GPS 1PPS Status Reply' and reset
		   this variable.
  IsStationIdReq :
                 * Set by msgsvrin when a 'Station ID Request' is issued
		   by the SU.
		 * msgsvrout must issued a 'Station ID Reply' and reset
		   this variable.
  IsEchoReq :    * Set by msgsvrin, which store the echo string into Echodata.
                 * msgsvrout send an 'Echo Ack Response' and reset IsEchoReq.
  IsCommandInvalid :
                 * Set by msgsvrin when receiving a 'Command Invalid Response'.
		 * Reset by msgsvrout after having resent the previous packet.
  SendCommandInvalid :
                 * Set by msgsvrin when receiving an unknown type of command.
		 * Reset by msgsvrout after having sent a 'Command Invalid 
		   Response'.
  Pid :            To allow msgsvrin to send a signal to msgsvrout in case of
                   data acknowledge.
*/
