/*----

At boot time, a DemonServer is running on the local station.
On a connection request, it launchs a decicated Server which connects to the
corresponding Client and sends an aknowledge.
The Client then sends requests to the Server, and writes the received data on 
disk.
Any request from the Client must be acknoledge by the Server. A timeout
mechanism is implemented in the Client.
The last message from the Client is DISCONNECT. The Server breaks the 
connection and dies.
Then, an Application can be run on the file containing the data.

Server <--> Client messages :
*****************************
  First request from the Client :
        CONNECT : The server must acknowledge by sending :
	          OK          (1 byte)
		  size        (4 bytes)
		  0x01234567  (4 bytes)
  Other commands : answer from the server:
         - valid command :
	          OK          (1 byte)
		  size        (4 bytes)
		  data part   ('size' bytes)
	   (if size= 0 : no data available)
         - if not a valid command :
	          NOK
  Last request :
        DISCONNECT

Remark :
******
  The byte swaping is performed (if needed) in the Application.

Data format on file :
*********************
     0x01234567     : 4 bytes (byte swaping purpose)
  then for each Client request :
     REQUEST        : 1 byte  (see RQTYPE commands below)
     size           : 2 bytes
     data part      : 'size' bytes

  ----*/

#define SERVER_PORT 12345


typedef enum {                  /* Request from Client */
  CONNECT,  
  EVTBUF, MUONBUF, MONITBUF,    /* Get buffers         */
  DSTATUS, DCALIB,      	/* Get data modules    */
  DISCONNECT,
  NOP,				/* Do nothing  	       */ 
  LOOKSTAT, LOOKMON, LOOKMONPK, /* Get selected data   */
  CHANGEDA
} RQTYPE;

typedef enum {                  /* Answers from Sever  */
  OK, NOK, TOUT
} AKTYPE;

