#if !defined(_TRIGIRQ_H_)

#define _TRIGIRQ_H_

/* Gestion des IT de la carte trigger */
/*
  IT 1PPS: ext3
  IT Slow: ext2
  IT Fast: ext1

*/

#define TRIG_VECTOR  5
#define TRIG_PRIOR   1
#define TRIG_IOCR    0x20000000
#define TRIG_IOCR_0  0xCFFFFFFF

#define TRIG_INT_NUM 1

#define TRIG_ENABLE  0x8
#define TRIG_DISABLE 0xFFFFFFF7


/* Fonctions pour acces aux registres de controle des ITs
     exier : external interrupts enable register
     exisr : external interrupts status register
     */
extern u_int32 getexier() ;
extern u_int32 setexier() ;

extern u_int32 getexisr() ;
extern u_int32 setexisr() ;

extern u_int32 getiocr() ;
extern u_int32 setiocr() ;

_asm( "getexier: mfdcr r3,exier
 blr" ) ;
_asm( "setexier: mtdcr exier,r3
 blr" ) ;
_asm( "getexisr: mfdcr r3,exisr
 blr" ) ;
_asm( "setexisr: mtdcr exisr,r3
 blr" ) ;
_asm( "getiocr: mfdcr r3,iocr
 blr" ) ;
_asm( "setiocr: mtdcr iocr,r3
 blr" ) ;

#endif
