/*=======================================================================
  Edition History:                                                      
                                                                        
    Ed.   Date      What happened                                       
    --  --------    --------------------------------------------------- 
    01  95/05/11    Created                                             
    02  96/09/18    Added Stack Check Note                          rkw 
    03  97/01/10    Added PPC -bepg Note                            rkw 
    04  97/01/16    Added E_NOT me + headers ++                     rkw 
    05  97/03/11    Edited                                          jrt
    06  98/01/08    Adaptation au trigger Auger sur PPC403          LG
    07  98/07/28    Modification pour Auger                         LG
    08  00/10/30    Adaptation pour FastTrack fronte end et 1PPS    lgg
=======================================================================

A System State Process which installs an Interrupt Handler


This is a short program that installs an interrupt routine on a vector
and prints a message when an interrupt occurs. It could be  
compilied with: cc irqexample.c -r -bepg -tp=ppc -l=cpu.l -l=sys_clib.l,
you must define the vector # for PPC and and add in the correct -tp for
your processor.
*/

/*--------------------------------------------------------------------------!
! NOTE: This process must be System State!  To compile as a system state    !
!	process you can either specify 'syscstart.r' as the first file on   !
!	the 'link line' in your makefile or if your compiling directly      !
!	with 'cc' you must include the option: '-cs=syscstart.r' on your    !
!	command line. You must also add the -r option to disable stack      !
!       checking. If your are using a machine which does not have direct    !
!       access to the <pc> such as PowerPC's the -bepg option is necessary. !
!	This does not use a data module to display the IRQ's.  This is also !
!	CPU time consuming, as it prints out the number of IRQ's whether    !
!	more have occurred or not.                                          !
!--------------------------------------------------------------------------*/

/*************************************************************************

  Augerirq
    Handle EVTCLKF and 1PPS interrupts:
    1PPS: just signal the event "Evt1PPS"
    EVTCLKF: get a raw buffer, reads the TTAG time stamp, starts the DMA
             readout.

 *********
  $Author: os9 $
  $Date: 2000/11/03 17:20:22 $
  $Revision: 1.3 $

  $Log: augerirq.c,v $
  Revision 1.3  2000/11/03 17:20:22  os9
  Mise a jour pour FE Fasttrack. non teste


*************************************************************************/

#include <types.h>
#include <errno.h>
#include <cglob.h>
#include <signal.h>
#include <events.h>

#include "dmlib.h"
#include "ready_acq.h"
#include "status.h"
#include "augerirq.h"
#include "fastlib.h"
#include "evbdefs.h"
#include "gps_defs.h"

#define AUGERIRQ_VERSION 9

#define ENABLE_PPS_SIGNAL 44
#define DISABLE_PPS_SIGNAL 45
#define ENABLE_FAST_SIGNAL 46
#define DISABLE_FAST_SIGNAL 47

event_id PPSEvId, T1Tg2Id ;
char T1Tg2EvName[128] ;

extern void             *_glob_data;

_asm( "_m_edit: equ %0", __obj_constant( AUGERIRQ_VERSION ) ) ;

/*------------------------------------------------------------------!
! irqfunc: This is the function that is run by the Kernel when the  !
!	   external interrupt fires off.  This function MUST access !
!	   hardware to 'clear down' the interrupt.                  !
!------------------------------------------------------------------*/
irqfunc()
{        
  unsigned int value ;

  /* Check the Interrupt status and see if it is my interrupt */

  if ( (getexier() & AUGER_FAST_ENABLE) &&
       (getexisr() & AUGER_FAST_ENABLE) ) {
    /* EVTCLKF */
    setexisr( AUGER_FAST_ENABLE ) ;
    ItFast() ;
    return SUCCESS ;
  }

  if ( (getexier() & AUGER_PPS_ENABLE) &&
       (getexisr() & AUGER_PPS_ENABLE) ) {
    _os_ev_signal( PPSEvId, &value, 1 ) ;
    setexisr( AUGER_PPS_ENABLE ) ;
    return SUCCESS ;
  }
  return E_NOTME;
}

void
sig_hand()
{
  _os_rte() ;
}

help()
{
  puts( "Syntax  : augerirq" ) ;
  puts( "Function: Handling of EVTCLKF and PPS interrupts and DMA" ) ;
  exit( 1 ) ;
}

initialize()
{

  if ( _os_ev_creat( -1, 1, 0x777, &PPSEvId,
		     PPS_EVENT_NAME, 0, 0 ) != SUCCESS &&
       _os_ev_link( PPS_EVENT_NAME, &PPSEvId ) != SUCCESS ) {
    printf( "Can't Create or Link to the event!\n") ;
    exit( 1 ) ;
  }

  /* Link to status data module
     Link to Fast Buffer
     Link to Slow Buffer */

  if ( FB_init( MAX_FAST_BUFFER ) != SUCCESS ||
       dm_init(
	       StatModName,
	       sizeof( STATUS ),
	       (void **)&StData,
	       &StHeader ) != SUCCESS ) exit( 1 ) ;

  /* Link to T1Tg2 Event
     Link to T1Slow Event */
  strcpy( T1Tg2EvName, StData->event.EvNameT1Tg2 ) ;
  if ( _os_ev_link( T1Tg2EvName, &T1Tg2Id ) != SUCCESS ) {
    printf( "Can't Link to the event!\n") ;
    exit( 1 ) ;
  }
 
}

/*--------------------------------------------------------------------------!
! main: This function sets up the interrupt and signals an event at each    !
!       occurence of the Interrupt.                                         !
!--------------------------------------------------------------------------*/
main( )
{
  int fini = 0 ;
  int loop ;
  u_int16
    vector = AUGER_IRQ_VECTOR,  /* interrupt vector number */
    priority = AUGER_IRQ_PRIOR; /* interrupt priority (0 - 255)	*/
  error_code	error;

  /* Install signal handler */
  _os_intercept( sig_hand, _glob_data ) ;

  /* Link to events and data modules */
  initialize() ;
  printf( "Augerirq %s - %s: vector %d, Prior %d( Success: %d\n",
	  __DATE__, __TIME__,
	  vector, priority, SUCCESS ) ;

  /* Install the interrupt service function	*/
  if ((error = _os_irq(
		       vector,
		       priority,
		       irqfunc,
		       _glob_data ))
      != SUCCESS) {
    /*printf( "Can't install interrupt service function!\n") ;*/
    exit( error ) ;
  }

  /* Setup DMA channels */
  dma_setup() ;

  /* Prepare IOCR and Disable Interrupts */
  setiocr( (getiocr() & AUGER_IRQ_MASK) | AUGER_IRQ_IOCR ) ;
  setexisr( AUGER_IRQ_ENABLE ) ;
  setexier( getexier() & AUGER_IRQ_DISABLE ) ;

  /* Infinite loop. Ends upon signal */
  do {
    unsigned int tt = 0 ;
    signal_code dummy ;

    tt = 0 ;
    dummy = 0 ;
    _os_sleep( &tt, &dummy ) ;

    switch( dummy ) {
    case ENABLE_PPS_SIGNAL:
      /* Clear pending It */
      setexisr( AUGER_PPS_ENABLE ) ;
      setexier( getexier() | AUGER_PPS_ENABLE ) ;
      break ;
    case DISABLE_PPS_SIGNAL:
      setexier( getexier() & AUGER_PPS_DISABLE ) ;
      setexisr( AUGER_PPS_ENABLE ) ;
      break ;
    case ENABLE_FAST_SIGNAL:
      /* Clear pending It */
      setexisr( AUGER_FAST_ENABLE ) ;
      setexier( getexier() | AUGER_FAST_ENABLE ) ;
      break ;
    case DISABLE_FAST_SIGNAL:
      /* Clear pending It */
      setexier( getexier() & AUGER_FAST_DISABLE ) ;
      break ;
    default: fini = 1 ;
      break ;
    }
  } while( fini == 0 ) ;

  /* Disable Interrupts */
  setexier( getexier() & AUGER_IRQ_DISABLE ) ;

  /* Deinstall IRQs */
  _os_irq(
	  AUGER_IRQ_VECTOR,
	  AUGER_IRQ_PRIOR,
	  NULL,
	  _glob_data ) ;

  /* Unlink from Events and data modules */
#if 0
  FB_finish() ;
  dm_finish( &StHeader ) ;
#endif
  _os_ev_unlink( PPSEvId ) ;
  _os_ev_unlink( T1Tg2Id ) ;
  exit( 0 ) ;
}
