/* Function for EVTCLKF trigger */

#include <types.h>
#include <const.h>
#include <errno.h>
#include <cglob.h>
#include <signal.h>
#include <events.h>

#include "augerirq.h"
#include "feevts.h"
#include "fastlib.h"
#include "asiclib.h"
#include "dmalib.h"
#include "gpslib.h"
#include "status.h"

static FAST_EVENT LostEvt ;

extern event_id T1Tg2Id ;

unsigned int
deadtime( TimeStamp *debut, TimeStamp *fin )
{
  if ( fin->nano < debut->nano ) return fin->nano + 10000000 - debut->nano ;
  else return fin->nano - debut->nano ;
}

void
ItFast()
{
  FAST_EVENT *cur ;
  TimeStamp dum0, dum1 ;
  u_int32 nwords, value ;
  int ok ;

  if ( (ok = FB_get( &cur )) != SUCCESS ) cur = &LostEvt ;

  /*get number of words to read */
  /* set first address */
  /*  read GPS time-stamps into buffer */
  GPS_read_fast( &cur->date0, &dum1 ) ;
  /* start Fast DMA */
  dma_set_fast( (u_int32 *)cur->data, nwords ) ;
  dma_start_fast() ;
  /* wait till DMA finished */
  dma_wait_fast() ;
  dma_stop_fast() ;
  /* calculate dead-time using cur->date0 and dum1
     and Store deadtime into status module */
  StData->inter.T1DeadTime += deadtime( &cur->date0, &dum1 ) ;
  if ( ok == SUCCESS ) {
    /* signal T1Tg2 event */
    _os_ev_signal( T1Tg2Id, &value, 1 ) ;
  }
  else {
    /* No Fast buffer available, this event is lost */
    /* increment "Missed triggers" */
    StData->inter.T1FastMiss++ ;
  }
}
