/* Function for EVTCLKS trigger */

#include <types.h>
#include <const.h>
#include <errno.h>
#include <cglob.h>
#include <signal.h>
#include <events.h>

#include "augerirq.h"
#include "fastlib.h"
#include "asiclib.h"
#include "dmalib.h"
#include "gpslib.h"
#include "status.h"


void
ItSlow()
{
  SLOW_EVENT *cur ;
  TimeStamp dum0 ;
  u_int32 nwords ;

  if ( SB_get( &cur ) == SUCCESS ) {
    /* read slow GPS time stamp into buffer */
    GPS_read_slow( &cur->date ) ;
    /* read number of words to read */
    /* read scalers into buffer */
    /* clear asic status */
    asic_clear_trigger( TRIGGER_SLOW ) ;
    /* Start DMA Slow */
    dma_set_slow( (u_int32 *)cur->data, nwords ) ;
    dma_start_slow() ;
    /* Don't wait until dma finished. */
    /* signal T1Slow event */
  }
  else {
    /* read slow GPS into dummy */
    GPS_read_slow( &dum0 ) ;
    /* clear asic status */
    asic_clear_trigger( TRIGGER_SLOW ) ;
    /* increment "slow missed" */
    StData->inter.T1SlowMiss++ ;
  }
}
