/* 
   calib : Local Station Software - Pierre Auger Project
   -------
   Created    01/06/97 - JMB
   Modified : 10/11/98 : Version 2
----------------------------------------------------------------------------*/
#include <errno.h>

#define _STATUS_MAIN_
#include "status.h"


#include "ready_acq.h"
#include "augererr.h"
#include "evbdefs.h"

#define TH 5000
#define SIG_ALARM  14   /* Signal for Cycle Alarm */

void init( void);
void byebye( error_code);

STATUS *st;
int Debug= 1;
signal_code Signal = 0 ;
char StrLog[256];

void
sig_hand( signal_code s )
{
  Signal= s;
  _os_rte();
}


main( int argc, char *argv)
{
  unsigned int nt;
  signal_code dummy;

  init();
  while(1) {                          /* Infinite LOOP */
    nt= 0; _os_sleep( &nt, &dummy);   /* Wait for a signal */
    if( Signal == SIGQUIT) byebye( 2000);
    if( st->RunStatus == REBOOT) break;
    Signal= 0;
  }
  byebye( (error_code) 0);
}


void init( void)
{
  error_code err;
  alarm_id AlarmId;

                                   /* Link to Data Modules        */
  if( dm_init( StatModName, sizeof( STATUS), (void **)&StData, &StHeader)) {
    printf( "calib: Can't create %s data module (errno= %d) *****\n", 
      StatModName, errno);
    exit( (int)0);
  }
  st= StData;
  /* Buffers initialisation */
  printf("calib : Initialisation des buffers\n"); fflush(stdout);
  while((err = EvbInit( &mubid, MU_BUFFER_NAME, MUBSIZE)) == E_KWNMOD);
  if( err) {
    sprintf( StrLog, "calib : EvbInit: err= %d\n", err);
    PrtLog( StrLog, 1);
    exit( (int)0);
  }
  printf("calib : Fin d'initialisation des buffers\n");

                                      /* Set a Cycle Alarm */
  if(( err= _os_alarm_cycle( &AlarmId, SIG_ALARM, 0x800000FF))) {
    sprintf( StrLog, "calib: _os_alarm_cycle(): err= %d\n", err);
    PrtLog( StrLog, 1);
  }
                                   /* Intercept Signals */
  _os_intercept( sig_hand, _glob_data );

  printf( "calib : init ended...\n"); fflush( stdout);
}



void byebye( error_code err)
{
  dm_finish( &StHeader );
  EvbFinish( &mubid);
  sprintf( StrLog, "calib : Ended with error %d\n", err);
  PrtLog( StrLog, 1);
  exit( 0);
}




