/* 
   central : Local Station Software - Pierre Auger Project
   ---------
              JM Brunet, L Gugliemi, C Le Gall, G Tristram
	               College de France - Paris

   Created    01/06/97 - JMB & CL
   Modified : 20/10/97 : Link to 'msgsvrin' & 'msgsvrout' with pipes
                         Send & receive messages with Com. buffer format
              17/11/98 : Version 2
	      03/03/99 : Version 2.2: trigger 2 : Elog | micro (24 bits)
	      01/06/99 :              Change addressing (broadcast)
	      16/03/00 : Version 2.3: Add Suscriber Unit emulation
                                      Change in Frame & Header formats
              Sept 2000: Version 2.6: Add Monitoring, logfile, download
	                              and OS9 commands
	      Oct. 2000: RS-232 Communication Protocol Version 2.0
----------------------------------------------------------------------------*/

#include <stdio.h>
#include <time.h>
#include <process.h>

#include "screen.h"
#include "menu.h"

#define MAIN
#define MYNAME  CS
#define BUFSIZE BUFSIZEX   /* Must fit PROCESS definition (see msgdefs.h) */
#define BELL    '\007'     /* ASCII bell character */

#include "msgdefs.h"
#include "dmlib.h"
#define _STATUS_MAIN_
#include "status.h"
#include "central.h"
#include "central_local.h"
#define _MONITOR_MAIN_
#define _CONFIG_MAIN_
#include "run_config.h"

#include "augererr.h"

void init( void);
int  byebye( error_code);
int dm_clean();
int  DoCommand(     struct menu *mc, struct entry *ep, int level);
int  ShowRunStatus( struct menu *mc, struct entry *ep, int level);
int  ShowFast(  struct menu *mc, struct entry *ep, int level);
int  ShowSlow(  struct menu *mc, struct entry *ep, int level);
int  PreviousMenu(  struct menu *mc, struct entry *ep, int level);
int  TrigManag(     struct menu *mc, struct entry *ep, int level);
int  Trig2Manag(     struct menu *mc, struct entry *ep, int level);
int  trigrate( char *title, int nb);
void prt_bold( char *str);
void prt_so( char *str);
void prt_mag( char *str);
void s_efface( void);
void prt_wait( int);
void Show( void);
void s_message( char *title);
void ResetModuleValues();
u_int32  ReadRS232( void);
void WrtRS232( char su, char flag, char type, unsigned char comp, int length, 
	       unsigned char *buf);
void ReceiveMess( void);
int  DecodeMess( unsigned char flag,  unsigned char type,
	       unsigned char ndata, unsigned char *pcom);
int  DumpRS232( int nb, unsigned char *pcom, char *title);
void DmpFast(FAST_EVENT *pfast);
void DmpT2( int nt2, int *buf);
void DmpT3( void);
void prtmonit( MONITOR *pmonit);
void dmp( char *title, unsigned char *p, int size);
void dimp( char *title, unsigned char *p, int size);
void VerifMess( unsigned char *pcom);
int  Download( void);
void SendOs9Cmd( int);

STATUS  *st;
TRIG1   *t1;
FILE *Fout= NULL, *Frs232;
MESSAGE Message, *pM= &Message, MesT3, *pMT3= &MesT3, MesMuon,*pMuon= &MesMuon;


time_t Cpu=0, CpuStart=0;
signal_code Signal = 0 ;
int IsReady= 0, Trig1Rate= 100, Trig2Rate= 10, MonitRate=0;
int IsDumpRead=0, IsDumpWrite=0;
int Debug= 1, IsCpuStart= 1, IsFast=0, IsSlow=0, IsMuon= 0, Nrec= 0, OldSec= 0;
char *argblk[]= { "trigger1",0,0,0,0,0,};
process_id ChildPid;

int NbT2=0, NbT3=0, NbT3Bad=0, NbT3Mu=0, NbMonitorOk=0;
int NbMonitorBad=0, NbSlices=0;
int Col=40, Line=6, NbRun=0;
int NbFrames=0, FrameLength, TotFrameLength=0;
int NbMess1=0, NbMess2=0, NbMess3=0, NbMess4=0, NbMess0=0;
int IsDownload=0;
unsigned short BSid= 0xbb5, LSid;
unsigned char BSPacketNb= 0, LSPacketNb=0;

typedef struct{
  int ErrorMonit;
  MONITOR Monit;
} MONIT_FRAME;

void
sig_hand( signal_code s )
{
  Signal= s;
  _os_rte();
}


                        
/*******      Definitions for Menu package    **********/
/*            ****************************             */

struct entry nullentry = { EMPTY};

struct entry entry11= { ACTION, " Start T1 ", NULL, DoCommand, NULL,
			START_T1, 0, " Stop  T1 " };
struct entry entry12= { ACTION, " Stop  T1 ", NULL, DoCommand, NULL,
		        STOP_T1, 0, " Change T1 rate " };
struct entry entry13= { GETINT, " Change T1 rate ", NULL,TrigManag, &Trig1Rate,
			1, 5000, " Go to previous menu " };
struct entry entry14= { ACTION, " Go to previous menu ", NULL, PreviousMenu,
                        NULL, 0, 0, PREVIOUS };

struct entry *table_1[]= { &entry11, &entry12,   &nullentry, &nullentry,
			   &entry13, &nullentry, &nullentry, &entry14, NULL };

struct menu menu_1= {
  "***** Trigger 1  Management *****",   /* Menu Title             */
  " Start T1 ",                          /* Default entry          */
  table_1,                               /* Menu entry table       */
  5, 3, 34, 14,                          /* Xul, Yul, Xsize, Ysize */
  EXTENDED,                              /* Big menu wanted        */
  NULL,                                  /* Called at menu display */
  NULL,                                  /* Called at menu entry   */
  NULL                                   /* Called at menu quit    */
};


struct entry entry01= { ACTION, " Start Run ", NULL, DoCommand, NULL,
			START_RUN_REQUESTED, 0, " Pause Run " };
struct entry entry02= { ACTION, " Pause Run ", NULL, DoCommand, NULL,
			PAUSE_RUN_REQUESTED, 0, " Continue Run " };
struct entry entry03= { ACTION, " Continue Run ", NULL, DoCommand, NULL,
			CONTINUE_RUN_REQUESTED, 0, " Pause Run " };
struct entry entry04= { ACTION, " Stop  Run ", NULL, DoCommand, NULL,
			STOP_RUN_REQUESTED, 0, " Start Run " };
struct entry entry05= { ACTION, " Print Event ", NULL, ShowFast, NULL,
			0, 0, " Pause Run " };
struct entry entry06= { MENU, " Trigger 1 ", "Management", &menu_1, NULL,
			0, 0, " Start Run " };
struct entry entry07= { GETINT, " Change T2 rate ",NULL,Trig2Manag, &Trig2Rate,
			0, 20, " Start Run " };
struct entry entry08= { GETINT, " Change Monit rate ",NULL,NULL, 
			&MonitRate,
			0, 20, " Start Run " };
struct entry entry09= { ACTION, " Reboot Local Stations & Exit ", NULL, 
			DoCommand, NULL, REBOOT, 0, " Start Run " };

struct entry *table_0[]= { &entry01, &entry02, &entry03, &entry04,&nullentry,
			   &entry05, &nullentry,
			   &entry06, &entry07, &entry08, &nullentry,
			   &entry09, NULL };

struct menu menu_0= {
  "***** Local Station Control *****",   /* Menu Title             */
  " Start Run ",                         /* Default entry          */
  table_0,                               /* Menu entry table       */
  2, 1, 34, 14,                          /* Xul, Yul, Xsize, Ysize */
  EXTENDED,                              /* Big menu wanted        */
  ShowRunStatus,                         /* Called at menu display */
  NULL,                                  /* Called at menu entry   */
  byebye                                 /* Called at menu quit    */
};



void dmp_mes( void)
{
  u_int32 *p;
  int ndata, n;

  fprintf( Fout,"----- Trigger2 message -----\n");
  fprintf( Fout,"count= %d, type= %d\n", pM->mheader.length, pM->mheader.type);
  p= (u_int32 *)pM->buf;
  ndata= (pM->mheader.length- sizeof( MESSAGE_HEADER) -1)/4;
  fprintf( Fout, "second= %d - ndata= %d\n", *p++, ndata);
  for( n=0; n<ndata; n++) {
    if( !(n % 8)) fprintf( Fout,"\n");
    fprintf( Fout, "%10d", *p++);
  }
  fflush( Fout);
}



void ReceiveMess( void)
{
  int nbfields, nf;
  unsigned char *pcom= BufCom;
  unsigned char completion, type, ndata, version;
                                        /* Message from MsgServer      */
  S_user_live= NULL;
  if( ReadRS232()) {
    VerifMess( pcom);
    pcom= BufCom;
    NbFrames++; FrameLength= *pcom; TotFrameLength += *pcom;
    s_move( Col, Line+11);
    s_printf( "%d Frames = %d bytes [mean= %d]    ", NbFrames, FrameLength,
	      TotFrameLength/NbFrames);
    pcom += 6;                          /* Skip first 6 bytes  */
    nbfields= *pcom++;
    switch( nbfields) {                 /* Just some prints */
    case 1: s_move( Col+5, Line+12); 
      s_printf( "%6d with 1 message", ++NbMess1); break;
    case 2: s_move( Col+5, Line+13); 
      s_printf( "%6d with 2 messages", ++NbMess2); break;
    case 3: s_move( Col+5, Line+14); 
      s_printf( "%6d with 3 messages", ++NbMess3); break;
    case 4: s_move( Col+5, Line+15); 
      s_printf( "%6d with 4 messages", ++NbMess4); 
      break;
    default: s_move( Col+5, Line+16); 
      fprintf( Fout, "*** %d messages in this frame\n", nbfields);
      dmp( "Multi messages frame", BufCom, 150);
      s_printf( "%6d with ??? messages", ++NbMess0); break;
    }
    for( nf=0; nf<nbfields; nf++) {
      ndata= *pcom++ -3;	        /* ndata for data part only */
      completion= *pcom++ & 0xC0;
      type=  *pcom++;
      version= *pcom++;
      DecodeMess( completion, type, ndata, pcom);
      pcom += ndata;
    }
  }
#ifdef DOWNLOAD
  if( IsDownload == 2) Download();
  else if( IsDownload == 1) IsDownload= 2;
#endif
  S_user_live= ReceiveMess;
  if( MonitRate)CfData->MonitParams.Times= MonitRate;
}




int DecodeMess( unsigned char completion,  unsigned char type,
	       unsigned char ndata, unsigned char *pcom)
{
  int n=ndata, ErrorWord;
  static int ErrorMonit;
  error_code err;
  static unsigned char *pbox, *pbt3, *pmu, *pmonit;
  unsigned char *pchar= pcom;
  short evid;
  unsigned char *pbufout;
  static int size, OldNt2;
  u_int32 *messbuf;
  u_int32 nt;
  signal_code dummy;
  char str[100];
  static unsigned int second, micro;
  int nt2, nprevt2;
  time_t tim;
  u_int32 ticks;
  static MONIT_FRAME MonitFrame;
  static unsigned char *pm;
  static FILE *log= NULL;
  static int nos9cmd=0;
  static unsigned char FirstBufCom[PACKETSIZE], *firstbufcom= FirstBufCom;
  static unsigned char NextBufCom[PACKETSIZE], *nextbufcom= NextBufCom;
 
  switch( completion) {
  case COMPLETION_ALL :         /*** Start saving data ***/
  case COMPLETION_FIRST:
    if( type == M_T3_EVT) {
      pMT3->mheader.length= ndata+ sizeof( MESSAGE_HEADER);
      pMT3->mheader.type= type;
      pbt3= pMT3->buf;
      while( n--) *pbt3++= *pcom++;
      IsFast= 0;
    }
    else if( type == M_T3_MUONS) {
      pMuon->mheader.length= ndata+ sizeof( MESSAGE_HEADER);
      pMuon->mheader.type= type;
      pmu= pMuon->buf;
      while( n--) *pmu++= *pcom++;
      IsMuon= 0;
    }
    else if( type == M_MONIT_REQ_ACK || type == M_MONIT_SEND) {
      pcom += 4;     /* skip Monit Identifier */
      pmonit= (unsigned char *)&MonitFrame;
      memcpy( pmonit, pcom, n);
      memcpy( firstbufcom, BufCom, 150);
      pmonit += n;
    }
    else {
      pM->mheader.length= ndata+ sizeof( MESSAGE_HEADER);
      pM->mheader.type= type;
      pbox= pM->buf;
      while( n--) *pbox++= *pcom++;
    }
    break;
  case COMPLETION_NEXT:         /*** Continue to save the data */
  case COMPLETION_LAST:
    if( type == M_T3_EVT) {
      pMT3->mheader.length += ndata;
      while( n--) *pbt3++= *pcom++;
      if( completion  == COMPLETION_LAST) IsFast= 1;
    }
    else if( type == M_T3_MUONS) {
      pMuon->mheader.length += ndata;
      while( n--) *pmu++= *pcom++;
      if( completion  == COMPLETION_LAST) IsMuon= 1;
    }
    else if( type == M_MONIT_REQ_ACK || type == M_MONIT_SEND) {
      if( completion == COMPLETION_NEXT) memcpy( nextbufcom, BufCom, 150);
      memcpy( pmonit, pcom, n);
      if( completion == COMPLETION_NEXT) pmonit += n;
    }
    else {
      pM->mheader.length += ndata;
      while( n--) *pbox++= *pcom++;
    }
    break;
  }
  switch( type) {       /*** Work depending on Type ***/
  case M_READY:
    IsReady= 1; prt_wait( 0);
    t1->IsTrig1= 1;     /* 28/10/99 : TO BE CHANGED : Enable triggers */
    pbufout= Message.buf;
    WrtRS232( 'D', 0, M_LOG_REQ, 0, COMPLETION_ALL, (unsigned char *)pbufout);
    s_message( "Message M_READY received");
    Show();
    MonitRate= CfData->MonitParams.Times; /* 03/11/99 */
    s_move( 5, Line+15); s_printf( "Version : 22/01/2001");
    /* ajout BR */
    s_move( 5, Line+16); s_printf( "LS address : %x",(*(BufCom+4)<<8)|(*(BufCom+5)));
    break;
  case M_RUN_START_ACK:
    s_move( Col, Line-1); s_printf( "*** Run %d ***", ++NbRun);
    t1->Cpu_start_run= time( NULL);
    s_message( "Message M_RUN_START_ACK received");
    Show();
    break;
  case M_RUN_PAUSE_ACK:
    s_message( "Message M_RUN_PAUSE_ACK received");
    Show();
    break;
  case M_RUN_CONTINUE_ACK:
    s_message( "Message M_RUN_CONTINUE_ACK received");
    Show();
    break;
  case M_RUN_STOP_ACK:
    s_message( "Message M_RUN_STOP_ACK received");
    Show();
    break;
  case M_T2_YES:
    s_message( "Message M_T2_YES received");
    if( completion != COMPLETION_NEXT && completion != COMPLETION_LAST) {
      nt2= (ndata-4)/3;
      second= *(int *)pM->buf;
      micro= *(int *)(pM->buf+4);
      micro = (micro >> 8) & 0xFFFFF;
      t1->T2Sec= second;
      if( !OldSec) { OldSec= second; OldNt2= nt2; }
      else if( second != OldSec+1) {
	fprintf( Fout, "Error for record %d : sec=%d, prev sec= %d\n", 
		 Nrec, second, OldSec);
	s_move( 10, 30); s_printf( "Error for record %d: sec=%d, prev sec= %d",
				   Nrec, second, OldSec);
	fprintf( Fout, "     Prev Nt2= %d - Current NT2= %d\n", OldNt2, nt2);
	fflush( Fout);
      }
      OldSec= second;
      OldNt2= nt2;
    }
    else {
      nt2= (ndata+2)/3;
    }
    NbT2 += nt2;
    s_move( Col, Line); s_printf( "  T2  =%10d  [Second=%10d]", NbT2,second);
    s_move( Col, Line+1); 
    s_printf( "                   [ Mean =%10d]", NbT2/second);
    t1->T2Rec += nt2;
    if( completion == COMPLETION_NEXT || completion == COMPLETION_LAST) break;
                                                   /* Fake trigger 3 */
    if( !t1->IsT3evt && !t1->IsMuonEvt && prob( 85)) {
      t1->T3Send++;
      evid= t1->T3Send & 0X3F;
      pbufout= Message.buf;
      memcpy( pbufout, &evid,   2); pbufout += 2;  /* EventID */
      memcpy( pbufout, &second, 4); pbufout += 4;
      memcpy( pbufout, &micro,  4); pbufout += 4;
      *pbufout++= 0; *pbufout++= 1;                /* microRef, Dmicro */
      *pbufout++= 0; *pbufout++= 2;
      *pbufout++= 0; *pbufout++= 3;
      *pbufout++= 0; *pbufout++= 4;
      WrtRS232( 'D', 2, M_T3_YES, COMPLETION_ALL, pbufout- Message.buf, 
		Message.buf);
    }
    break;
  case M_T3_EVT : case M_T3_MUONS :
    s_message( "Message M_T3_EVT or M_T3_MUONS received");
    switch( completion) {
    case COMPLETION_FIRST:
    case COMPLETION_ALL :
      if( type == M_T3_EVT) {
	s_move( Col, Line+2); NbSlices=0;
	s_printf( "T3 OK =%10d  [Second=%10d]", ++NbT3,second);
      }
      else {
	s_move( Col, Line+4); NbSlices=0;
	s_printf( "T3 Mu =%10d  [Second=%10d]", ++NbT3Mu,second);
      }
      s_move( Col, Line+3);
      s_printf( "                   [Slices=%10d]", ++NbSlices);
      size= ndata;
      if( type == M_T3_MUONS) t1->MuonSlides= 1;
      else                   t1->T3Slides= 1;
      if( completion == COMPLETION_ALL) {
	t1->IsT3evt=1;
	if( type == M_T3_MUONS) {
	  t1->MuonSize += size / 1000.;
	  t1->IsMuonEvt= 0;
	}
	else {
	  t1->T3size += size / 1000.;
	}
      }
      else {
	if( type == M_T3_MUONS) {
	  t1->T3RecSec= *(int *)pMuon->buf;
	  t1->IsMuonEvt=1;
	}
	else {
	  t1->T3RecSec= *(int *)(pMT3->buf+4);
	}
	t1->T3Diff= st->inter.FastSec- t1->T3RecSec;
      }
      if( completion == COMPLETION_FIRST) break;
    case COMPLETION_LAST:
    case COMPLETION_NEXT:
      s_move( Col, Line+3);
      s_printf( "                   [Slices=%10d]", ++NbSlices);
      if( completion != COMPLETION_ALL) {
	size += ndata;
	if( type == M_T3_MUONS) t1->MuonSlides++;
	else                   t1->T3Slides++;
      }
      if( completion == COMPLETION_NEXT) break;
      if( type == M_T3_MUONS) {
	t1->MuonSize += size / 1000.;
	t1->IsMuonEvt= 0;
	ErrorWord= *(short *)(pMuon->buf+sizeof(short));
      }
      else {
	t1->T3size += size / 1000.;
	t1->IsT3evt=0;
	ErrorWord= *(short *)(pMT3->buf +sizeof(short));
      }
      if( type == M_T3_EVT) {
	t1->T3Rec++;
	s_move( Col, Line+5);
	if( ErrorWord != NO_ERROR) 
	  s_printf( "T3 Bad=%10d  [Second=%10d]", ++NbT3Bad,second);
	switch( ErrorWord) {
	case NO_ERROR : t1->T3OK++; break;
	case M_T3_LOST :  fprintf( Fout, "--> T3 Lost : second= %d\n", second);
	  t1->T3Lost++;     break;
	case M_T3_NOT_FOUND : 
	  fprintf( Fout, "--> T3 not found : second= %d\n", second);
	  t1->T3NotFound++; break;
	case M_T3_TOO_YOUNG : 
	  fprintf( Fout, "--> T3 too young : second= %d\n", second);
	  t1->T3TooYoung++; break;
	default: 
	  fprintf( Fout, "--> M_T3_EVT received with ErrorWord unknwn : %d\n",
		   ErrorWord);
	  DumpRS232( BUFCOMSIZE, BufCom, "Error");
	  break;
	}
     } 
      else if( type == M_T3_MUONS) t1->T3Muon++;
      break;
    }
    /*    if( completion == COMPLETION_LAST) DmpT3(); */
    break;
  case M_CONFIG_SET_ACK:
    break;
  case M_MONIT_REQ_ACK: case M_MONIT_SEND:
    s_message( "Message M_MONIT_SEND received");
    if( completion != COMPLETION_ALL && completion != COMPLETION_LAST) break;
    if( MonitFrame.ErrorMonit != BUFFER_OK) {
      fprintf( Fout, "Monitoring buffer NOT available!!!\n"); fflush( Fout);
      s_move( Col, Line+7); s_printf( "Mon No=%10d", ++NbMonitorBad);
      dmp( "First frame:", firstbufcom, 150);
      dmp( "Next frame:", nextbufcom, 150);
      dmp( "Actual frame:", BufCom, 150);
      dmp( "Monitoring buffer:",(unsigned char *)&MonitFrame, sizeof( MONIT_FRAME));
      break;
    }
    /* prtmonit( &MonitFrame.Monit); */
    s_move( Col, Line+6); s_printf( "Mon OK=%10d  [Second=%10d]", 
				    ++NbMonitorOk, MonitFrame.Monit.Second);
    break;
  case M_CALIB_REQ_ACK: case M_CALIB_SEND:
    break;
  case M_DOWNLOAD_ACK:
    s_message( "Message M_DOWNLOAD_ACK received");
    Show();
    SendOs9Cmd( 1);
    break;
  case M_LOG_SEND:
    s_message( "Message M_LOG_SEND received");
    switch( completion) {
    case COMPLETION_FIRST: case COMPLETION_ALL :
      if( log == NULL) {
	if((log= fopen( "fromls.log", "w")) == NULL) {
	  fprintf( Fout, "Can't open fromls.log");
	  break;
	}
      }
      ndata -=4;
      fprintf( log, "\n---> Start receiving logfile (ndata= %d)", ndata);
      fprintf( log, " [Comp= %x]\n", *pchar);
      pchar += 4;
      break;
    case COMPLETION_NEXT: case COMPLETION_LAST:
      fprintf( log, "\n---> Continuing receiving logfile (ndata= %d)", ndata);
      break;
    }
    if( !log) break;
    for( n=0; n<ndata; n++) fprintf( log, "%c", *pchar++);
    if( completion == COMPLETION_ALL || completion == COMPLETION_LAST) {
      if ( *pM->buf == COMPLETION_ALL || *pM->buf == COMPLETION_LAST) {
	fclose( log);
	log= NULL;
#ifdef DOWNLOAD
	Download();
#endif
      }
      else {
	pbufout= Message.buf;
	WrtRS232( 'D', 0, M_LOG_REQ, COMPLETION_ALL, 0, 
		  (unsigned char *)pbufout);
      }
    }
    break;
  case M_OS9_CMD_ACK:
    memcpy( &n, pchar, 4);
    sprintf( str, "M_OS9_CMD_ACK : return code= %d", n);
    s_message( str);
    switch (nos9cmd++) {
    case 0: sleep( 1); SendOs9Cmd( 2); break;
    case 1: sleep( 1); SendOs9Cmd( 3); break;
    }
    break;
  case M_UNKNOWN:
  default:
    sprintf( str, "%cUnknown Message: type= %d (%d) [%d]",
	     BELL, pM->mheader.type, type, M_READY);
    s_message( str);
    fprintf( Fout, "%s\n", str); fflush( Fout);
    DumpRS232( BUFCOMSIZE, BufCom, "Read");
    break;
  }
  t1->ticks= 100/Trig1Rate;
  if( t1->ticks < 2) t1->ticks= 2;
  t1->rate = Trig1Rate;
  t1->ratet2 = Trig2Rate;
}





main( int argc, char *argv)
{
  error_code err= 0;

  init();
  t1->Hz= Trig1Rate;
  S_user_live= ReceiveMess;
  mp_start( &menu_0);
  byebye( err);
}



void init( void)
{
  error_code err;
  post_notify mode= {POST_NTFY_NONE, 0, 0};
  signal_code dummy;
  u_int32 t;
  char orphan= 0;
  u_int16 type_lang= mktypelang( MT_PROGRAM, ML_OBJECT);

  if(( Fout= fopen( "/dd/central.log", "w")) == NULL) {
    printf( "Can't open file '/dd/central.log'\n");
    exit( (int)0);
  }
  fprintf( Fout, "MESSAGE size= %d\n", sizeof( MESSAGE)); fflush( Fout);
  if( !s_init( NULL)) {
    puts( "You must have a TERMCAP file as well as a variable TERM");
    puts( "in the environment to run this program\007");
    exit( (int)0);
  }
  s_erase();
                                   /* Link to Data Modules        */
  if( dm_init( StatModName, sizeof( STATUS), (void **)&StData, &StHeader)) {
    fprintf( Fout, "***** Can't create %s data module (errno= %d) *****\n", 
      StatModName, errno); fflush( Fout);
    exit( (int)0);
  }

  if( dm_init( T1ModName, sizeof( TRIG1), (void **)&T1Data, &T1Header)) {
    fprintf( Fout, "***** Can't create %s data module (errno= %d) *****\n", 
      T1ModName, errno); fflush( Fout);
    exit( (int)0);
  }
  
  if( dm_init( ConfigModName, sizeof( CONFIG), 
	       (void **)&CfData, &CfHeader)) {
    fprintf( Fout, "***** Can't create %s data module (errno= %d) *****\n", 
      ConfigModName, errno);
    exit( (int)0);
  }

  MonitRate= CfData->MonitParams.Times;
  st= StData;
  t1= T1Data;
  t1->ticks= 5;
  Trig1Rate= 100;
  Trig2Rate= 20;
  t1->IsTrig1= 0;
  t1->IsT3evt=0;

/* Open pipe on RS232 line */
  if( (Frs232= fopen( RS232FromCentral, "w")) == NULL) {
    fprintf( Fout, "Cant't open %s pipe \n", RS232FromCentral);
    byebye( errno);
  }
  else fprintf( Fout, "pipe %s opened in write mode \n", RS232FromCentral);
                        /* Start the whole acquisition by starting control */
  if(( err= system( "control >-/dd/control.log&")) != 0) {
    fprintf( Fout, "***** central : Can't fork control : error %d :", err);
    fprintf( Fout, "%s\n", strerror( err)); fflush( Fout);
    byebye( err);
  }
  if( Debug) fprintf( Fout, "process 'control' forked\n"); fflush( Fout);

  _os_exec( _os_fork, 65000, 3, argblk[0],
	    argblk, _environ,
	    0, &ChildPid, type_lang, orphan);
  if( Debug) fprintf( Fout, "process 'trigger1' forked\n"); fflush( Fout);
                                   /* Intercept Signals  */

  _os_intercept( sig_hand, _glob_data );

  S_read_replace= S_REPLACE;
                                   /* Wait sometime.... */
  t=10;_os_sleep(&t,&dummy);
}




int byebye( error_code err)
{
  error_code unload_error=0;
  unsigned int count=0;
  fprintf( Fout, "Starting byebye()\n"); fflush( Fout);
  t1->ticks= 0;
  dm_finish( &StHeader );
  dm_finish( &T1Header);
  s_bottom();
  s_deinit();
  _os_send( ChildPid, SIGQUIT);


  dm_clean();  /* ajout BR-FC */

  fprintf( Fout, "**** central : byebye ended....\n"); fflush( Fout);

  exit( (int) errno);
}

int dm_clean()
{
  unsigned int auger_size=19;
  unsigned int i,j,count;
  error_code unload_error;
  char *system_dm_list[]=
  {
    "csl",
    "dd",
    "ftpdc",
    "netdb",
    "pipe",
    "pipeman",
    "ram",
    "rbf",
    "socket",
    "sockman"
  };
  unsigned int system_link[]={1,2,1,2,1,1,2,2,1,1};
  unsigned int system_size=10;
  char *auger_dm_list[]=
  {
    "StatModName",
    "ConfigModName",
    "T1ModName",
    "SvrModName",
    "CalMonMsg",
    "Config",
    "CtrlMsg",
    "DMFast",
    "DMSlow",
    "EvtBuffer",
    "EvtSvrMsg",
    "MonitBuffer",
    "MsgCalMon",
    "MsgCtrl",
    "MuBuffer",
    "SvrDm",
    "Status",
    "Trg2Msg",
    "Trig1"
  };
  char event_to_kill[]="T1Mu";
  char *cmd;
  sprintf(cmd,"events -k%s",event_to_kill);
  /* kill event_to_kill */
  system(cmd);
  for( i=0;i<auger_size;i++ )
    {
      unload_error=0;
      count=0;
      while( !unload_error )
	{
	  unload_error=_os_unload(auger_dm_list[i],0);
	  count++;
	}
    }
  printf("Auger Data Modules unloaded\n");
  fflush(stdout);

  for( i=0;i<system_size;i++ )
    {
      unload_error=0;
      count=0;
      for( j=0;j<system_link[i];j++ )
	{
	  _os_unload(system_dm_list[i],0);
	  count++;
	}
    }
 printf("System Data Modules unloaded\n");
 printf("Event killed\n");
 fflush(stdout);

 return 0;
}

int DoCommand( struct menu *mc, struct entry *ep, int level)
{
  char str[80];
  unsigned int temp= 0;
  u_int32 *pbufout;
  u_int32 t;
  signal_code dummy;
  time_t tim;
  u_int32 ticks;

  pbufout= (u_int32 *)Message.buf;
  switch( ep->min) {
  case START_RUN_REQUESTED :
    if( st->RunStatus != RUN_STOPPED && 
	st->RunStatus != WAIT_STATE) {
      sprintf( str, "%cRun must be STOPPED !!!!", BELL);
      s_message( str);
      break;
    }
    OldSec=0;
    ResetModuleValues();
    st->RunStatus= START_RUN_REQUESTED;
    WrtRS232( 'D', 0, M_RUN_START_REQ, COMPLETION_ALL, 0, 
	      (unsigned char *)pbufout);
    Show();
    t1->Cpu_start_run= time( NULL);
    break;
  case PAUSE_RUN_REQUESTED :
    if( st->RunStatus != RUN_STARTED) {
      sprintf( str, "%cRun must be STARTED !!!!", BELL);
      s_message( str);
      break;
    }
    OldSec=0;
    st->RunStatus= PAUSE_RUN_REQUESTED;
    /* 28/10/99        t1->IsTrig1= 0; */
    t=10; _os_sleep(&t,&dummy);
    WrtRS232( 'D', 1, M_RUN_PAUSE_REQ, COMPLETION_ALL, 0, 
	      (unsigned char *)pbufout);
    Show();
    break;
  case CONTINUE_RUN_REQUESTED:
    if( st->RunStatus != RUN_PAUSED) {
      sprintf( str, "%cRun must be PAUSED !!!!", BELL);
      s_message( str);
      break;
    }
    st->RunStatus= CONTINUE_RUN_REQUESTED;
    WrtRS232( 'D', 3, M_RUN_CONTINUE_REQ, COMPLETION_ALL, 0, 
	      (unsigned char *)pbufout);
    OldSec=0;
    Show();
    break;
  case REBOOT :
    st->RunStatus= REBOOT;
    WrtRS232( 'D', 1, M_REBOOT, 0, COMPLETION_ALL, (unsigned char *)pbufout);
    fprintf( Fout, "Message M_REBOOT sent\n"); fflush( Fout);
    sleep( 1);
    byebye( (error_code)0);
    break;
  case START_T1:
    if( IsCpuStart)CpuStart= time( NULL);
    IsCpuStart= 0;
    t1->IsTrig1= 1; 
    Show();
    break;
  case STOP_RUN_REQUESTED:
    if( st->RunStatus != RUN_PAUSED) {
      sprintf( str, "%cRun must be PAUSED !!!!", BELL);
      s_message( str);
      break;
    }
    st->RunStatus= STOP_RUN_REQUESTED;
    WrtRS232( 'D', 0, M_RUN_STOP_REQ, COMPLETION_ALL, 0, 
	      (unsigned char *)pbufout);
    Show();
    break;
  case STOP_T1:
    t1->IsTrig1= 0;
    Show();
    break;
  }
  return( 0);
}


void ResetModuleValues()
{
  int n;
  t1->TotT1= 0;
  t1->T1Lost= 0;
  t1->T1BufNb= 0;
  t1->StopT1= 0;
  IsCpuStart= 1;
  t1->T2Rec= t1->T3Rec= t1->T3Send= t1->T3Lost= 0;
  t1->T3Muon= 0;
  t1->T3OK= t1->T3NotFound= t1->T3TooYoung= 0;
  t1->T3size= t1->MuonSize= 0;
  t1->IsT3evt= t1->IsMuonEvt= 0;
  t1->T3Slides= t1->MuonSlides= 0;
  t1->MaxFEB= 0; t1->MinFEB=99999;
}


int PreviousMenu( struct menu *mc, struct entry *ep, int level)
{
  return( 1);
}



int ShowRunStatus( struct menu *mc, struct entry *ep, int level)
{
  if( !IsReady) { prt_wait( 1); return( 0); }
  Show();
  return(0);
}


int ShowFast( struct menu *mc, struct entry *ep, int level)
{
  FAST_EVENT *pbuf;
  int n, line;
 
  if( st->RunStatus != RUN_STOPPED &&  st->RunStatus != RUN_PAUSED) {
    s_message( "Run must be paused or stopped !!!!....");
    return( 0);
  }
  if( !IsFast){ 
    s_message( "No event available !!!!!Come back later ....");
    return 0;
  }
  pbuf= (FAST_EVENT *)( pMT3->buf + sizeof( int));
  s_erase(); s_move( 0,0);
  printf( "           *****    Fast   Buffer     *****\n");
  printf( "           ********************************\n\n");
  printf( "TimeStamp : second= %d ($%X) - nano= $%x\n", 
	  pbuf->datep.second, pbuf->datep.second, pbuf->datep.nano);
  printf( "TimeStamp : second= %d ($%X) - nano= $%x\n", 
	  pbuf->date0.second, pbuf->date0.second, pbuf->date0.nano);
  printf( "TimeTag   : %d\n", pbuf->time_tag);
  printf( "Trigger Status : $%X\n", pbuf->T2T1_type);
  printf( "Sample number  : %d\n", pbuf->nsamples);
  line= 7;
  for( n=0; n<pbuf->nsamples; n++) {
    if( line > S_lines-2 ) {
      if( halt_pto( 1)) break;
      line= 7;
      s_move( 0, line);
      s_eod();
    }
    line++; printf( "%6d - ", n);
    printf( "%02X%02X%02X%02X ", 
	    pbuf->data[n].sumd8, pbuf->data[n].pmt3,
	    pbuf->data[n].pmt2, pbuf->data[n].pmt1);
    printf( "%04X%02X%02X\n", 
	    pbuf->data[n].time_tag,
	    pbuf->data[n].lowd8, pbuf->data[n].low);
  }
  halt_pto( 1);
  s_erase();
  M_redraw= CURRENT;
  return 0;
}



int TrigManag( struct menu *mc, struct entry *ep, int level)
{
  t1->ticks= 100/Trig1Rate;
  if( t1->ticks < 2) t1->ticks= 2;
  t1->rate = Trig1Rate;
  if( Trig1Rate > 1) t1->Hz= Trig1Rate;
  s_efface();
  return 0;
}




void Show( void)
{
  char s[80];
  
  s_move( 40, 2); s_eol();
  strcpy( s, "Run Status : "); prt_so( s);
  switch( st->RunStatus) {
  case WAIT_STATE:             strcpy( s, "Wait State");             break;
  case START_RUN_REQUESTED:    strcpy( s, "Start Run Requested");    break;
  case RUN_STARTED:            strcpy( s, "Run in Progress");        break;
  case STOP_RUN_REQUESTED:     strcpy( s, "Stop Run Requested");     break;
  case RUN_STOPPED:            strcpy( s, "Run Stopped");            break;
  case PAUSE_RUN_REQUESTED:    strcpy( s, "Pause Run Requested");    break;
  case RUN_PAUSED:             strcpy( s, "Run Paused");             break;
  case CONTINUE_RUN_REQUESTED: strcpy( s, "Continue Run Requested"); break;
  default:                     strcpy( s, "Unknown !!!!!");          break;
  }
  s_move( 55, 2); s_printf( "%s", s); s_move( 55, 3); s_eol();
  if( !t1->IsTrig1) s_printf( "%s", "Trigger1 Stopped");
  else              s_printf( "%s", "Trigger1 Started");
}


int trigrate( char *title, int nb)
{
  double rate;
  
  s_printf( title);
  Cpu= time( NULL)- CpuStart;
  if( !Cpu) {
    s_printf( "0");
    return 0;
  }
  rate= 1.*nb / Cpu;
  s_printf( "%6d events - %6.2f Hz", nb, rate);
}

void prt_bold( char *str)
{
    s_start_bold();
    s_puts( str);
    s_stop_bold();
}


void prt_so( char *str)
{
    s_start_so();
    s_puts( str);
    s_stop_so();
}




void prt_mag( char *str)
{
    s_start_so(); s_start_bold();
    s_puts( str);
    s_stop_so() ; s_stop_bold();
}




void prt_wait( int par) 
{
    int col=2, line=19, n;

    if( par) {
        s_move( col, line++);
        s_rect( 50, 4, 0, 0, 0);
        s_move( col+1, line++);
        prt_mag( " Be patient please - Don't touch anything ");
        s_move( col+1, line++);
        s_start_so();
        s_printf( "        Local Station not ready           ");
        s_stop_so();
        s_bottom();
    }
    else for( n=0 ; n<4 ; n++) {
        s_move( col, line++);
        s_eol();
        s_bottom();
    }
}



void s_efface()
{
    s_move( 0, S_com_line);     s_eol();
    s_move( 0, S_com_line+1);   s_eol();
}


void s_message( char *title)
{
  s_move( 40, 15); s_eol();
  if( strlen( title)) prt_so( title);
}


u_int32 ReadRS232( void)              /* Read RS232 -> BufCom */
{
  static int first= 1;
  u_int32 nb, m, type;
  u_int32 nt, ndata;
  static FILE *fin= NULL;
  signal_code dummy;
  error_code err;
  unsigned char *pcom;

  if( first) {                        /* Open pipe on RS232 */
    while( !(fin= fopen( RS232ToCentral, "r"))) {
      nt=10;_os_sleep(&nt,&dummy);
      first++;
      if( first <100) continue;
      fprintf( Fout, "Can't open %s pipe on RS232 : error %d\n", 
	      RS232ToCentral, errno);
      byebye( errno);
    }
    fprintf( Fout, "pipe %s opened in read mode \n", RS232ToCentral);
    fflush( Fout);
    first= 0;
  }
                                      /* Are some data to read ? */
  if( (err=_os_gs_ready( fileno(fin), (void *)&ndata))) {
    if( err != 246) {
      fprintf( Fout, "error %d calling _os_gs_ready()\n", err);
      fflush( Fout);
    }
    return 0;
  }
                                      /* Is all preamble here ? */
  if( ndata < 11) return 0;
  nb= 11; _os_read( fileno( fin), BufCom, &nb);
  type= BufCom[10];
  nb=   BufCom[9]-1;
  if( type == 'D' || type == 'd')
    {
      m=3; _os_read( fileno( fin), BufCom, &m);
      nb -= 3;
      pcom= BufCom;
    }
  if( type == 'D')
    {
      LSid= *(unsigned short *)pcom;
      LSPacketNb= *(pcom+2);
    }
  if( type == 'd')
    {
      /*      BSid= *(unsigned short *)pcom;
	      BSPacketNb= *(pcom+2);          */
    }
  /* read BUFCOMSIZE data from pipe */
  if( (err= _os_read( fileno( fin), BufCom, &nb)))
    {
      fprintf( Fout, "error %d calling _os_read (%d word read)\n", err, nb);
      fflush( Fout);
      return 0;
    }
  if( type != 'D') return 0;
  Nrec++;
  WrtRS232( 'd', 2, 0, COMPLETION_ALL, 0, BufCom);  /* send data acknowledge */
  return nb;
}

                                           /* Send Communication Record */
void WrtRS232( char su, char flag, char type, unsigned char comp, int length, 
	       unsigned char *messbuf)
{
  unsigned char *p, framelength;
  short BroadCast= 0xC000;
  u_int32 nb;
  error_code err;
  static unsigned char buf[BUFCOMSIZE+20];
  unsigned long crc;
  static unsigned char slice;
  static dwnl=0;

  strcpy( buf, "  !SU2LS!");               /* Preamble */
  p= buf+9;
  framelength= length+ 7+ 2;               /* Frame length */
  if( flag == 2 || flag == 3) framelength += 8;
  *p++= framelength+7;
  if( su == 'D' || su == 'd') *(p-1)= framelength+10;
  *p++= su;                                /* SU type */
  nb= framelength+17;
  if( su == 'D') {            /* Station ID + Packet Number */
    *(unsigned short *)p= BSid;
    p += 2;
    *p++= BSPacketNb;
    BSPacketNb++;
    nb += 3;
  }
  if( su == 'd') {
    *(unsigned short *)p= LSid;
    p += 2;
    *p++= LSPacketNb;
    nb += 3;
  }
  *p++= framelength;
  p += 3;                                  /* reserved bytes */
  switch( flag) {                          /* Destination */
  case 0:                                  /* Single address */
    /*    dmp("case 0 : ",BufCom,150);*/
    /* *p++= 0xA; *p++= 0xA5; break;*/
    *p++=*(BufCom+4); *p++=*(BufCom+5); break;
  case 1:                                  /* Broadcast */
    *p++= 0xC0; *p++= 0X00; break;
  case 2:                                  /* station list */
    *p++= 0x40; *p++= 0x04;
    *p++= 0; *p++= 0;
    *p++= 0; *p++= 0;
    /*    *p++= 0x0A; *p++= 0xA5; */ /* JMB : 22/01/2001 */
    *p++=*(BufCom+4); *p++=*(BufCom+5);
    *p++= 0; *p++= 0; break;
  case 3:
    *p++= 0x80; *p++= 0x04;
    *p++= 0; *p++= 0;
    *p++= 0; *p++= 0;
    *p++= 0x0A; *p++= 0xA6;
    *p++= 0; *p++= 0; break;
  }
  *p++= length+3;                          /* Message length */
  if( comp == COMPLETION_FIRST || comp == COMPLETION_ALL) 
    slice= 0;
  else slice++;
  slice = slice % 64;
  *p++= comp | slice;                      /* completion | slice */
  *p++= type;                              /* message type */
  *p++= 1;                                 /* Version */
  while( length--) *p++= *messbuf++;       /* All data */
  crc= crc32( buf+9, p-buf-9);             /* Write CRC */
  memcpy( p, &crc, 4); p += 4;
  *p= 0xFF;                                /* Write ETX */
  _os_write( fileno( Frs232), buf, &nb);   /* Send message */
}


int halt_pto( int pto)
{
  int c;

  fflush( stdout);
  if( pto) {
    s_move( S_columns-10, S_lines-1);
    s_start_so();
    s_printf( "PTO ...");
    s_stop_so();
  }
  c= s_getc();
  if( pto) {
    s_move( S_columns-10, S_lines-1);
    s_eol();
  }
  if( c == 'q' || c == 'Q' || c == 's' || c == 'S') return 1;
  else return 0;
}


int DumpRS232( int nb, unsigned char *pcom, char *title)
{
  int m;

  fprintf( Fout, "----- %s : %d data ------------", title, nb);
  for( m=0; m<nb; m++) {
    if( !(m % 20)) fprintf( Fout, "\n");
    fprintf( Fout, "%3X", *pcom++);
  }
  fprintf( Fout, "\n");
  fflush( Fout);
  return 1;
}


int Trig2Manag( struct menu *mc, struct entry *ep, int level)
{
  t1->ratet2 = Trig2Rate;
  s_efface();
  return 0;
}


void DmpFast(FAST_EVENT *pfast)
{
  FAST_SAMPLE *ps;
  int n;

  fprintf( Fout, "***** T3 event dump *****\n");
  fprintf( Fout, "         second= %d - nano= %d\n", pfast->date0.second,
	  pfast->date0.nano);
  fprintf( Fout, "         TimeTag= %d - T1T2type= %d (%d samples)\n", 
	  pfast->time_tag, pfast->T2T1_type, pfast->nsamples);
  for( n=0; n<pfast->nsamples; n++) {
    ps= &pfast->data[n];
    fprintf( Fout, "%2X %2X %2X %2X %4X %2X %2X\n", ps->sumd8, ps->pmt3, 
	    ps->pmt2, ps->pmt1, ps->time_tag, ps->lowd8, ps->low);
  }
  fflush( Fout);
}

void DmpT2( int nt2, int *buf)
{
  int n;

  fprintf( Fout, "---- T2 buffer : %d samples", nt2);
  for( n=0; n<nt2; n++) {
    if( !(n % 10)) fprintf( Fout, "\n");
    fprintf( Fout, "%8d", *buf++);
  }
  fprintf( Fout, "\n");
}

void DmpT3( void)
{
  unsigned char *pt= pMT3->buf;
  int i, n= pMT3->mheader.length;

  fprintf( Fout, "T3 buffer length= %d", n);
  for( i= 0; i<n; i++) {
    if( !(i % 20)) fprintf( Fout, "\n");
    fprintf( Fout, "%3X", *pt++);
  }
  fprintf( Fout, "\n");
}
  
void prtmonit( MONITOR *pmonit)
{
  int n;
  unsigned int k;
  char diag[5];
  unsigned short chan;

  fprintf( Fout, " *** Monitoring Buffer ***\n");
  fprintf( Fout, "     Second= %d - ItemNb= %d - Summary= $%08X\n", 
	   pmonit->Second, pmonit->ItemNb, pmonit->Summary);
  fprintf( Fout, " ADCs :");
  k=1;
  for( n=0; n<NADC; n++) {
    if( !(n % 4)) fprintf( Fout, "\n");
    strcpy( diag, "   ");
    chan= pmonit->Read.Chan[n];
    fprintf( Fout, "    %2d =%5d ", n, chan);
    if( !(CfData->MonitParams.ADCinUSE & k)) strcpy( diag, "NOT");
    else if( chan < CfData->MonitParams.MinRed[n] ||
	     chan > CfData->MonitParams.MaxRed[n]) strcpy( diag, "RED");
    else if( chan < CfData->MonitParams.MinOrange[n] ||
	     chan > CfData->MonitParams.MaxOrange[n]) strcpy( diag, "ORG");
    fprintf( Fout, "%s", diag);
    k <<= 1;
  }
  fprintf( Fout, "\n DAC");
  k=1;
  for( n=0; n<NDAC; n++) {
    if( !(n % 4)) fprintf( Fout, "\n");
    strcpy( diag, "   ");
    chan= pmonit->Write.Chan[n];
    fprintf( Fout, "    %2d =%5d ", n, chan);
    if( !(CfData->MonitParams.DACinUSE & k)) strcpy( diag, "NOT");
    fprintf( Fout, "%s", diag);
    k <<= 1;
  }
  fprintf( Fout, "\n Input  Register = $%04X", pmonit->Read.InputRegister);
  fprintf( Fout, "\n Output Register = $%04X\n", pmonit->Write.OutputRegister);
  fflush( Fout);
}

void dmp( char * title, unsigned char *p, int size)
{
  int n;

  fprintf( Fout, "Dump : %s - size= %d", title, size); fflush( Fout);
  for( n=0; n<size; n++) {
    if( !(n % 20)) fprintf( Fout, "\n");
    fprintf( Fout, "%3X", *p++);
  }
  fprintf( Fout, "\n");
  fflush( Fout);
}    

void dimp( char * title, unsigned char *p, int size)
{
  int n;
  unsigned char *pc= p;
  
  fprintf( Fout, "Dimp : %s - size= %d", title, size); fflush( Fout);
  for( n=0; n<size; n++) {
    if( !(n % 20)) fprintf( Fout, "\n");
    fprintf( Fout, "%3X", *p++);
  }
  fprintf( Fout, "\n------\n"); p=pc;
  fprintf( Fout, "Dimp : %s - size= %d", title, size); fflush( Fout);
  for( n=0; n<size; n++) {
    if( !(n % 20)) fprintf( Fout, "\n");
    if( isprint(*p)) fprintf( Fout, "  %c", *p++);
    else { p++; fprintf( Fout, "  .");}
  }
  fprintf( Fout, "\n");
  fflush( Fout);
}    

void VerifMess( unsigned char *pcom)
{
  /* Frame and Message lenght verification */
  int totlen= *pcom, nbfields= *(pcom+6), nf, len=6, nd;
  static nbad=0;

  if( totlen > 160) {
    fprintf( Fout, "VerifMess: totlen= %d\n", totlen);
    fflush( Fout);
  }
  pcom += 7;
  for( nf=0; nf<nbfields; nf++) {
    nd= *pcom++;
    len += nd+1;
    if( len > totlen) break;
    pcom += nd;
  }
  if( len != totlen) {
    dmp( "bad VerifMess", BufCom, totlen+1);
    s_move( Col, Line+8); s_printf( "Bad message verification : %d", ++nbad);
  }
}

int Download( void)
{
  static  FILE *fdin;
  char InputFile[]= "/cdf/403/Cmds/Auger/task2";
  char OutputFile[]= "faketask2e";
  unsigned char buf[BUFCOMSIZE], *pbuf, comp,
    *pfilename= (unsigned char *)OutputFile;
  int sizei= 0, s, n, head;
  static int piece=0;
  int maxsize= BUFCOMSIZE -15;
  char str[80];

  if( IsDownload == 0) {   /***** First packet ******/
    if( (fdin= fopen( InputFile, "r")) == NULL) {
      fprintf( Fout, "Download : Can't open input file\n"); fflush( Fout);
      return 1;
    }
    while( 1) {            /* Find file size */
      st->Freeze=1;
      sizei += fread( buf, 1, BUFCOMSIZE, fdin);
      if( feof( fdin)) break;
      if( ferror( fdin)) {
	fprintf( Fout, "Download : Error on read after %d bytes\n", sizei);
	fflush( Fout);
	exit( 0);
      }
    }
    fprintf( Fout, "Download : %d bytes read on input file\n", sizei);
    fflush( Fout);
    rewind( fdin);
    pbuf= buf;
    n= strlen( OutputFile);
    *pbuf++= (unsigned char)n;
    while(n--) *pbuf++= *pfilename++;
    memcpy( pbuf, &sizei, 4);
    pbuf += 4;
    head= strlen( OutputFile)+5;
    s= head+ fread( pbuf, 1, maxsize-head, fdin);
    comp= COMPLETION_FIRST;
    IsDownload = 1;
  }
  else {                      /***** Other packets *****/
    s = fread( buf, 1, maxsize, fdin);
    comp= COMPLETION_NEXT;
    sleep( 1);
  }                           /***** Send packet *****/
  if( feof( fdin)) {
    if( comp == COMPLETION_FIRST) comp= COMPLETION_ALL;
    else comp= COMPLETION_LAST;
    IsDownload= 0;
    fclose( fdin);
  }
  sprintf( str, "Download : %d data - comp= %X - p=%d", s, comp, piece++);
  s_message( str);
  WrtRS232( 'D', 0, M_DOWNLOAD, comp, s, buf);
}


void SendOs9Cmd( int i)
{
  char cmd[100];
  unsigned char buf[BUFCOMSIZE], *pbuf, comp;
  int n;

  switch( i) {
  case 1: strcpy( cmd, "attr -e -ge -pe fake*"); break;
  case 2: strcpy( cmd, "faketask2e&"); break;
  case 3: strcpy( cmd, "copy tagada bid"); break;
  }
  pbuf= buf;
  n= strlen( cmd);
  *pbuf++= (unsigned char)n;
  strcpy( pbuf, cmd);
  WrtRS232( 'D', 0, M_OS9_CMD, COMPLETION_ALL, n+2, buf);
  
}
