#define SHOW_ONLY 0x10

typedef enum {
	EMPTY,
	MENU,
	ACTION,
	GETINT,
	GETHEX,
	GETUNS,
	GETSTR,
	GETBOOL,
	SHOINT = SHOW_ONLY,
	SHOHEX,
	SHOUNS,
	SHOSTR,
	SHOBOOL,
	PANEL = 0x20,
	IDLE = 0x100
} M_ENTRY_TYPE ;

typedef enum {
	COMPACT,
	EXTENDED
} M_FORMAT ;

typedef enum {
	NONE,
	ALL,
	CURRENT,
	OPTIONS
} M_REDRAW ;

#define PREVIOUS (char *)-1
#define NEXT_ENTRY (char*)2
#define PREV_ENTRY (char *)3

/*
	La structure "entry" decrit une entree dans un menu .
	Une entree peut etre :
		Un autre menu .
		Une action a executer par une fonction utilisateur .
 
*/
typedef struct entry MP_entry ;
typedef struct menu MP_menu ;

struct entry {
  M_ENTRY_TYPE type ; 	/* type of entry */
  char *name ; 			/* entry name */
  char *comm ; 			/* comment ( used in EXETNDED format only ) */
  union stodo {
    void *dummy ;
    int (*e_fonct)() ; 	/* User function */
    MP_menu *mm ;       /* if this entry points to a menu */
  } todo ;
  void *user ; 			/* User defined pointer(not used by menu package)*/
  int min, max ;			/* min and max values ( GETINT, ... ) */
  char *deflt ; 		/* Name of next default entry */
  /******** end of user part ********/
  short changed ;		/* if true, this option is redrawn */
} ;

/*
	La structure "menu" decrit un menu .

	L'item "tab" de cette structure est un pointeur sur une table
 contenant les pointeurs sur les entrees appartenant a ce menu .

*/

struct menu {
	char *name ; 	/* menu title */
	char *deflt ; 		/* number of the default entry */
	struct entry **tab ;	/* pointer to table of entries */
	short xcorner, ycorner, xsize, ysize ;
	M_FORMAT format ; 		/* COMPACT/EXTENDED display */
	int (*m_visu)() ;		/* user function when this menu is displayed */
	int (*m_enter)();		/*  .....    .....    ......    is entered */
	int (*m_quit)() ;		/*  .....    .....    ......    is quitted */
	void *mp_user ; 			/* free pointer for user usage */
		/* ********** end of user area *********** */
	struct menu *pred, *next ; 	/* links to prec and next menu */
	int nb_entry ; 		/* Nb of entries */
	int last_entry ;	/* Last selected entry */
	int def ;			/* Default entry Number */
	char extended[10] ;	/* format for extended drawing */
} ;
 

#ifdef MENU_VAR


FILE *M_stdin = stdin ,
	*M_stdout = stdout  ;
int M_xoption = -1, M_yoption = -1 ;
int M_xmessage = -1, M_ymessage = -1 ;
int M_level ;
char *M_optmess = " =>" ;
void (*M_entermenu)() = NULL ;
M_REDRAW M_redraw = 1 ;
MP_menu *M_current ;
MP_entry MP_empty = {
  IDLE, NULL, NULL, NULL, NULL, 0, 0, NEXT_ENTRY } ;

#else

extern FILE *M_stdin,  *M_stdout  ;
extern int M_xoption, M_yoption ;
extern int M_xmessage, M_ymessage ;
extern int M_level ;
extern char *M_optmess ;
extern M_REDRAW M_redraw ;
extern void (*M_entermenu)() ;
extern MP_menu *M_current ;
extern MP_entry MP_empty ;

#endif
