/*
        DISK$DELPHI1:[BRUNETJM.SCREEN]SCREEN.H;
         Created           :  8-SEP-1988 by L.Guglielmi
*/
#ifndef _SCREEN_

#define _SCREEN_

#include <modes.h>
#include <scf.h>

#include "stermcap.h"
#include "d_type.h"
/*===================== preprocessor constant and macros ================*/

#if defined(_OSK)
/* Input mapping type codes     */
#define IGNORE                  0
#define PASSTHRU                1
#define EDFUNCTION              2

/* Other constants */
#define NOEDFUNCS               16
#define NOCTRLKEYS              32

/* SCF editing function mapping codes */
#define MOVLEFT       0x00    /* move cursor to the left (formerly pd_bsp) */
#define MOVRIGHT      0x01    /* move cursor to the right */
#define MOVBEG        0x02    /* move cursor to the beginning of the line */
#define MOVEND        0x03    /* move cursor to the end of the line */
#define REPRINT       0x04    /* reprint the current line to cursor position */
#define TRUNCATE      0x05    /* truncate the line at the cursor position */
#define DELCHRL       0x06    /* delete character to the left */
#define DELCHRU       0x07    /* delete character under the cursor */
#define DELWRDL       0x08    /* delete word to the left */
#define DELWRDR       0x09    /* delete word to the right */
#define DELINE        0x0A    /* delete the entire line */
#define UNDEF1        0x0B    /* undefined (reserved) */
#define MODETOGL      0x0C    /* input mode toggle (type over vs. insert) */
#define UNDEF2        0x0D    /* undefined (reserved) */
#define ENDOREC       0x0E    /* end of record (read only) */
#define ENDOFILE      0x0F    /* end of file */

#endif  /* defined(_OSK)  */

/*========================= Type definitions ==========================*/

/*------ line edition modes -----*/
typedef enum
{
  S_OVERSTRIKE,
  S_INSERT
} TYPE_MODE ;

typedef enum
{
  S_REPLACE,
  S_EDIT
} READ_MODE ;

/*--- Tektronix graphic icons ---*/
typedef struct
{
  unsigned x:4;
  unsigned y:4;
} s_icon_dot;
typedef struct
{
  float xf, yf;   /* scale factors to reach a size of 1 in both coordinates */
  short n;        /* number of elements in the list pointed to by d         */
  s_icon_dot o;   /* coordinate of the origin in the icon reference system  */
  s_icon_dot *d;  /* list of the summits of the icon drawing                */
} s_icon;

/*----- Key definition to check with termcap ----*/
typedef enum
{	
	S_K0 = 257,
	S_K1, S_K2, S_K3, S_K4, S_K5, S_K6, S_K7, S_K8, S_K9,
	S_KUP, S_KDOWN, S_KRIGHT, S_KLEFT, S_KHOME,
	S_F0, S_F1, S_F2, S_F3, S_F4, S_F5, S_F6, S_F7, S_F8, S_F9,
	S_FA, S_FB, S_FC, S_FD, S_FE, S_FF,
	S_P0, S_P1, S_P2, S_P3, S_P4, S_P5, S_P6, S_P7, S_P8, S_P9,
	S_U0, S_U1, S_U2, S_U3, S_U4, S_U5, S_U6, S_U7, S_U8, S_U9
} S_KEY ;

/*------ Line style for Tektro-Mode -------*/
typedef enum
{
	SOLID, SHORT_DASH_BOLD, LONG_DASH_BOLD, DASH_DOT_BOLD,
	LONG_DASH, SHORT_DASH, DASH_DOT, DOT_BOLD, DOT
} line_style;

/*======================== Global constants ===========================*/
#if defined(SCREEN_VAR)
const char S_tx_xfont[5] = {0, 31, 34, 51, 56},
           S_tx_yfont[5] = {0, 27, 33, 42, 52};
#else
extern const char S_tx_xfont[5], S_tx_yfont[5];
#endif
/*=================== Global initialized variables ====================*/
#ifdef SCREEN_VAR

int S_initialized= 0,
    S_graphic= 0,      /* =1 if terminal has pseudo-graphic capab.    */
    S_erased= 0 ,
    S_com_line= -1,    /* line number for input commands    */
    S_xpos= -1,        /* Current x_position on screen      */
    S_ypos= -1,        /* Current y_position on screen      */
    S_tektro= 0,       /* =1 if term has Tektro-graphic capability    */
    S_tektro_x= 0,     /* X size in Tektro Mode */
    S_tektro_y= 0,     /* Y size in Tektro Mode */
    S_tektro_on= 0,    /* Is tektro mode ON ?   */
    S_tektro_xpos = 0, /* Abscissa of Tektro graphic cursor */
    S_tektro_ypos = 0, /* Ordinate of Tektro graphic cursor */
    S_tektro_debug= 0, /* Tektro graphic debug mode */
    S_keypad_appl = 0, /* Is Keypad Application mode ?      */
    S_get_step = 0x19, /* Step between consecutive sleeps   */
    S_get_sleep= 0x19, /* Total sleeping time between chars in s_getc
                          default is about 100ms		      */
    S_read_replace = S_EDIT,     /* If S_EDIT, s_getstring replaces
                                    the string, otherwise, edit       */
    S_edit_mode = S_OVERSTRIKE,  /* May be OVERSTRIKE or INSERT       */
    S_err_on_scr = 0,  /* wether or not stderr goes to the screen     */
    S_key_initialized = 0,
    S_term_initialized = 0,
    S_tektro_style = SOLID ;
FILE *S_filout = stdout,  /* Output path  */
     *S_filin  = stdin ;  /* Input  path  */
error_code (*S_write)(path_id, void *, u_int32 *) = _os_write;
void (*S_user_live)() = NULL ; /* User function called when s_getc is waiting*/
char
	*DO = NULL, *BS = NULL, *ND = NULL, *CM = NULL, *CD = NULL,
	*CE = NULL, *CL = NULL, *HO = NULL, *BB = NULL, *BE = NULL,
	*SE = NULL, *SO = NULL, *G0 = NULL, *G1 = NULL, *GI = NULL,
	*SD = NULL, *S0 = NULL, *S1 = NULL, *US = NULL, *UE = NULL,
	*GS = NULL, *GE = NULL, *GX = NULL, *GY = NULL, *SC = NULL,
           /* As from S_VERSION_22 */
	*KS = NULL, *KE = NULL,
	*SM = NULL, *BLS = NULL, *BLE = NULL, *CN = NULL, *CF = NULL ;

#else
extern int S_initialized,
           S_graphic,
           S_erased,
           S_com_line,
           S_xpos,
           S_ypos,
           S_tektro,
           S_tektro_x,
           S_tektro_y,
           S_tektro_on,
           S_tektro_xpos,
           S_tektro_ypos,
           S_tektro_debug,
           S_keypad_appl,
           S_get_step,
           S_get_sleep,
           S_read_replace,
           S_edit_mode,
           S_err_on_scr,
           S_key_initialized,
           S_term_initialized,
           S_tektro_style ;

extern FILE *S_filout, *S_filin;
extern error_code (*S_write)(path_id, void *, u_int32 *);
extern void (*S_user_live)(void);
extern char
	*DO, *BS, *ND, *CM, *CD,
	*CE, *CL, *HO, *BB, *BE,
	*SE, *SO, *G0, *G1, *GI,
	*SD, *S0, *S1, *US, *UE,
	*GS, *GE, *GX, *GY, *SC,
           /* As from S_VERSION_22 */
	*KS, *KE,
	*SM, *BLS, *BLE, *CN, *CF ;
#endif

/*================= global uninitialized global variables ===============*/
#if !defined(SCREEN_VAR)
#define SCREEN_VAR extern
#endif

#if defined(_OS9000)
SCREEN_VAR scf_path_opts S_sgbuf, S_newsgbuf ;
SCREEN_VAR scf_lu_opts Old_luopt, New_luopt ;
#else
SCREEN_VAR struct scf_opt S_sgbuf, S_newsgbuf ;
#endif

/*----------- line edition and keys ----------*/
SCREEN_VAR char *BC, *UP, PC_;
SCREEN_VAR char *KU, *KD, *KL, *KR ;
SCREEN_VAR char S_inmap[32] ;

/*------ Screen lines and columns width ------*/
SCREEN_VAR int S_lines,
               S_columns,
               S_line_offset;

SCREEN_VAR char S_Titled[128] ; /* Double height lines */

/*-------------- Used by tputs -----------------*/
SCREEN_VAR short ospeed ;

/*======================= Function prototypes =========================*/

int s_init(const char *);
void s_deinit(void);
void s_termset(void);
void s_termreset(void);
void s_initialize_keys(void);

void	s_move(int, int),
  s_home(void),
  s_bottom(void),
  s_up(int),
  s_down(int),
  s_left(int),
  s_right(int),
  s_er_lines(int,int),
  s_erase(void),
  s_eod(void),
  s_eol(void),
  s_start_so(void),
  s_stop_so(void),
  s_start_bold(void),
  s_stop_bold(void),
  s_start_blk(void),
  s_stop_blk(void),
  s_start_ul(void),
  s_stop_ul(void),
  s_ascii(void),
  s_graphic(void),
  s_keypad(int);
int		s_set80(void),
		s_set132(void),
                s_is_bad_char(int, char *),
                s_edit_function( int ) ;
void	s_set_scr(int, int ),
		s_set_margin(int, int);
		
void	s_rect(int, int, char, char, char),
		s_vline(int, char),
		s_hline(int, char),
		s_llc(void),
		s_lrc(void),
		s_ulc(void),
		s_urc(void),
		s_cross(void),
		s_ttc(void),
		s_rtc(void),
		s_btc(void),
		s_ltc(void),
		s_vbc(void);
		
int		s_getc(void),
                s_getc_wt(void),
		s_readint(const char *, int, int, int);
unsigned	s_readhex(const char *, unsigned, unsigned, unsigned);
double		s_readouble(const char *, double, double, double);
char *		s_readstr(const char *, char *);
char *		s_nreadstr(const char *, char *, int max );
int		s_yn(const char *),
		s_pto(int),
                s_pto_tm(int, int);

void		s_putc(char),
		s_printf(const char *,...),
		s_nprintf(int, const char *,...);
void	s_puts(const char *),
		s_nputs(int, const char *),
		s_nbputs(int, const char *),
		s_nextline(void),
		s_beg_line(void),
		s_blank(int),
		s_mess(const char *,...),
		s_messerase(void),
		s_title(const char *);

int		s_tx_start(void),
		s_tx_stop(void),
		s_tx_style(line_style),
		s_tx_move(int, int),
		s_tx_draw(int, int),
		s_tx_puts(const char *, int),
		s_setkey(S_KEY, const char *),
        s_txscalx(int x0, int y0, int dx, int ticsize, int font,
		  double beg, double end),
        s_txscaly(int x0, int y0, int dy, int ticsize, int font,
		  double beg, double end);
void	s_tx_erase(void),
		s_tx_pto(void),
        s_txploth(const void *bin, d_type_t size, int nbin,
		  double scalx, double scaly,
		  int x0, int y0, int min, int max),
        s_tx_icon(s_icon i, int sx, int sy),
        s_tx_write(int, ...),
        s_tx_grid( int x0, int y0, int x1, int y1, int nx, int ny,
	       line_style x_style, line_style y_style ),
        s_tx_rect(int x0, int y0, int x1, int y1, int intens) ;

int	s_tputc(char);
void	s_tputs(const char *);
void	s_ntputs(int, char *);
char *	s_getstr(char *);

int    s_getstring(char * );
int    s_ngetstring(char *, int max );
void	s_anime(int, int *);

void	s_timeout(const char *);

#define s_tx_rmove(X,Y) s_tx_move(S_tektro_xpos+(X), S_tektro_ypos+(Y))
#define s_tx_rdraw(X,Y) s_tx_draw(S_tektro_xpos+(X), S_tektro_ypos+(Y))

#endif

