
# if !defined(_PROTO_IRQS_)

#define _PROTO_IRQS_

#define LEVEL 0
#define EDGE 1
#define NEGATIVE 0
#define POSITIVE 1

#define EXT_VECTOR 5 /* Toutes les IT externes sont vecteur 5 ( ? ) */

u_int32 IntIocrMask[5] = {
  0x3FFFFFFF, 0xCFFFFFFF, 0xF3FFFFFF, 0xFCFFFFFF, 0xFF3FFFFF
} ;
u_int32 IntEdge[5] = {
  0x80000000, 0x20000000, 0x08000000, 0x02000000, 0x00800000
} ;
u_int32 IntSign[5] = {
  0x40000000, 0x10000000, 0x04000000, 0x01000000, 0x00400000
} ;
u_int32 IntEnable[5] = {
  0x10, 0x8, 0x4, 0x2, 0x1
} ;
u_int32 IntDisable[5] = {
  0xFFFFFFEF, 0xFFFFFFF7, 0xFFFFFFFB, 0xFFFFFFFD, 0xFFFFFFFE
} ;

/* Other variables */

event_id IrqEvId ;
char *IrqEvName = NULL ;
u_int32 IrqNum = -1,
  LevelEdge = -1,
  Sign = -1,
  IrqPort = 0,
  IrqPrior = -1 ;
u_int32 IrqIocr, IrqIocrMask, IrqEnable, IrqDisable ;
  
/* Fonctions pour acces aux registres de controle des ITs
     exier : external interrupts enable register
     exisr : external interrupts status register
     iocr  : input output Control register
     */
extern u_int32 getexier() ;
extern u_int32 setexier() ;

extern u_int32 getexisr() ;
extern u_int32 setexisr() ;

extern u_int32 getiocr() ;
extern u_int32 setiocr() ;

_asm( "getexier: mfdcr r3,exier
 blr" ) ;
_asm( "setexier: mtdcr exier,r3
 blr" ) ;
_asm( "getexisr: mfdcr r3,exisr
 blr" ) ;
_asm( "setexisr: mtdcr exisr,r3
 blr" ) ;
_asm( "getiocr: mfdcr r3,iocr
 blr" ) ;
_asm( "setiocr: mtdcr iocr,r3
 blr" ) ;

#endif
