/*=======================================================================
  Edition History:                                                      
                                                                        
    Ed.   Date      What happened                                       
    --  --------    --------------------------------------------------- 
    01  95/05/11    Created                                             
    02  96/09/18    Added Stack Check Note                          rkw 
    03  97/01/10    Added PPC -bepg Note                            rkw 
    04  97/01/16    Added E_NOT me + headers ++                     rkw 
    05  97/03/11    Edited                                          jrt
    06  98/01/08    Adaptation au trigger Auger sur PPC403          LG

    $Author: os9 $
    $Date: 2000/10/16 13:23:46 $
    $Revision: 1.4 $

    $Log: trigirq.c,v $
    Revision 1.4  2000/10/16 13:23:46  os9
    Mise a jour pour trigger Fast (int 1)

    Revision 1.3  2000/10/16 10:24:14  os9
    Mise a jour pour vrai trigger IT

    Revision 1.2  2000/10/14 09:42:30  os9
    Version pour de vrai.

=======================================================================

A System State Process which installs an Interrupt Handler


This is a short program that installs an interrupt routine on a vector
and prints a message when an interrupt occurs. It could be  
compilied with: cc irqexample.c -r -bepg -tp=ppc -l=cpu.l -l=sys_clib.l,
you must define the vector # for PPC and and add in the correct -tp for
your processor.
*/

/*--------------------------------------------------------------------------!
! NOTE: This process must be System State!  To compile as a system state    !
!	process you can either specify 'syscstart.r' as the first file on   !
!	the 'link line' in your makefile or if your compiling directly      !
!	with 'cc' you must include the option: '-cs=syscstart.r' on your    !
!	command line. You must also add the -r option to disable stack      !
!       checking. If your are using a machine which does not have direct    !
!       access to the <pc> such as PowerPC's the -bepg option is necessary. !
!	This does not use a data module to display the IRQ's.  This is also !
!	CPU time consuming, as it prints out the number of IRQ's whether    !
!	more have occurred or not.                                          !
!--------------------------------------------------------------------------*/

#include <types.h>
#include <const.h>
#include <errno.h>
#include <cglob.h>
#include <signal.h>
#include <events.h>

#include "trigirq.h"

volatile unsigned int *Port;		/* Base address of the hardware  */

event_id TrigEvId ;
char *TrigEvName = "TrigEvTst" ;

extern void *_glob_data;

/*------------------------------------------------------------------!
! irqfunc: This is the function that is run by the Kernel when the  !
!	   interrupt fires off.  This function MUST access the      !
!	   hardware to 'clear down' the interrupt.                  !
!------------------------------------------------------------------*/
irqfunc()
{        
  u_int32 isme;  /* Var to be used to test Interrupting Device Status 
		     Register */ 
  int dummy ;

  /* Check and see if it is my interrupt */
  isme = getexisr() & TRIG_ENABLE ;

  if ( !isme )
    return E_NOTME;
  else {    
    setexisr( getexisr() | TRIG_ENABLE ) ;
    /* Signal the Event */
    _os_ev_signal( TrigEvId, &dummy, 1 ) ;
    /* Clear the interrupt bit in EXISR */

    return SUCCESS; 
  }
}

void
sig_hand()
{
  _os_rte() ;
}


/*--------------------------------------------------------------------------!
! main: This function sets up the interrupt and prints stats until killed   !
!--------------------------------------------------------------------------*/
main()
{
  int loop, value = 0 ;
  u_int16
    vector,			/* interrupt vector number */
    priority;	/* interrupt priority (0 - 255)	*/
  error_code	error;

  /* Install signal handler */
  _os_intercept( sig_hand, _glob_data ) ;

  /* Link to or create an Event */
  if ( _os_ev_creat( -1, 1, 0x777, &TrigEvId,
		     TrigEvName, 0, 0 ) != SUCCESS &&
       _os_ev_link( TrigEvName, &TrigEvId ) != SUCCESS )
    exit(_errmsg(error, "Can't Create or Link to the event!\n"));
  
  /* Initialize necessary parameters */
  vector = TRIG_VECTOR ;
  priority = TRIG_PRIOR ;

  /* Install the interrupt service function	*/
  if ((error = _os_irq(
		       vector,
		       priority,
		       irqfunc,
		       _glob_data ) )
      != SUCCESS) {
    _os_ev_unlink( TrigEvId ) ;
    exit(_errmsg(error, "Can't install interrupt service function!\n"));
  }

  /* Enable IRQ 3 */
  setiocr( (getiocr() & TRIG_IOCR_0) | TRIG_IOCR ) ;
  setexier( getexier() | TRIG_ENABLE ) ;

  /* Loop and display results every 2 seconds	*/
  for( ; ; ) {
    unsigned int tt = 0 ;
    signal_code dummy ;

    tt = 0 ;
    dummy = 0 ;
    _os_sleep( &tt, &dummy ) ;
    if ( dummy ) break ;
  }
  /* Disable INT 3 */
  setexier( getexier() & TRIG_DISABLE ) ;

  /* Deinstall IRQs */
  _os_irq(
	  vector,
	  priority,
	  NULL,
	  _glob_data ) ;
  _os_ev_unlink( TrigEvId ) ;
  exit( 0 ) ;
}

