/* 
   mufill : Local Station Software - Pierre Auger Project
   --------
              JM Brunet, L Gugliemi, C Le Gall, G Tristram
	               College de France - Paris

   Created    01/06/97 - JMB & CL
   Modified : 12/09/97 - Split MsgSvr into MsgSvrIn & MsgSvrOut

----------------------------------------------------------------------------
Purpose : 

----------------------------------------------------------------------------*/
#include <errno.h>

#define _STATUS_MAIN_
#include "status.h"
#include "augerirq.h"
#include "asiclib.h"   /* Trigger simulation card  */
#include "ready_acq.h"
#include "evbdefs.h"


STATUS *st;
signal_code Signal= 0;
char StrLog[256];

void init( void);
void DoWork( void);
void byebye( int);

extern void *_glob_data;

void sig_hand( signal_code sig )
{
  Signal= sig;
  _os_rte() ;
}

main( int argc, char **argv )
{
  init();
  DoWork();
}


void init( void)
{
  error_code err;

  _os_intercept( sig_hand, _glob_data ) ;
                                   /* Link to Data Module       */
  if( dm_init( StatModName, sizeof( STATUS), (void **)&StData, &StHeader))
    exit(_errmsg(errno, "mufill: Can't link to Status Data Module!\n"));
  st= StData;
                                   /* Link to T1Mu Event */
  if(( err=  _os_ev_link( st->event.EvNameT1Mu, &st->event.IdT1Mu))
     != SUCCESS)
    exit(_errmsg(errno, "mufill: Can't link to the Slow event!\n"));
                                   /* Init Slow Buffers */
  if(( err= SB_init( MAX_SLOW_BUFFER))) {
    sprintf( StrLog, "mufill: Can't init slow Buffers: err= %d\n", err);
    PrtLog( StrLog, 1);
    exit( 0);
  }
  printf( "mufill: Slow buffers initialized\n");
                                   /* Init Event Buffers */
  while(( err= EvbInit(&mubid, MU_BUFFER_NAME, MUBSIZE)) == E_KWNMOD );
  if( err) {
    sprintf( StrLog, "mufill: Error %d EvbInit\n", err);
    PrtLog( StrLog, 1);
    exit( 0);
  } 
  printf( "mufill: MuBuffer initialized\n");
                                  /* Ready init */
  if(( err= ReadyInit( &ReadyEvId, ReadyEvName)) != SUCCESS) {
    sprintf( StrLog, "mufill: Error %d calling ReadyInit\n", err);
    PrtLog( StrLog, 1);
    exit( 0);
  }
  ReadyToGo( ReadyEvId, READY_MUFILL);
  ReadyFinish( ReadyEvId, ReadyEvName);
  puts( "mufill: initialisation ended\n"); fflush( stdout);
}


void DoWork( void)
{
  error_code err;
  signal_code sig ;
  int value, size;
  SLOW_EVENT *pslow, *pmu;
  unsigned char tag[]= {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

  while( 1) {                        /* Waiting T1Mu event */
    if(( err = _os_ev_wait( st->event.IdT1Mu, &value, &sig,1,0xfffffff)) 
       != SUCCESS ) break;
    if( st->RunStatus == REBOOT) break;
              /****** One must verify here that the DMA has ended ******/
    st->mufill.T1Slow++;
    if(( err= SB_use( &pslow))) {    /* Ask for the oldest Slow Buffer */
      sprintf( StrLog, "mufill: Error %d calling SB_use()\n", err);
      PrtLog( StrLog, 1);
      exit( 0);
    }                                /* Ask for an Mu buffer */
    while ( err= EvbAlloc( mubid, (void **)&pmu, sizeof(SLOW_EVENT))) {
      if( err != EVB_ERR_FULL) {
	sprintf( StrLog, "mufill: EvbAlloc error %d for T1Slow= %d\n", 
		 err, st->mufill.T1Slow);
	PrtLog( StrLog, 1);
	byebye( err);
      }
      err= EvbFree( mubid, NB_MUB_RELEASE);
      if( err != SUCCESS) {
	sprintf( StrLog, "mufill: EvbFree error %d\n", err);
	PrtLog( StrLog, 1);
	byebye( err);
      }
      st->buffer.MubUsed -= NB_MUB_RELEASE;
    }
    st->mufill.second= pslow->date.second;
    *pmu= *pslow;                    /* Save Slow into MuBuffer */
    if(( err= SB_free())) {          /* Release Slow buffer */
      sprintf( StrLog, "mufill: Error %d calling SB_free()\n", err);
      PrtLog( StrLog, 1);
      exit( 0);
    }
    st->buffer.SlowUsed--;
                                     /* Compute the size of the buffer */
    size= sizeof( TimeStamp) + 8 +pmu->nmuons*sizeof(SLOW_MUON); /* 26/10/99 */
                                     /* Mark MuBuffer as ready  */
                                     /* and shrink it to size */
    if( err= EvbReady( mubid, (void *)pmu, size, tag)) {
      sprintf( StrLog, "mufill: EvbReady error %d\n", err);
      PrtLog( StrLog, 1);
      break;
    }
    st->buffer.MubUsed++;
    if( st->buffer.MubMin > st->buffer.MubUsed) 
      st->buffer.MubMin= st->buffer.MubUsed;
    if( st->buffer.MubMax < st->buffer.MubUsed) 
      st->buffer.MubMax= st->buffer.MubUsed;
  }
}


void byebye( int err)
{
  char str[80];

  if( err) sprintf( StrLog, "mufill : %s\n", EvbError( err));
  else     sprintf( StrLog, "mufill : ended\n");
  PrtLog( StrLog, 1);
  while( _os_ev_unlink( st->event.IdT1Mu));
  _os_ev_delete( st->event.EvNameT1Mu);
  SB_finish();
  EvbFinish( &mubid);
  dm_finish( &StHeader );
  sprintf( str, "mufill : Ended by error %d\n", err);
  exit(_errmsg(errno, str));
}
