/* 
   trigger1 : Local Station Software - Pierre Auger Project
   ---------
              JM Brunet, L Gugliemi, C Le Gall, G Tristram
                       College de France - Paris

   Created    01/06/97 - JMB
   Modified : 17/11/98 - Version 2
              09/06/99 - ReadFast() : reference fast event
              01/07/99 - ReadSlow() : reference slow event
----------------------------------------------------------------------------*/

#define _STATUS_MAIN_
#include "status.h"
#include "asiclib.h"   /* Trigger simulation card  */
#include "evbdefs.h"
#include "central.h"

#define MAXFEBUF 300

signal_code Signal = 0;
STATUS *st;
TRIG1  *t1;
FAST_EVENT Fast;      /* Fast event reference */
SLOW_EVENT Slow;      /* Slow event reference */

/* ajout BR-FC */
FILE *Fout=NULL;

void init( void);
void DoWork( void);
void byebye( void);
void FillFast( int nevt, FAST_EVENT *pfast);
void FillSlow( int nevt, SLOW_EVENT *pslow);
void ReadFast( void);
void ReadSlow( void);
void PrtFastSlow( void);


void sig_hand( signal_code s )
{
  Signal= s;
  _os_rte();
}

main( int argc, char **argv )
{
  init();
  DoWork();
  byebye();
}


void init( void)
{
  error_code err;
  signal_code sig;
  time_t t;
  u_int32 tcks;
  char str[30];
  alarm_id AlarmId;

  /* Link to Data Modules       */
  if( dm_init( StatModName, sizeof( STATUS), (void **)&StData, &StHeader))
    exit(_errmsg(errno, "trigger1: Can't link to Status Data Module!\n"));
  /* Initialize Status data module */
  st= StData;
  
  if( dm_init( T1ModName, sizeof( TRIG1), (void **)&T1Data, &T1Header))
    exit(_errmsg(errno, "trigger1: Can't link to Trigger1 Data Module!\n"));
  t1= T1Data;
  _os_getime( &t, &tcks);
  strcpy( st->fmr.StartAcq, ctime( &t));
  st->fmr.StartAcq[16]= '\0';
  st->fmr.RunNumber= 0;
  /* Link to Events */
  sleep(2);
  if(( err=  _os_ev_link( st->event.EvNameT1Tg2, &st->event.IdT1Trigger2))
     != SUCCESS)
    {
      exit(_errmsg(errno, "trigger1: Can't link to the Fast event!\n"));
    }
  
  if(( err=  _os_ev_link( st->event.EvNameT1Mu, &st->event.IdT1Mu))
     != SUCCESS)
    exit(_errmsg(errno, "Task3: Can't link to the Slow event!\n"));
                                   /* Init Fast Buffers */
  if(( err= FB_init( MAX_FAST_BUFFER)) != SUCCESS)
    exit(_errmsg(errno, "trigger1: Can't link to Fast Buffer!\n"));
                                   /* Init Slow Buffers */
  if(( err= SB_init( MAX_SLOW_BUFFER)) != SUCCESS)
    exit(_errmsg(errno, "trigger1: Can't link to Muon Buffer!\n"));
  Fout= fopen( "trigger1.log", "w");
  ReadFast();                      /* Fast event ref.   */
  ReadSlow();                      /* Slow event ref.   */
  PrtFastSlow();
  sleep( 5);                       /* 28/10/99 */
                                   /* Intercept Signals */
  _os_intercept( sig_hand, _glob_data );
  _os_alarm_cycle( &AlarmId, 7654, 10);
}


void ReadFast( void)
{
  FILE *fin;
  int n, a1,a2,a3,a4,a5,a6,a7;
  FAST_EVENT *pf= &Fast;
  FAST_SAMPLE *pdata= Fast.data;
  char str[90];

  if( !(fin = fopen( "/cdf/Ppc/Cmds/Auger/trg1f.dat", "r")) ) {
    fprintf( Fout, "\n Can't find file trg1f.dat !!!\n\n");
    exit( 0);
  }
  fgets( str, 80, fin);
  sscanf( str, "%d %d %d %d %d", &a1, &a2, &a3, &a4, &a5);
  Fast.date0.second= a1;
  Fast.date0.nano= a2;
  Fast.time_tag= a3;
  Fast.T2T1_type= a4;
  Fast.nsamples= a5;
  for( n=0; n<Fast.nsamples; n++) {
    fgets( str, 80, fin);
    sscanf( str, "%d %d %d %d %d %d %d", &a1, &a2, &a3, &a4, &a5, &a6, &a7);
    Fast.data[n].sumd8= a1;
    Fast.data[n].pmt3= a2;
    Fast.data[n].pmt2= a3;
    Fast.data[n].pmt1= a4;
    Fast.data[n].time_tag= a5;
    Fast.data[n].lowd8= a6;
    Fast.data[n].low= a7;
  }
  fclose( fin);
}


void ReadSlow( void)
{
  int n, m, nmuons;
  FILE *fin;
  SLOW_EVENT *ps= &Slow;
  SLOW_MUON  *pdata= ps->data;
  char str[90], *pt= str;
  
  if( !(fin = fopen( "/cdf/Ppc/Cmds/Auger/trg1s.dat", "r")) ) {
    fprintf( Fout, "\n Can't find file trg1s.dat !!!\n\n");
    exit( 0);
  }
  fgets( str, 80, fin); sscanf( str, "%x", &m);
  ps->date.second= m;
  fgets( str, 80, fin); sscanf( str, "%x", &m);
  ps->date.nano= m;
  fgets( str, 80, fin); sscanf( str, "%x", &m);
  ps->time_tag= m;
  fgets( str, 80, fin); sscanf( str, "%x", &m);
  /*  nmuons= atoi( str);
      ps->nmuons= nmuons*5;  */
  ps->nmuons= nmuons= m;
  for( n=0; n<nmuons; n++, pdata++) {
    fgets( str, 80, fin); sscanf( pt, "%x", &m);
    pdata->time_tag= m;
    sscanf( pt+9, "%x", &m);
    pdata->sample0.sum=  (m & 0xff000000) >> 24;
    pdata->sample0.pmt3= (m & 0xff0000)   >> 16;
    pdata->sample0.pmt2= (m & 0xff00)     >>  8;
    pdata->sample0.pmt1= (m & 0xff);
    sscanf( pt+18, "%x", &m);
    pdata->sample1.sum=  (m & 0xff000000) >> 24;
    pdata->sample1.pmt3= (m & 0xff0000)   >> 16;
    pdata->sample1.pmt2= (m & 0xff00)     >>  8;
    pdata->sample1.pmt1= (m & 0xff);
    sscanf( pt+27, "%x", &m);
    pdata->sample2.sum=  (m & 0xff000000) >> 24;
    pdata->sample2.pmt3= (m & 0xff0000)   >> 16;
    pdata->sample2.pmt2= (m & 0xff00)     >>  8;
    pdata->sample2.pmt1= (m & 0xff);
    sscanf( pt+36, "%x", &m);
    pdata->sample3.sum=  (m & 0xff000000) >> 24;
    pdata->sample3.pmt3= (m & 0xff0000)   >> 16;
    pdata->sample3.pmt2= (m & 0xff00)     >>  8;
    pdata->sample3.pmt1= (m & 0xff);
  }
}


void PrtFastSlow( void)
{
  unsigned int *pbuf;
  unsigned short nwords, n;
  int size;

  fprintf( Fout, "Fast Event (hexadecimal)\n");
  fprintf( Fout, "Second= %x - nano= %x - TimeTag= %x\n",  Fast.date0.second,
	    Fast.date0.nano,  Fast.time_tag);
  fprintf( Fout, "T1T2_type+ %x - nsample= %x\n",  Fast.T2T1_type,
	   Fast.nsamples);
  for( n=0; n<Fast.nsamples; n++) {
    fprintf( Fout, "%x %x %x %x - %x %x %x\n", Fast.data[n].sumd8,
	     Fast.data[n].pmt3, Fast.data[n].pmt2, Fast.data[n].pmt1,
	     Fast.data[n].time_tag, Fast.data[n].lowd8, Fast.data[n].low);
  }
  fprintf( Fout, "Slow Event (hexadecimal)\n");
  fprintf( Fout, "  Time Stamp : %x - %x\n", Slow.date.second, 
	   Slow.date.nano);
  fprintf( Fout, "  Time Tag   : %x\n", Slow.time_tag);
  nwords= Slow.nmuons;
  fprintf( Fout, "  Nsample    : %d\n", nwords);
  nwords *= sizeof( SLOW_MUON)/sizeof( unsigned int);
  pbuf= (unsigned int *)Slow.data;
  for( n=0 ; n< nwords; n++, pbuf++) {
    if( !(n % 5)) {
      fprintf( Fout, "\n");
      fprintf( Fout, "%4d- ", n/5+1);
    }
    fprintf( Fout, "%08X ", *pbuf);
  }
  size= (4+nwords)*4;
  fprintf( Fout, "\n ------------ size= %d bytes ------------------\n", size);
}


void DoWork( void)
{
  int nevt=0, StartRun=1, nslo=0, rate;
  error_code err;
  int32 value;
  u_int32 act_flag= 0, ticks, nt;
  FAST_EVENT *pfast;
  SLOW_EVENT *pslow;
  signal_code signal, dummy;

  while( 1) {
    nt= 0; _os_sleep( &nt, &dummy);
    if( Signal == SIGQUIT) break;
    if( st->RunStatus == REBOOT) break;
    if( !t1->IsTrig1) continue;
    rate= t1->rate/10;
    while( rate > 0) {
      nevt++; rate--;
      nt= t1->TotT1- st->trg2.T1Fast0- st->trg2.T1Fast1- st->mufill.T1Slow;
      t1->T1BufNb= nt;
      if( nt > MAXFEBUF) { t1->T1Lost++; continue; }
      if(( nevt % 10)) {                 /****** FAST trigger *****/
	if( st->RunStatus != RUN_STARTED) continue;   /* 28/10/99 */
	t1->TotT1++;
	st->inter.T1Fast0++;
	if(( err= FB_get( &pfast)) != SUCCESS) {
	  st->buffer.FastLost++;
	  continue;
	}
	FillFast( nevt, pfast);
	st->buffer.FastUsed++;
	if( st->buffer.FastMax < st->buffer.FastUsed) 
	  st->buffer.FastMax= st->buffer.FastUsed;
	if( st->inter.T1Fast0 > 100 && 
	    st->buffer.FastMin > st->buffer.FastUsed)
	  st->buffer.FastMin= st->buffer.FastUsed;
	_os_ev_signal( st->event.IdT1Trigger2, &value, act_flag);
      }
      else {                            /****** SLOW trigger *****/
	t1->TotT1++;
	st->inter.T1Slow++;
	if(( err= SB_get( &pslow)) != SUCCESS) {
	  st->buffer.SlowLost++;
	  continue;
	}
	FillSlow( nevt, pslow);
	st->buffer.SlowUsed++;
	if( st->buffer.SlowMax < st->buffer.SlowUsed) 
	  st->buffer.SlowMax= st->buffer.SlowUsed;
	if( st->inter.T1Slow > 100 && 
	    st->buffer.SlowMin > st->buffer.SlowUsed)
	  st->buffer.SlowMin= st->buffer.SlowUsed;
	_os_ev_signal( st->event.IdT1Mu, &value, act_flag);
      }
    }
  }
}


void FillFast( int nevt, FAST_EVENT *pfast)
{
  int nsample, n, second;
  static int OldSec, nano=0;
  int maxnano= 100000000;
  FAST_EVENT *pf= &Fast;

  second= nevt/t1->Hz;
  if( second != OldSec) {
    OldSec= second;
    nano= 5;
  }
  /* else if( OldSec % 10) nano += maxnano/t1->Hz; */
  else nano += maxnano/t1->Hz;
  if( nano > maxnano) nano= maxnano- 100;
  pfast->date0.second= second;
  pfast->date0.nano= nano;
  pfast->time_tag= pf->time_tag;
  pfast->T2T1_type= pf->T2T1_type;
  nsample= pf->nsamples;
  pfast->nsamples= nsample;
  for( n=0; n<nsample; n++) {
      pfast->data[n].pmt1= pf->data[n].pmt1;
      pfast->data[n].pmt2= pf->data[n].pmt2;
      pfast->data[n].pmt3= pf->data[n].pmt3;
      pfast->data[n].sumd8= pf->data[n].sumd8;
      pfast->data[n].time_tag= pf->data[n].time_tag;
      pfast->data[n].low= pf->data[n].low;
      pfast->data[n].lowd8= pf->data[n].lowd8;
  }
  st->inter.FastSec= pfast->date0.second;
}

void FillSlow( int nevt, SLOW_EVENT *pslow)
{
  int nmuons= 50, n, second;    /* nmuons is limited to 50 */
  SLOW_EVENT *ps= &Slow;
  static int OldSec=0, nano=100000;

  second= nevt/t1->Hz;
  if( second != OldSec) {
    OldSec=second;
    nano= 100000;
  }
  else nano += 1000000;
  pslow->date.second= second;
  pslow->date.nano= nano;
  pslow->time_tag= ps->time_tag;
  pslow->nmuons= nmuons;
  for( n=0; n<nmuons; n++) {
    pslow->data[n]= ps->data[n];
  }
  st->inter.SlowSec= second;
}


void byebye( void)
{
   int32 value;
  u_int32 act_flag= 0;
  
  _os_ev_signal( st->event.IdT1Trigger2, &value, act_flag);
  _os_ev_signal( st->event.IdT1Mu, &value, act_flag);
  while( _os_ev_unlink( st->event.IdT1Trigger2));
  _os_ev_delete( st->event.EvNameT1Tg2);
  while( _os_ev_unlink( st->event.IdT1Mu));
  _os_ev_delete( st->event.EvNameT1Mu);
  FB_finish();
  SB_finish();
  dm_finish( &StHeader );
  exit( 0 );
}
