/*
 * $Header:   /h0/MWOS/SRC/DEFS/HW/VCS/16450.h_v   1.7   13 Jan 1996 20:19:26   allan  $
 */
/*--------------------------------------------------------------------------,
|                                                                           |
|        Copyright 1989, 1994, 1995, 1996 by Microware Systems Corporation  |
|                          Reproduced Under License                         |
|                                                                           |
|  This source code is the proprietary confidential property of Microware   |
|  Systems Corporation, and is provided to licensee for documentation and   |
|  educational purposes only. Reproduction, publication, or distribution    |
|  in any form to any party other than the licensee is strictly prohibited. |
|                                                                           |
|---------------------------------------------------------------------------|
| 16450.h : Definitions for the 16450 chip.									|
|																			|
| Edition History:															|
|																			|
| Ed#	Date	Changes													By	|
| --- --------	------------------------------------------------------- --- |
|  01 94/11/13  Adapted form sc16450.h/io16450.h						ats	|
|  02 94/11/13  Added INT_SBITS from sc16450.h                          ats |
|  03 95/02/02  Added BAUD2 and commented nonfunctional rounding macro. ats |
|  04 95/06/08  Use fixed point rounding for baud rate computation.     ats |
|  05 95/06/12  Added FCR definitions.                                  ats |
|  06 95/09/15  Changed modem status register definitions.              ats |
!               ---- OS-9000/PPC V2.0 Release ----                          !
|																			|
`--------------------------------------------------------------------------*/

/* Baud rate computation - usess fixed point rounding */

#define BAUD(x)		(((SERCLK*10/(x)/16)+5)/10)
#define BAUD2(x)	(((SERCLK*10/(x)/8)+5)/10)

#ifndef	SERCLK
#define SERCLK	1843200	/* default PC serial clock crystal */
#endif

/* Definitions for 16450 register layout */
#define DBUFF	0x00	/* Data Buss Buffer */
#define DLLS	0x00	/* Divisor LSB */
#define IRQENA	0x01	/* IRQ enable */
#define DLMS    0x01	/* Divisor MSB */
#define IRQID	0x02	/* IRQ ID */
#define FIFOCTL	0x02	/* FIFO control */
#define LINECTL	0x03	/* Line control */
#define MDMCTL	0x04	/* Modem control */
#define LINEST	0x05	/* Line status */
#define MDMST	0x06	/* Modem status */

/* interrupt enable register */
#define RDA_enab	0x01
#define TBE_enab	0x02
#define RLS_enab	0x04
#define MS_enab		0x08

/* interrupt ID register */
#define INT_pend	0x01
#define INT_MS		0x00
#define INT_TBE		0x02
#define INT_RDA		0x04
#define INT_RLS		0x06
#define INT_SBITS	0x06	/* some sort of receiver IRQ pending */
#define INT_FIFO	0xC0	/* FIFO enabled status (16550A only) */

/* FIFO control register */
#define	FCR_enab	0x01
#define FCR_RCVRST	0x02
#define FCR_XMTRST	0x04
#define FCR_DMAMOD	0x08

#define FCR_1BYT	0x00
#define FCR_4BYT	0x40
#define FCR_8BYT	0x80
#define FCR_14BYT	0xC0

/* line control register */
#define LCR_DB5		0x00
#define LCR_DB6		0x01
#define LCR_DB7		0x02
#define LCR_DB8		0x03
#define LCR_SB1		0x00
#define LCR_SB2		0x04
#define LCR_PARE	0x08
#define LCR_ODD		0x00
#define LCR_EVEN	0x10
#define LCR_STICK	0x20
#define LCR_BRKCTL	0x40
#define LCR_BAUDCTL	0x80

/* modem control register */
#define MCR_DTR		0x01
#define MCR_RTS		0x02
#define MCR_INTE	0x08
#define MCR_LOOP	0x10

/* line status register */
#define LSR_RDA		0x01
#define LSR_OVER	0x02
#define LSR_PAR		0x04
#define LSR_FRAME	0x08
#define LSR_BREAK	0x10
#define LSR_TBE		0x20
#define LSR_TXDONE	0x40
#define LSR_FIFOERR 0x80

/* modem status register */
#define MDMSR_CTSCHG	0x01
#define MDMSR_DSRCHG	0x02
#define MDMSR_RICHG		0x04
#define MDMSR_DCDCHG	0x08
#define MDMSR_CTS		0x10
#define MDMSR_DSR		0x20
#define MDMSR_RI		0x40
#define MDMSR_DCD		0x80
