/*
 * $Header:   /h0/MWOS/SRC/DEFS/HW/VCS/403spu.h_v   1.4   13 Jan 1996 20:19:28   allan  $
 * $Revision:   1.4  $
 */
 
/*
 * 403spu.h - header file for the IBM 403GA SPU
 *
 * Copyright 1994, 1996 by Microware Systems Corporation
 * Reproduced Under License.
 * This source code is the proprietary confidential property of
 * Microware Systems Corporation, and is provided to licensee
 * solely for documentation and educational purposes. Reproduction,
 * publication or distribution in any form to any party other than
 * the licensee is strictly prohibited.
 *
 * Edit History:
 * Date       Who   Reason
 * ---------  ----  ----------------------------------------------------------
 * 29 Jun 94  ats   Created.
 * 27 Oct 94  ats   Workfile name changed. Content restricted to chip defs.
 * 22 Dec 95  gdb   Added BAUD macro.
 * 09 Jan 96  gdb   Changed BAUD macro to agree with observed behavior of hw.
 *                  ---- OS-9000/PPC V2.0 Release ----
 */
 
#ifndef _403SPU_H_

#define _403SPU_H_

#if !defined(_TYPES_H)
#include <types.h>
#endif

/* Baud rate computation */
#define	BAUD(x)		((((SERCLK*10/(x)/16)+5)/10)-2)
#define	BAUD2(x)	((((SERCLK*10/(x)/8)+5)/10)-2)

typedef volatile struct {
	u_int8	spls,		/* Serial Port Line Status Register			*/
			reserved1,
			sphs,		/* Serial Port Handshake Status Register	*/
			reserved2,
			brdh,		/* Baud Rate Divisor High Register			*/
			brdl,		/* Baud Rate Divisor Low Register			*/
			spctl,		/* Serial Port Control Register				*/
			sprc,		/* Serial Port Receiver Command Register	*/
			sptc,		/* Serial Port Transmitter Command Register	*/
			spb;		/* Serial Port Receive/Transmit Buffer		*/
} spu, *Spu;

/* Serial Port Line Status Register Bit Definitions */

#define B_SPLS_RBR	0x80	/* Recieve Buffer Ready				*/
#define B_SPLS_FE	0x40	/* Framing Error					*/
#define B_SPLS_OE	0x20	/* Overrun Error					*/
#define B_SPLS_PE	0x10	/* Parity Error						*/
#define B_SPLS_LB	0x08	/* Line Break						*/
#define B_SPLS_TBR	0x04	/* Transmit Buffer Ready			*/
#define B_SPLS_TSR	0x02	/* Transmit Shift Register Ready	*/

/* Serial Port Handshake Status Register Bit Definitions */

#define B_SPHS_DIS	0x80	/* ~DSR Input Inactive Error		*/
#define B_SPHS_CS	0x40	/* ~CTS Input Inactive Error		*/

/* Serial Port Control Register Bit Definitions */

#define M_SPCTL_LM	(3<<6)	/* Mask for loopback modes			*/

#define	LM_NORMAL	(0<<6)	/* Normal Operation					*/
#define LM_INTERNAL	(1<<6)	/* Internal Loopback Mode			*/
#define LM_AUTOECHO	(2<<6)	/* Automatic Echo Mode				*/

#define B_SPCTL_DTR	0x20	/* Data Terminal Ready				*/
#define B_SPCTL_RTS	0x10	/* Request To Send					*/
#define B_SPCTL_DB	0x08	/* Data Bits (0 = 7, 1 = 8)			*/
#define B_SPCTL_PE	0x04	/* Parity Enable					*/
#define B_SPCTL_PTY	0x02	/* Parity (0 = Even, 1 = Odd)		*/
#define B_SPCTL_SB	0x01	/* Stop Bits (0 = One, 1 = Two)		*/

/* Serial Port Receiver Command Register Bit Definitions */

#define B_SPRC_ER	0x80	/* Enable Receiver					*/

#define M_SPRC_DME	(3<<5)	/* DMA Mode, Interrupt Enable		*/

#define DME_DIS		(0<<5)	/* DMA disabled, Interrupt disabled	*/
#define DME_INT		(1<<5)	/* DMA disabled, Interrupt enabled	*/
#define	DME_CH2		(2<<5)	/* DMA enabled for channel 2		*/
#define DME_CH3		(3<<5)	/* DMA enabled for channel 3		*/

#define B_SPRC_EIE	0x10	/* Receiver Error Int. Enable		*/
#define B_SPRC_PME	0x08	/* Pause Mode Enable (0=S/W, 1=H/W)	*/

/* Serial Port Transmitter Command Bit Definitions */

#define B_SPTC_ET	0x80	/* Enable Transmitter				*/

#define M_SPTC_DME	(3<<5)	/* same as M_SPRC_DME				*/

#define B_SPTC_TIE	0x10	/* Transmitter Empty Int. Enable	*/
#define B_SPTC_EIE	0x08	/* Transmitter Error Int. Enable	*/
#define B_SPTC_SPE	0x04	/* ~CTS Inactive (0=Pause, 1=Stop)	*/
#define B_SPTC_TB	0x02	/* Transmit Break					*/

#endif	/* _403SPU_H_ */
