/*
 * $Header:   /h0/MWOS/SRC/DEFS/HW/VCS/8253.h_v   1.1   13 Jan 1996 20:19:30   allan  $
 */
 
/*--------------------------------------------------------------------------,
|                                                                           |
|              Copyright 1995, 1996 by Microware Systems Corporation        |
|                          Reproduced Under License                         |
|                                                                           |
|  This source code is the proprietary confidential property of Microware   |
|  Systems Corporation, and is provided to licensee for documentation and   |
|  educational purposes only. Reproduction, publication, or distribution    |
|  in any form to any party other than the licensee is strictly prohibited. |
|                                                                           |
|---------------------------------------------------------------------------|
| 8253.h : Definitions for the 8253 chip.                                   |
|                                                                           |
| Edition History:                                                          |
|                                                                           |
|   Date    Changes                                                     By  |
| --------  ----------------------------------------------------------- --- |
| 95/08/09  Definitions extracted from PCAT's systype.h                 ats |
!               ---- OS-9000/PPC V2.0 Release ----                          ! 
|                                                                           |
`--------------------------------------------------------------------------*/

/* Register layout definitions */
#define PIT1        0x40    /* base address of first PIT */
#define PIT2        0x50    /* base address of second PIT */
#define PIT_TIMER0  0x00    /* timer 0 read/load register */
#define PIT_TIMER1  0x01    /* timer 1 read/load register */
#define PIT_TIMER2  0x02    /* timer 2 read/load register */
#define PIT_CONTROL 0x03    /* control word register */

/* Control Register Definitions */
#define CR_SC0      0x00    /* Control Register: select counter zero */
#define CR_SC1      0x40    /* Control Register: select counter one */
#define CR_SC2      0x80    /* Control Register: select counter two */
#define CR_RLCL     0x00    /* Control Register: counter latching operation */
#define CR_RLMS     0x20    /* Control Register: read/load most sig. byte */
#define CR_RLLS     0x10    /* Control Register: read/load least sig. byte */
#define CR_RLLM     0x30    /* Control Register: read/load least then most */
#define CR_MD0      0x00    /* Control Register: mode 0 */
#define CR_MD1      0x02    /* Control Register: mode 1 */
#define CR_MD2      0x04    /* Control Register: mode 2 */
#define CR_MD3      0x06    /* Control Register: mode 3 */
#define CR_MD4      0x08    /* Control Register: mode 4 */
#define CR_MD5      0x0A    /* Control Register: mode 5 */
#define CR_BIN      0x00    /* Control Register: counter value is binary */
#define CR_BCD      0x01    /* Control Register: counter value is bcd */
