#if !defined(_PCICNFG_H_)

#include	<stddef.h>
#include	<types.h>
#include	<errno.h>

#if !defined(NO_ERROR)
#define	NO_ERROR		0
#endif

#if defined(PCISUB)

#define		MAJOR_VERSION			1
#define		MINOR_VERSION			0

#define		VERSION_NUMBER	((MAJOR_VERSION<<16)+MINOR_VERSION)
#define		PCI_SUB_VERSION	VERSION_NUMBER
#define		PCI_SUB_NUMBER	0
#define		PCI_SUB_NAME	"pcisub"

typedef struct tag_pci_sub_stat {
	u_int32 *__pci_lib_exec;
	u_int32 *__pci_static;
    u_int32 *__pci_modhead;
} pci_sub_stat, *PCI_sub_stat;


enum	PCI_SUB_CALLS
{
	PCI_SUB_INIT = 0,
	PCI_GET_SUB_VERSION,
	PCI_SEARCH_DEVICE,
	PCI_NEXT_DEVICE,
	PCI_READ_CONF_BYTE,
	PCI_READ_CONF_WORD,
	PCI_READ_CONF_DWORD,
	PCI_WRITE_CONF_BYTE,
	PCI_WRITE_CONF_WORD,
	PCI_WRITE_CONF_DWORD,
	PCI_FIND_DEVICE,
	PCI_FIND_CLASS_CODE,
	PCI_GET_CONFIG_DATA,
	PCI_SUB_FUNCTION_END,
};

#else

typedef struct pci_cnfg_stat 
{
	u_int32	bus_number;				/* Bus number		0..255	*/
	u_int32	device_number;			/* Device number	0..31	*/
	u_int32	function_number;		/* Function number	0..7	*/
	u_int32	register_number;		/* Register Number	0..64	*/
	u_int16 vendor_id;				/* Vender ID.						*/
	u_int16 device_id;				/* Device ID.						*/
	u_int32 rev_class;				/* rev[31:24], class[23:0]			*/
}	pci_config_stat, *PCI_config_stat;

#endif

typedef	struct	pci_config_address_register
{
#if defined(_BIG_END)
	u_int	pci_regnum:6;		/* Register number			*/
	u_int	pci_reserve2:2;		/* Reserved space 2			*/
	u_int	pci_devnum:5;		/* Device number			*/
	u_int	pci_funcnum:3;		/* Function number			*/
	u_int	pci_busnum:8;		/* Bus number				*/
	u_int	pci_enable:1;		/* Configuration enable bit	*/
	u_int	pci_reserved1:7;	/* Reserved space 1			*/
#else
	u_int	pci_reserved1:7;	/* Reserved space 1			*/
	u_int	pci_enable:1;		/* Configuration enable bit	*/
	u_int	pci_busnum:8;		/* Bus number				*/
	u_int	pci_funcnum:3;		/* Function number			*/
	u_int	pci_devnum:5;		/* Device number			*/
	u_int	pci_reserve2:2;		/* Reserved space 2			*/
	u_int	pci_regnum:6;		/* Register number			*/
#endif
}	pci_config_addr_reg, *PCI_config_addr_reg;

typedef struct pci_config_reg
{
	u_int16 vendor_id,		/* 00-01	Device Vender ID. */
			device_id,		/* 02-03	Device ID */
			command_reg,	/* 04-05	Command Register */ 
			status_reg;		/* 06-07	Status Register */ 
	u_int32	rev_class;		/* 08		Revision ID */
							/* 09-0B	Class Code 	*/
	u_int8	cache_line_siz,	/* 0C		Cache Line Size */
			latency_timer,	/* 0D		Latency Timer */
			header_type,	/* 0E		Header Type */
			bist;			/* 0F		Build-In Self Test */
	u_int32	base_addrs[6];	/* 10-24	Base address registers	*/
	u_int32 cis_pointer;	/* 28		cardbus cis pointer		*/
	u_int16 subsystem_vid;	/* 2C		subsystem vender ID		*/
	u_int16	subsystem_id;	/* 2E		subsystem ID			*/
	u_int32	exp_rom_base;	/* 30-33	Expansion ROM Base Address */
	u_int32	res3[2];		/* 34-3B	reserved. */
	u_int8	irq_line,		/* 3C		Interrupt Line 		*/
			irq_pin,		/* 3D		Interrupt Pin		*/		
			min_grant,		/* 3E		Minimum Grant	*/
			max_latency;	/* 3F		Maxmum Latency */
} pci_config_reg, *PCI_config_reg;


#define MAX_PCI_BUS_NUMBER		256	/* MAX. of bus number		*/
#define MAX_PCI_DEVICE_NUMBER	32	/* MAX. of device number	*/
#define MAX_PCI_FUNC_NUMBER		8	/* MAX. of function number	*/
#define	MAX_PCI_REGISTER_NUMBER	64	/* MAX. of configuration register index */

#define	CHK_BUSNUMBER(x)	( x < MAX_PCI_BUS_NUMBER)
#define CHK_DEVNUMBER(x)	( x < MAX_PCI_DEVICE_NUMBER)
#define	CHK_FUNCNUMBER(x)	( x < MAX_PCI_FUNC_NUMBER)
#define	CHK_REGNUMBER(x)	( x < MAX_PCI_REGNUMBER )
#define NO_DEVICE			0xffffffffUL

#define ENABLE_CONFIG		1

/* Function prototypes	*/

#if defined(PCISUB)
error_code pci_find_device( PCI_sub_stat sp, \
							u_int32 vender_id, u_int32 device_id, \
							u_int32 index, \
							u_int8 *bus, u_int8 *dev);

error_code pci_find_class_code(\
							PCI_sub_stat sp, \
							u_int32 class_code, u_int32 device_index,\
							u_int8 *bus, u_int8 *dev);

u_int8  pci_read_configuration_byte( PCI_sub_stat sp,\
					u_int32 bus, u_int32 dev, u_int32 func, u_int32 index);
u_int16 pci_read_configuration_word( PCI_sub_stat sp,\
					u_int32 bus, u_int32 dev, u_int32 func, u_int32 index);
u_int32 pci_read_configuration_dword(PCI_sub_stat sp,\
					u_int32 bus, u_int32 dev, u_int32 func, u_int32 index);

error_code pci_write_configuration_byte( PCI_sub_stat sp,\
					u_int32 bus, u_int32 dev, u_int32 func, u_int32 index,\
					u_int32 val);
error_code pci_write_configuration_word( PCI_sub_stat sp,\
					u_int32 bus, u_int32 dev, u_int32 func, u_int32 index,\
					u_int32 val);
error_code pci_write_configuration_dword(PCI_sub_stat sp,\
					u_int32 bus, u_int32 dev, u_int32 func, u_int32 index,\
					u_int32 val);

u_int8 pci_get_irq_pin( PCI_sub_stat sp, \
					u_int32 bus, u_int32 dev, u_int32 func);
error_code pci_set_irq_line( PCI_sub_stat sp,\
					u_int32 bus, u_int32 dev, u_int32 func, u_int32 irqvect);
u_int8 pci_get_irq_line( PCI_sub_stat sp, \
					u_int32 bus, u_int32 dev, u_int32 func);
error_code pci_search_device(PCI_sub_stat sp, u_int8 *bus, u_int8 *device);
error_code pci_next_device(PCI_sub_stat sp, u_int8 *bus, u_int8 *device);

error_code pci_get_config_data(PCI_sub_stat sp,
					 u_int8 bus, u_int8 dev, u_int32 func,
					 PCI_config_reg cp);

#else /* Static Version */

error_code _pci_search_device(PCI_config_stat stat);
error_code _pci_next_device(PCI_config_stat stat);

error_code pci_get_config_data(u_int32 , \
					u_int32 device, u_int32 func, PCI_config_reg cnfg);


error_code pci_find_device( u_int32 vender_id, u_int32 device_id, \
							u_int32 index, \
							u_int8 *bus, u_int8 *dev);

error_code pci_find_class_code( u_int32 class_code, u_int32 device_index,\
							u_int8 *bus, u_int8 *dev);

u_int8  pci_read_configuration_byte( u_int32 bus, u_int32 dev, u_int32 func, u_int32 index);
u_int16 pci_read_configuration_word( u_int32 bus, u_int32 dev, u_int32 func, u_int32 index);
u_int32 pci_read_configuration_dword(u_int32 bus, u_int32 dev, u_int32 func, u_int32 index);

error_code pci_write_configuration_byte( u_int32 bus, u_int32 dev, u_int32 func, u_int32 index, u_int8 val);
error_code pci_write_configuration_word( u_int32 bus, u_int32 dev, u_int32 func, u_int32 index, u_int16 val);
error_code pci_write_configuration_dword(u_int32 bus, u_int32 dev, u_int32 func, u_int32 index, u_int32 val);

u_int8 pci_get_irq_pin(u_int8 bus, u_int8 dev, u_int8 func);
error_code pci_set_irq_line(u_int8 bus, u_int8 dev, u_int8 func, u_int8 irqvect);
u_int8 pci_get_irq_line(u_int8 bus, u_int8 dev, u_int8 func);

#endif

/* Bit definition of status register */

#define	PCIC_STATUS_MASK	0xff80	/* Mask Pattern Of Status Register */
#define B_PCIC_FBTB_CAP		(1<<7)	/* FAST bask To Back Capable */
#define	B_PCIC_DATA_PERR	(1<<8)	/* Data Parity Error Detected */
#define	B_PCIC_DEVSEL		(3<<9)	/* DEVSEL Timing */
#define	B_PCIC_STRGT_ABORT	(1<<11)	/* Signaled Targen Abort */
#define	B_PCIC_RTRGT_ABORT	(1<<12)	/* Received Targen Abort */
#define	B_PCIC_RMSTR_ABORT	(1<<13)	/* Received Maser Abort */
#define B_PCIC_SYS_ERR		(1<<14)	/* Signaled System Error */
#define B_PCIC_PERR			(1<<15) /* Detect Parity Error */

#define b_PCIC_FBTB_CAP		(7)		/* FAST bask To Back Capable */
#define	b_PCIC_DATA_PERR	(8)		/* Data Parity Error Detected */
#define	b_PCIC_DEVSEL		(9)		/* DEVSEL Timing */
#define	b_PCIC_STRGT_ABORT	(11)	/* Signaled Targen Abort */
#define	b_PCIC_RTRGT_ABORT	(12)	/* Received Targen Abort */
#define	b_PCIC_RMSTR_ABORT	(13)	/* Received Maser Abort */
#define b_PCIC_SYS_ERR		(14)	/* Signaled System Error */
#define b_PCIC_PERR			(15)	/* Detect Parity Error */

/* Value of B_PCIC_DEVSEL */
#define PCIC_DEVSEL_FAST	(0)		
#define	PCIC_DEVSEL_MID		(1)	
#define	PCIC_DEVSEL_SLOW	(2)

/* Bit definition of command register */
#define	PCIC_CMD_MASK		0x01ff	/* Mask Pattern of Command Register */
#define	B_PCIC_IO_SPACE		(1<<0)	/* IO SPACE ENABLE	*/
#define	B_PCIC_MEM_SPACE	(1<<1)	/* Memory Space Enable */
#define B_PCIC_BMASTER		(1<<2)	/* Bus Master	*/
#define B_PCIC_SPCL_CYCL	(1<<3)	/* Special Cycles	*/
#define	B_PCIC_MWI_EN		(1<<4)	/* Memory Write and Invalidate Enable */
#define	B_PCIC_VGA_PLT		(1<<5)	/* VGA pallette snoop */
#define	B_PCIC_PERR_RES		(1<<6)	/* Parity Error Response */
#define B_PCIC_WAIT_CYCL	(1<<7)	/* Wait Cycle Control */
#define	B_PCIC_SERR_EN		(1<<8)	/* SERR# Enable */
#define B_PCIC_FBTB_EN		(1<<9)	/* Fast back to back enable */

#define	b_PCIC_IO_SPACE		(0)	/* IO SPACE ENABLE	*/
#define	b_PCIC_MEM_SPACE	(1)	/* Memory Space Enable */
#define b_PCIC_BMASTER		(2)	/* Bus Master	*/
#define b_PCIC_SPCL_CYCL	(3)	/* Special Cycles	*/
#define	b_PCIC_MWI_EN		(4)	/* Memory Write and Invalidate Enable */
#define	b_PCIC_VGA_PLT		(5)	/* VGA pallette snoop */
#define	b_PCIC_PERR_RES		(6)	/* Parity Error Response */
#define b_PCIC_WAIT_CYCL	(7)	/* Wait Cycle Control */
#define	b_PCIC_SERR_EN		(8)	/* SERR# Enable */
#define b_PCIC_FBTB_EN		(9)	/* Fast back to back enable */

/* Base Address Registers */
#define	PCIC_MEM_BASE_MASK	0xfffffff0	/* Mask pattern of memory map 
										   base address register */ 
#define	PCIC_IO_BASE_MASK	0xfffffffc	/* Mask pattern of IO map 
										   base address register */ 

#define	B_PCIC_MBASE_SPC_IND (1<<0) /* memory space indicator (ALWAYS 0) */
#define	B_PCIC_MBASE_TYPE	 (3<<1)	/* Type of memory space */
	/* Value of B_PCIC_MBASE_TYPE */
#	define	PCIC_MBASE_TYPE_32	 0		/* In 32Bit memory space. */
#	define PCIC_MBASE_TYPE_1M	 1		/* Under 1M Bytes Memory Space */
#	define PCIC_MBASE_TYPE_64	 2		/* In 64Bit Memory space */
#define B_PCIC_MBASE_PREFETCH (1<<3) /* Prefetchable */

#define	b_PCIC_MBASE_SPC_IND  (0) 	/* memory space indicator (ALWAYS 0) */
#define	b_PCIC_MBASE_TYPE	  (1)	/* Type of memory space */
#define b_PCIC_MBASE_PREFETCH (3) 	/* Prefetchable */

#define B_PCIC_IOBASE_SPC_IND (1<<0) /* I/O space indicator (ALWAYS 1) */

#define PCIC_NO_IRQPIN	0
#define PCIC_IRQ_INT_A	1			/* IRQ PIN INTA# */
#define PCIC_IRQ_INT_B	2			/* IRQ PIN INTB# */
#define PCIC_IRQ_INT_C	3			/* IRQ PIN INTC# */
#define PCIC_IRQ_INT_D	4			/* IRQ PIN INTD# */

error_code	get_pci_config_register(PCI_config_reg, const PCI_config_reg);

#define PCI_DEVICE_NCR53C810	0x0001	/* NCR53C810 DEVICE ID */
#define PCI_DEVICE_NCR53C820	0x0002	/* NCR53C820 DEVICE ID */
#define PCI_DEVICE_NCR53C825	0x0003	/* NCR53C825 DEVICE ID */

#define PCI_VENDOR_ID_NCR		0x1000	/* NCR Vendor CODE	   */


#define	_PCICNFG_H_	1

#endif
