/*
 * $Header:   /h0/MWOS/SRC/DEFS/HW/VCS/pic.h_v   1.2   13 Jan 1996 20:20:04   allan  $
 * $Revision:   1.2  $
 */
/*--------------------------------------------------------------------------,
|                                                                           |
|           Copyright 1989, 1994, 1996 by Microware Systems Corporation     |
|                          Reproduced Under License                         |
|                                                                           |
|  This source code is the proprietary confidential property of Microware   |
|  Systems Corporation, and is provided to licensee for documentation and   |
|  educational purposes only. Reproduction, publication, or distribution    |
|  in any form to any party other than the licensee is strictly prohibited. |
|                                                                           |
|---------------------------------------------------------------------------|
| Definitions for the programmable interrupt controller.					|
|																			|
| Edition History:															|
|																			|
| Ed#	Date	Changes													By	|
| --- --------	------------------------------------------------------- --- |
|  01 89/02/14  Created.												rg	|
|  02 94/10/19  Added keyboard int mask bit.                            dkg |
!               ---- OS-9000/PPC V2.0 Release ----                          ! 
|																			|
`--------------------------------------------------------------------------*/


#define PIC_MASTER		0x20			/* address pic master */
#define PIC_SLAVE		0xa0			/* address pic slave  */
#define KYBD_MASK		0x02			/* mask for keyboard interrupt */

/* register name offsets */
#define ICW1			0x00			/* pic mode of operation */
/* #define ICW1_VAL		0x11			/* pic mode of operation value */
#define	ICW1_VAL		0x19			/* pic mode of operation value */

#define ICW2			0x01			/* vector number register */
#define MASTER_VECT		0x40			/* master IC vector number */
#define SLAVE_VECT		0x48			/* slave IC vector number */

#define ICW3			0x01			/* slave enable register */
#define ICW3_MASTER_VAL 0x04			/* use slave pic */
#define ICW3_SLAVE_VAL 	0x02			/* use slave pic */

#define ICW4			0x01			/* more setup values */
#define ICW4_MASTER_VAL 0x0d			/* set master pic */
#define ICW4_SLAVE_VAL	0x09			/* set slave pic */

#define OCW1			0x01				/* interrupt enable register */
#define IRQ_TIMER1		0x01	/* timer interrupt enable bit */
#define IRQ_KEYBOARD	0x02	/* keyboard interrupt enable bit */
#define IRQ_SLAVE		0x04	/* slave interrupt enable bit */
#define IRQ_COM2		0x08	/* 8251 interrupt enable bit */
#define IRQ_COM1		0x10	/* 8251 interrupt enable bit */
#define IRQ_EXT2		0x20	/* extension interrupt enable bit */
#define IRQ_FLOPPY		0x40	/* floppy interrupt enable bit */
#define IRQ_LPT1		0x80	/* extension interrupt enable bit */
#define IRQ_M_ALL		0x00				/* enable all master interrupts */

#define IRQ_RTC			0x01	/* SCSI interrupt enable bit */
#define IRQ_EXPBUS1		0x02	/* extension interrupt enable bit */
#define IRQ_EXPBUS2		0x04	/* extension interrupt enable bit */
#define IRQ_EXPBUS3		0x08	/* extension interrupt enable bit */
#define IRQ_AUX1		0x10	/* printer interrupt enable bit */
#define IRQ_COPROCERR	0x20	/* extension interrupt enable bit */
#define IRQ_HARD		0x40	/* extension interrupt enable bit */
#define IRQ_EXPBUS4		0x80	/* extension interrupt enable bit */
#define IRQ_S_ALL		0x00				/* enable all slave interrupts */
