/*
 * $Header:   /h0/MWOS/SRC/DEFS/HW/VCS/z85x30.h_v   1.4   13 Jan 1996 20:20:10   allan  $
 */
/*--------------------------------------------------------------------------,
|                                                                           |
|           Copyright 1989, 1995, 1996 by Microware Systems Corporation     |
|                          Reproduced Under License                         |
|                                                                           |
|  This source code is the proprietary confidential property of Microware   |
|  Systems Corporation, and is provided to licensee for documentation and   |
|  educational purposes only. Reproduction, publication, or distribution    |
|  in any form to any party other than the licensee is strictly prohibited. |
|                                                                           |
|---------------------------------------------------------------------------|
| Definitions for the Zilog Z85x30 SCC family.								|
|																			|
| Edition History:															|
|																			|
| Ed#	Date	Changes													By	|
| --- --------	------------------------------------------------------- --- |
|  01 88/05/31  Conversion to OS-9000.									jal	|
|  03 88/11/14  Converted for use in boot code.							djl |
|  04 95/04/11  Trimmed to device-specific definitions only.            ats |
|               Added baud rate & register offset computations.             |
|               Added parity, stop bits and clock mode definitions.         |
|  05 95/05/17  Added ERRESET command to clear receive errors.          ats |
|  06 95/11/08  Allow caller overrides of COMMAND and DATA definitions. ats |
|				--- OS-9/68K V3.0.2 System-state Debug Support Release ---  |
!               ---- OS-9000/PPC V2.0 Release ----                          ! 
`--------------------------------------------------------------------------*/

#ifndef	_Z85X30_H_

#define	_Z85X30_H_

/* Baud rate computation  - uses fixed point rounding */

#define BAUD(x)		((((SERCLK*10/(x)/CLKMODE/2)+5)/10)-2)
#define BAUD2(x)	((((SERCLK*10/(x)/CLKMODE)+5)/10)-2)

#ifndef	CLKMODE
#define	CLKMODE	16
#endif

/* Default BUS_WIDTH and BYTE_OFFSET definitions */

#ifndef BUS_WIDTH
#define BUS_WIDTH	2	/* MVME162 example definition */
#endif

#ifndef BYTE_OFFSET
#define	BYTE_OFFSET	1	/* MVME162 example definition */
#endif

/*
 * Register array offset computations
 */

#ifndef	COMMAND
#define COMMAND		(0*BUS_WIDTH)+BYTE_OFFSET	/* Command/Status */ 
#endif

#ifndef	DATA
#define DATA		(1*BUS_WIDTH)+BYTE_OFFSET	/* Transmit/Receive Data */
#endif

/*
 * Indirect Register definitions for the Zilog 85x30 family
 */

/*
 * Write Registers [Passed to the chip before a write] : (Channels A & B)
 */
 
#define CMDREG		0	/* CRC and mode initialization, shift left/right.	*/
#define IRQCTLREG	1	/* TX/RX interrupt and data transfer mode defs.		*/
#define VECTREG		2	/* Interrupt vector (A and B channels).				*/
#define RXCTLREG	3	/* Receive parameters and control.					*/
#define MISCREG04	4	/* TX/RX misc. parameters and modes.				*/
#define TXCTLREG	5	/* TX parameters and controls.						*/
#define SYNCREG0	6	/* Sync chars or SDLC address field.				*/
#define SYNCREG1	7	/* Sync char or SDLC flag.							*/
#define TXBUFREG	8	/* TxBufReg Transmit buffer.						*/
#define RSTMIEREG	9	/* Reset and Master irq control (both channels)		*/
#define MISCREG10	10	/* Misc. TX/RX control bits.						*/
#define CLKMODEREG	11	/* Clock mode control.								*/
#define TMRLSBREG	12	/* Lower byte of Baud Rate Generator Time Constant.	*/
#define TMRMSBREG	13	/* Upper byte of Baud Rate Generator Time Constant.	*/
#define MISCREG14	14	/* Misc. control bits.								*/
#define EXSTATREG	15	/* External/Status interrupt control.				*/

/*
 * Read registers: (Channels A & B)
 */

#define RR0 		0	/* TX/RX buffer status and External status.			*/
#define STATREG1	1	/* Special Receive Condition status.				*/
#define RR2			2	/* Modified interrupt vector (Channel B only).		*/
#define RR3			3
#define RR8			8	/* Receive buffer.									*/
#define RR10		10	/* Misc. status.									*/
#define RR12		12	/* Lower byte of Baud Rate Generator Time Constant.	*/
#define RR13		13	/* Upper byte of Baud Rate Generator Time Constant.	*/
#define RR15		15	/* External/Status interrupt information.			*/

/*
 * Bit/Command definitions for 8030/8530 Write Registers
 */

/*
 * Command Register (WR0) (a.k.a.: unit_static->v_port[COMMAND]
 */
 
#define RTIP	0x28		/* %00101000 reset TX int pending.	*/
#define ERRESET	0x30		/* %00110000 error reset			*/
#define RHIUS	0x38		/* %00111000 reset highest IUS		*/

/*
 * Write Register 1
 */
 
#define TIE		0x02		/* %00000010 = TX interrupt enable bit	*/
#define IARCS	0x10		/* %00010000 Int on all RX chars or special condition.	*/

/*
 * Write Register 3
 */

#define RXEN	0x01		/* %00000001 = Rx Enable bit	*/
#define	RXBPC5	0x00		/* five data bits 				*/
#define RXBPC6	0x80		/* six data bits				*/
#define	RXBPC7	0x40		/* seven data bits				*/
#define RXBPC8	0xc0		/* eight data bits				*/

/*
 * Write Register 4
 */

#define	PARODD		0x01	/* odd parity					*/
#define PAREVEN		0x03	/* even parity                  */
#define	SB1			0x04	/* one stop bit 				*/
#define SB1P5		0x08	/* 1.5 stop bits				*/
#define SB2			0x0C	/* 2 stop bits					*/
#define CLCK1		0x00	/* x1 clock mode				*/
#define CLCK16		0x40	/* %01000000 = x16 clock mode.	*/
#define CLCK32		0x80	/* x32 clock mode				*/
#define CLCK64		0xC0	/* x64 clock mode				*/

/*
 * Write Register 5
 */

#define RTS		0x02		/* %00000010 = request to send bit				*/
#define TXEN	0x08		/* %00001000 = TX enable bit					*/
#define BREAK	0x10		/* %00010000 = send break bit					*/
#define	TXBPC5	0x00		/* five data bits								*/
#define	TXBPC6	0x40		/* six data bits								*/
#define	TXBPC7	0x20		/* seven data bits								*/
#define	TXBPC8	0x60		/* eight data bits								*/
#define DTR		0x80		/* %10000000 = data terminal ready/request bit	*/

/*
 * RSTMIEREG (WR9): Reset and master irq control register
 */
 
#define NORESET		0x00	/* No Reset									*/
#define VIS			0x01
#define NV			0x02	/* no vectoring								*/
#define DLC			0x04
#define MIE			0x08	/* master interrupt enable					*/
#define SHILO		0x10	/* status high/low.							*/
#define RESETA		0x80	/* reset channel A bit of control register	*/
#define RESETB		0x40	/* reset channel B bit of control register	*/
#define RESET		0xC0	/* %11000000 = force hardware reset.		*/

/*
 * Write Register 11
 */
 
#define TRXCB		0x02	/* %00000010 TRXC out=Baud Rate Generator output.	*/
#define TXCLKO		0x04	/* %00000100 = direction of TRXC pin. (0=in,1=out)	*/
#define TXCLKS		0x10	/* %00010000 = TX clk=BR generator output.	*/
#define	TXCLKR		0x00	/* TX clk=RTxC input 						*/
#define RXCLKS		0x40	/* %01000000 = RX clk=BR generator output.	*/
#define	RXCLKR		0x00	/* RX clk=RTxC input						*/
#define	OUTTXCLK	0x01	/* TRxC output = transmit clock				*/
 
#define BRGE		0x01	/* %00000001 = BR generator enable				*/
#define BRGS		0x02	/* %00000010 = BR generator source.				*/

/*
 * Write Register 14
 */

#define BAUDEN		0x01	/* baud rate generator enable 					*/
#define BCLKS		0x02	/* baud rate generator source          			*/
#define SSBRG		0x80	/* %10000000 = set source=Baud Rate Generator.	*/
#define DDPLL		0x60	/* %01100000 = disable DPLL.					*/

/*
 * Read Register 0
 */
 
#define RXAVAIL		0x01	/* bit 0 = receiver available (%00000001)	*/
#define TXEMPTY		0x04	/* bit 2 = transmitter empty  (%00000100)	*/
#define WUZZITME	0x07	/* check bits 0-2 to see if irq was mine	*/
#define CTSPIN		0x20	/* bit 5 = CTS pin state					*/

/*
 * Read Register 1:
 */

#define PARERR		0x10	/* parity error */
#define OVRNERR		0x20	/* receive overrun error */
#define FRMERR		0x40	/* framing error */

/*
 * Read Register 2: (Interrupt Vector only - modified in channel B)
 */

/*
 * Read Register 3:
 */

#define ESIRQPB		0x01
#define TXIRQPB		0x02
#define RXIRQPB		0x04
#define ESIRQPA		0x08
#define TXIRQPA		0x10
#define RXIRQPA		0x20

#endif	/* _Z85X30_H_ */
