/*
 * $Header:   /h0/MWOS/SRC/DEFS/ROM/VCS/fdman.h_v   1.2   13 Jan 1996 20:27:22   allan  
 */

/*
 * definitions for Partitioning
 *
 * Copyright 1995, 1996 by Microware Systems Corporation
 * Reproduced Under License
 *
 * This source code is the proprietary confidential property of
 * Microware Systems Corporation, and is provided to licensee
 * solely for documentation and educational purposes. Reproduction,
 * publication, or distribution in any form to any party other than
 * the licensee is strictly prohibited.
 *
 * history:
 *
 * ed.  date.   reason.                                       who.
 * -- --------  --------------------------------------------  ---
 * 01 95/12/20  created 									  GbG
 * 02 96/01/04  Added infoid field and value definitions,     ats
 *              and reserved fields to fdman_svcs structure.
 *              ---- OS-9000/PPC V2.0 Release ----            
 */

/*
 * general constant definitions
 */

#ifndef		MAXDRVS
#define		MAXDRVS			14			/* max number of drives */
#endif

#define		MAX_PARTITIONS	5			/* max number of partitions */
#define		PARTITION_FLAG	0xaa55		/* last word of block 0 */
#define     ADDOFF          1           /* add offsets */
#define     NO_ADDOFF       0           /* don't add offsets */


/* 
 *    partition related constants  
 */

#define		PARTITION_FLG_O		0x000001fe	/* 0x55aa indicator */
#define		PARTITION_OFFSET	0x000001be	/* start of hard disk partition */
#define		PAR_BLK_SHIFT		2			/* shift value for partition blk */

/*
 *   hard disk partition structure definition 
 */

typedef struct partition {
	u_char		par_status,				/* the partition status */
				par_start_head;			/* the starting head number */
	u_int16		par_start_cyl_blk;		/* the starting cyl & blk */
	u_char		par_type,				/* partition type */
				par_end_head;			/* the ending head number */
	u_int16		par_end_cyl_blk;		/* the ending cyl & blk */
	u_int32		par_start_blk;			/* starting logical block */
	u_int32		par_size;				/* size in terms of blocks */
} partition, *Partition;

/* valid status values */
#define NONACTIVE	0x00
#define ACTIVE		0x80

/* partition types */
#define	PRIDOS12	0x01
#define XENIX		0x02
#define	PRIDOS16	0x04
#define	EXTDOS		0x05
#define	BIGDOS		0x06
#define	OS9000		0x09
#define NOVELL		0x64
#define PCIX		0x75
#define CPM			0xdb
#define BBT			0xff


#define PReP_TYPE41	0x41	/* PowerPC Reference Pratform Partition Type 41 */

/*
 * PowerPC Reference Pratform Partition Type 41
 * Data Structure Definition.
 */

typedef	struct	type41_part
{
	u_int32	entry_point_offset;	/* LE Entry point offset in load image 	*/
	u_int32	load_image_length;	/* LE Size of load image				*/
	u_int8	flag_field;			/* Flag Field.							*/
	u_int8	os_id;				/* Operating system identifier.			*/
	u_char	partition_name[32];	/* partition name						*/
	u_char	reserve[470];
} type41_partition, *TYPE41_partition;

/*
 * PowerPC Reference Pratform Partition Type 41
 * OS Specific field data structure.
 */

typedef	struct	type41_os_spec
{
	u_int32	reserve[128];
}	type41_os_spec, *TYPE41_os_spec;

#if !defined(SWAPLONG)
#define	SWAPLONG(a) \
	(((a)&0xff000000)>>24) | (((a)&0xff0000)>>8) |\
	(((a)&0xff00)<<8)|(((a)&0xff)<<24)
#define SWAPWORD(a) \
		((a>>8)&0xff)|((a<<8)&0xff00)
#endif

/* fdman prototypes */

error_code get_partition( u_int32 lsnoffs, u_int8 pari_start, 
		u_int8 pari_end, u_char *sect0, u_int32 *offs, 
		Bootdev bdev, Rominfo rinf);

error_code read_bootfile(u_int32 ssize, u_int32 lsnoffs, u_int8 pari_start,
	u_int8 pari_end, Bootdev bdev, Rominfo rinf);


/* FDMAN STRUCTURE */

/* NOTE: The structure ID definition (FDMSVCID) is reserved in rom.h */

/*
 * version changes:
 * 1: original
 */

#define FDM_VER_MIN	1
#define FDM_VER_MAX	1

typedef struct fdman_svcs {

	idver		infoid;				/* id/version for fdman_svcs */
	
	error_code	(*get_partition) ( u_int32 lsnoffs, u_int8 pari_start, 
					u_int8 pari_end, u_char *sect0, u_int32 *offs, 
					Bootdev bdev, Rominfo rinf);

	error_code 	(*read_bootfile) (u_int32 ssize, u_int32 lsnoffs, 
				u_int8 pari_start,	u_int8 pari_end, 
				Bootdev bdev, Rominfo rinf);

	error_code	(*fdboot) ( u_char *addr, u_int32 siz, 
				Bootdev bdev, Rominfo rinf);

	u_int32		reserved[3];		/* reserved for emergency expansion */
	
} fdman_svcs, *Fdman_svcs;




