
/*
 * $Header:   /h0/MWOS/SRC/DEFS/ROM/VCS/p2lib.h_v   1.7   13 Jan 1996 20:27:36   allan  $
 */
   
  /*--------------------------------------------------------------------------,
  !                                                                           !
  !  Copyright 1995,1996 by Microware Systems Corporation                     !
  !                          Reproduced Under License                         !
  !                                                                           !
  !  This source code is the proprietary confidential property of Microware   !
  !  Systems Corporation, and is provided to licensee for documentation and   !
  !  educational purposes only. Reproduction, publication, or distribution    !
  !  in any form to any party other than the licensee is strictly prohibited. !
  !                                                                           !
  !---------------------------------------------------------------------------!
  !                                                                           !
  ! p2lib.h - public functions for P2 modules                                 !
  !                                                                           !
  ! edition history                                                           !
  !                                                                           !
  !   date     changes                                                    by  !
  ! -------- -----------------------------------------------------------  --- !
  ! 95/07/11  History started                                             gls !
  ! 95/10/17  Fixed ISYNC_M() function prototype.                         ats !
  !           ---- OS-9/68K V3.0.2 System-state Debug Support Release ----    !
  !           ---- OS-9000/PPC V2.0 Release ----                              !
  !                                                                           !
  `--------------------------------------------------------------------------*/

extern error_code	getrinf(Rominfo *rinf_p);

/* probe types */
#define HWPROBE_8BITS	1
#define	HWPROBE_16BITS	2
#define	HWPROBE_32BITS	3
extern error_code	hwprobe(void *addr, u_int32 ptype, Rominfo rinf);

extern char			*inttoascii(u_int32 value, char *bufptr);

#ifdef	_MPFPOWERPC
extern void			ISYNC_M(void);
#else
#define	ISYNC_M()
#endif

extern void			outhex(u_char nibble, Rominfo rinf);
extern void			out1hex(u_char byte, Rominfo rinf);
extern void			out2hex(u_int16 word, Rominfo rinf);
extern void			out4hex(u_int32 longword, Rominfo rinf);

#define	ROM_UDIV(a,b)	(a/b)

extern u_int32 		setexcpt(u_int32 vector, u_int32 irqsvc, Rominfo rinf);
#ifdef	_MPFPOWERPC
extern u_int32 		storexcpt(u_int32 vector, u_int32 irqsvc, Rominfo rinf);
#define	resetexcpt	storexcpt
#else
#define	resetexcpt	setexcpt
#endif

extern u_char		*swap_globals(u_char *newglbls);

#ifdef NOROMINFO
error_code p2start(Sysglobs); /* only to be used by the rominfo P2 module */
#else
error_code p2start(Rominfo rinf, u_char *glbls);
#endif
