/*
 * $Header:   /h0/MWOS/SRC/DEFS/ROM/VCS/scsiman.h_v   1.4   13 Jan 1996 20:28:02   allan  $
 */
 
/*
 * definitions for SCSI Protocol Manager
 *
 * Copyright 1995, 1996 by Microware Systems Corporation
 * Reproduced Under License
 *
 * This source code is the proprietary confidential property of
 * Microware Systems Corporation, and is provided to licensee
 * solely for documentation and educational purposes. Reproduction,
 * publication, or distribution in any form to any party other than
 * the licensee is strictly prohibited.
 *
 *
 *	Edition History:														
 *	#   Date    Comments												By
 *	-- -------- ------------------------------------------------------- ---
 *  01 95/09/24 Created.												GbG
 *  02 96/01/04 Added infoid field and value definitions, and reserved  ats
 *              fields to scsiman_svcs and llscsi_svcs structures.
 *  03 96/01/04 Changed cmdblk to scsicmdblk. Structure added
 *				Also moved defs into "scsidefs.h"						GbG
 *  04 96/01/09 Added SCSI reset flag									GbG
 *              ---- OS-9000/PPC V2.0 Release ----          
 */

#include	<scsidefs.h>

/* WARNING: if the following structure ever changes size,
            scsiman_svcs compatibility is broken!! */

typedef struct scsicmdblk {
	void	*_cb_cmdptr;		/* pointer to the scsi command */
	void	*_cb_datptr;		/* pointer to the data area */
	void	*_cb_errptr;		/* pointer to the error data area */
	u_int	_cb_cmdlen;			/* length of the command block */
	u_int	_cb_datlen;			/* expected data length */
	u_int	_cb_errlen;			/* expected error length */
	u_int	_cb_scsi_id;		/* the target id */
	u_char	_cb_pd_lun;			/* the target lun */
	u_char	_cb_xfer;			/* data input/output flag */
} *Scsicmdblk;


/* SCSI MAN STRUCTURE */

/* NOTE: The structure ID definition (SMSVCID) is reserved in rom.h */

/*
 * version changes:
 * 1: original
 */
   
#define SM_VER_MIN 1
#define SM_VER_MAX 1

typedef struct scsiman_svcs {

	idver		infoid;			/* id/version for fdman_svcs */	

	Bootdev		smbtr;	/* SCSIMAN bootdev record pointer */
	Bootdev		llbtr;	/* low level bootdev record pointer */

	error_code  (*ll_install) ( char *name, u_int8 *portaddr,
				u_int8 selfid, 	u_int8 reset, Bootdev bdev, Rominfo rinf);

	error_code	(*da_execute) ( u_int32 opcode, u_int32 blkaddr, 
					u_int32 bytcnt, u_int32 cmdopts, u_char *buff, 
					u_int32 xferflags, u_int32 cmdtype, 
					Bootdev bdev, Rominfo rinf);

	error_code	(*sq_execute) ( u_int32 opcode, u_int32 blkcount, 
				u_int32 opts, u_int32 action, u_char *buff, 
				u_int32 xferflags, 	u_int32 bytemode, 
				Bootdev bdev, Rominfo rinf);

	error_code	(*da_execnoxfer) (u_int32 opcode, u_int32 blkaddr, 
				u_int32 bytcnt, u_int32 cmdopts, u_int32 cmdtype, 
				Bootdev bdev, Rominfo rinf);

	error_code	(*sq_execnoxfer) (u_int32 opcode, u_int32 blkcount, 
				u_int32 opts, u_int32 action, Bootdev bdev, Rominfo rinf);

	u_int32 	(*readsccs) (u_int32 numsects, u_int32 blkaddr,
				u_char *buff,  Bootdev bdev, Rominfo rinf);

	u_int32		(*initsccs) (Bootdev bdev, Rominfo rinf);

	error_code	(*rewind_tape) (Bootdev bdev, Rominfo rinf);

	error_code	(*init_tape) (Bootdev bdev, Rominfo rinf);

	u_int32		residual;	/* Tape residual */
	u_int32		fstatus;	/* Tape status */
	u_int8		ctrlid;		/* SCSI controller ID */
	u_int8		lun;		/* SCSI LUN */
	u_int8		pari_start;	/* DISK Partition index Start number */
	u_int8		pari_end;	/* DISK Partition index number */
	u_int32		ssize;		/* Disk Block Size */
	u_int32		stsize;		/* Tape Block Size */
	u_int32		lsnoffs;	/* logical sector offset */
	u_char		*pathbuf;	/* pathbuf pointer */

	/* WARNING: If any of the following structures ever change
				size compatibility is broken!! */
	            
	union	scsipkt		scsicmd;    /* SCSI command packet */
			errdet		err_det;    /* error detail block */
	struct	scsicmdblk	scsicmdblk;	/* the command block */
			dsize		drvsize;	/* drive size */
			enqdet		inquir;     /* inquiry data area */

	u_int32		reserved;	/* reserved for emergency expansion */

} scsi_svcs, *Scsi_svcs;

/* Low Level SCSI STRUCTURE */

/* NOTE: The structure ID definition (LLSSVCID) is reserved in rom.h */

/*
 * version changes:
 * 1: original
 */
   
#define LLS_VER_MIN 1
#define LLS_VER_MAX 1

typedef struct low_level_scsi_svcs {

	idver		infoid;			/* id/version for llscsi_svcs */

	error_code 	(*llinit) ( Bootdev bdev, Rominfo rinf);

	error_code 	(*llterm) ( Bootdev bdev, Rominfo rinf);

	error_code  (*llexec) (Scsicmdblk cmd, u_int32 atn, u_int32 llcmd, 
					Bootdev bdev, Rominfo rinf);

	error_code	(*llcmd)  ( u_int8 *cmd, u_int8 *dat, u_int32 drive_id, 
					Bootdev bdev, Rominfo rinf);

	u_int8		selfid;			/* scsi self id */
	u_int8		debug;			/* scsi debug flag */
	u_int8		reset;			/* scsi reset flag */
	u_char		*cdevname;		/* controller device name */
	u_int8		reserved1;		/* reserved for emergency expansion */

	u_int32		reserved2;		/* reserved for emergency expansion */
	
} llscsi_svcs, *Llscsi_svcs;

