
/*
 * $Header:   /h0/MWOS/SRC/DEFS/ROM/VCS/trapanch.h_v   1.6   13 Jan 1996 20:28:06   allan  $
 */
  
   /*--------------------------------------------------------------------------,
   !                                                                           !
   !  Copyright 1995, 1996 by Microware Systems Corporation                    !
   !                          Reproduced Under License                         !
   !                                                                           !
   !  This source code is the proprietary confidential property of Microware   !
   !  Systems Corporation, and is provided to licensee for documentation and   !
   !  educational purposes only. Reproduction, publication, or distribution    !
   !  in any form to any party other than the licensee is strictly prohibited. !
   !                                                                           !
   !---------------------------------------------------------------------------!
   !                                                                           !
   ! trapanch.h - Trap (exception) recovery anchor structure/value definitons. !
   !                                                                           !
   ! edition history                                                           !
   !                                                                           !
   !   date     changes                                                    by  !
   ! -------- -----------------------------------------------------------  --- !
   ! 95/07/11  History started                                             gls !
   !           ---- OS-9000/PPC V2.0 Release ----                              !
   !                                                                           !
   `--------------------------------------------------------------------------*/

#ifdef	_MPF68K
typedef struct {
	u_short		movel_op1;		/* move.l (sp),d1 get vector # off stack */
	u_short		addi_op;		/* addi.l #imm,d1 add MAX_TRAP_BIAS */
	u_int32		imm_val1;
	u_short		movel_op2;		/* move.l #imm,d0 address of jmp_buf */
	u_int32		imm_val2;
	u_short		movel_op3;		/* move.l #imm,(sp) address of longjmp */
	u_int32		imm_val3;
	u_short		rts_op;			/* rts */
} trapanchor, *Trapanchor;

#define MAX_TRAP_BIAS	256

#define	MOVEL_SPIND_D1	0x2217
#define	ADDI_IMM_D1		0x0681
#define MOVEL_IMM_D0	0x203C
#define MOVEL_IMM_SPIND	0x2EBC
#define RTS				0x4E75
#endif	/* _MPF68K */

#ifdef	_MPF386
typedef struct {
	u_char		popl_op;		/* pop.l %eax pop off vector # */
	u_char		addl_op;		/* add.l #imm,%eax add MAX_TRAP_BIAS */
	u_int32		imm_val1;
	u_char		pushl_op1;		/* push.l %eax push as second parameter */
	u_char		movl_op1;		/* mov.l #imm,%eax address of longjmp */
	u_int32		imm_val2;
	u_char		pushl_op2;		/* push.l %eax push as return address */
	u_char		movl_op2;		/* mov.l #imm,%eax address of jmp_buf */
	u_int32		imm_val3;
	u_char		ret_op;			/* ret */
} trapanchor, *Trapanchor;

#define MAX_TRAP_BIAS	256

#define POPL_EAX		0x58
#define	ADDL_IMM_EAX	0x05
#define	PUSHL_EAX		0x50
#define MOVL_IMM_EAX	0xB8
#define	RET				0xC3
#endif	/* _MPF386 */

#ifdef	_MPFPOWERPC
typedef struct {
	u_int32		rlwinm_op;		/* rlwinm r4,r5,8,0,31 multiply vector by 256 */
	u_int16		addi_op;		/* addi  r4,r4,imm add MAX_TRAP_BIAS */
	u_int16		imm_val;
	u_int16     addis_op1;		/* addis r3,0,hi(#imm)  &jmp_buf upper value */
	u_int16		hi_imm_val1;
	u_int16		ori_op1;		/* ori   r3,r3,lo(#imm) &jmp_buf lower value */
	u_int16		lo_imm_val1;
	u_int16     addis_op2;		/* addis r0,0,hi(#imm) &longjmp upper value */
	u_int16		hi_imm_val2;
	u_int16		ori_op2;		/* ori   r0,r0,lo(#imm) &longjmp lower value */
	u_int16		lo_imm_val2;
	u_int32		mtlr_op;		/* mtlr  r0 prepare for transfer to longjmp */
	u_int32		blr_op;			/* blr   go there now */
} trapanchor, *Trapanchor;

#define	MAX_TRAP_BIAS	0x3000

#define	RLWINM_R4_R5_8_0_31	0x54A4403E
#define ADDI_R4_R4_IMM		0x3884
#define ADDIS_R3_0_IMM		0x3C60
#define ORI_R3_R3_IMM		0x6063
#define ADDIS_R0_0_IMM		0x3C00
#define	ORI_R0_R0_IMM		0x6000
#define	MTLR_R0				0x7C0803A6
#define BLR					0x4E800020
#endif	/* _MPFPOWERPC */
