/*
 * OS-9/OS-9000 implementation specific code, enhancements and modifications:
 *
 * Copyright 1991 Microware Systems Corporation
 * All Rights Reserved
 *
 * Use and/or distribution subject to terms and conditions of applicable
 * Microware license agreement(s).
 *
 * Current Version: @(#)os9def.h	1.3 12/23/91
 */

#if !defined(_OS9DEF_H)
#define _OS9DEF_H

#define EACCES EOS_PERMIT
#define EBADF  EOS_BPNUM
#define EEXIST EOS_CEF
#define ENOMEM EOS_NORAM
#define EINVAL EOS_ILLARG
#define ENOENT EOS_PNNF
#define EINTR  EALREADY
#define EPIPE  EOS_EOF
#define EIO	   EOS_READ
#define EPERM  EOS_FNA
#define ESRCH  EOS_IPRCID
#define ENXIO  EOS_NOTRDY
#define ECHILD EOS_NOCHLD
#define EBUSY  EOS_DEVBSY
#define ENODEV EOS_NOTRDY
#define EFAULT EOS_BPADDR
#define F_OK   0
#define X_OK   S_IEXEC
#define W_OK   S_IWRITE
#define R_OK   S_IREAD

#if defined(_OSK)
#define O_RDWR   S_IREAD|S_IWRITE
#define	O_WRONLY S_IWRITE
#define O_RDONLY S_IREAD
#define	O_CREAT	 0
#define	O_TRUNC	 0
#endif

#define seteuid(uid) setuid(uid)
#define geteuid() getuid()
#define vfork() fork()
#define srandom(seed) srand(seed)
#define random() rand()
#define sigsetmask(mask) sigmask(mask)
#define killpg(pid,sigcode) kill(pid,sigcode)
#define NOFILE 32
#define MAXPATHLEN 1024 /* not really a limit on OS9 */

typedef char *  caddr_t;

struct iovec {
	caddr_t   iov_base;
	int  iov_len;
};

int execl(char *path, char *arg0, ...);
int execle(char *path, char *arg0, ...);

#include <os9time.h>

#define LowerCase(a, b) OS9LowerCase(a, b, sizeof(b))

/*
 * Macros for fast min/max.
 */
#ifndef MIN
#define MIN(a,b) (((a)<(b))?(a):(b))
#endif
#ifndef MAX
#define MAX(a,b) (((a)>(b))?(a):(b))
#endif
 
#endif /* _OS9DEF_H */
