/*
 * OS-9/OS-9000 implementation specific code, enhancements and modifications:
 *
 * Copyright 1991 Microware Systems Corporation
 * All Rights Reserved
 *
 * Use and/or distribution subject to terms and conditions of applicable
 * Microware license agreement(s).
 *
 * Current Version: @(#)pwd.h	1.4 1/14/93
 */

#if !defined(_PWD_H)
#define _PWD_H

struct passwd {
  char *pw_name;
  char *pw_passwd;
  int  pw_uid;
  int  pw_gid;
  int  pw_prio;                 /* OS9: Priority of entry */
  char *pw_age;
  char *pw_comment;
  char *pw_gecos;
  char *pw_dir;
  char *pw_xdir;                /* OS9: Execution Directory */
  char *pw_shell;
  char *pw_junk;                /* everything else... */
};

#if !defined(__STDC__) && !defined(_ANSI_EXT) && !defined(__cplusplus)
extern struct passwd  *getpwent(), *getpwuid(), *getpwnam();
extern int            setpwent();
extern void           endpwent();
extern struct passwd  *fgetpwent();
#endif

#define PASSWD	"SYS/password"

#define PW_TIME     't'
#define PW_FLAG     'f'
#define PW_MOTD     'm'
#define PW_NAME     'n'
#define PW_COMMENT  'c'
#define PW_GECOS    'g'


struct gecos {
  char *fullname;
  char *organization;
  char *office_phone;
  char *home_phone;
};

#if !defined(__STDC__) && !defined(_ANSI_EXT) && !defined(__cplusplus)
extern struct gecos *getgecos();
#endif

#endif /* _PWD_H */
