#if !defined(_ALLOC_H)
#define _ALLOC_H

/*
 * $Header:   /h0/MWOS/OS9000/SRC/DEFS/VCS/alloc.h_v   1.3   20 Jan 1996 19:49:36   ric  $
 * $Revision:   1.3  $
 */

/*--------------------------------------------------------------------------,
|																			|
|				Copyright 1996 by Microware Systems Corporation				|
|							Reproduced Under License						|
|																			|
|  This source code is the proprietary confidential property of Microware	|
|  Systems Corporation, and is provided to licensee for documentation and	|
|  educational purposes only. Reproduction, publication, or distribution	|
|  in any form to any party other than the licensee is strictly prohibited.	|
|																			|
|---------------------------------------------------------------------------|
|																			|
|	OS-9000 kernel memory allocation definitions							|
|																			|
| edition history															|
|	#	date     comments												by  |
|  -- -------- -------------------------------------------------------- --- |
|	1 03-xx-88 Initial toy version created.								rfd |
|	2 94/01/25 Added resource lock support variable to the color node.		|
|			   Also, added Buddy allocator definitions.					afh |
|					---- OS-9000/PPC V2.0 Release ----						|
|																			|
`--------------------------------------------------------------------------*/

#if !defined(_TYPES_H)
#include <types.h>
#endif

#if !defined(_MODULE_H)
#include <module.h>
#endif


/* Buddy allocator specific definitions and macros */
#ifdef _BUDDY

#define MIN_LOG2 4			/* Minimum log2 value for memory allocation size */
#define MIN_BUDDY 4			/* Minimum power for minimum block size */
#define MAX_BUDDY 32		/* Maximum power for maxumum block size */
#define BUDDY_MEM 0xBB		/* Buddy memory color node identifier */

/* Macros for manipulating the tree of free block tags */
#define MOVE_LEFT(b) (b*2)
#define MOVE_RIGHT(b) ((b*2)+1)
#define MOVE_UP(b) ((u_int32)b>>1)

#define FREE_BLKLIST(c,k) ((Mem_list)(&c->fblks[k-MIN_LOG2]))
#define FREE_MEMLIST(c) ((Fblk_list)(&c->fblks[0]))

/* Macro to calculate the total number of blocks of size 2**d; total/size. */
#define TOTBLKS(n, d) (n->pow2siz >> d)

/* Macro to calculate the logical block number of a block of size 2**d. */
/* n = color node, a = block address, d = shift value for divisor */
#define BLKNUM(n, a, d) ((((char*)a - n->lolim) >> d) + TOTBLKS(n, d))

/* Macro for marking a buddy block allocated. */
/* n = color node, a = block address, d = shift value for divisor */
#define MARK_BUSY(n, a, d) \
{ \
	register u_int32 _blk = BLKNUM(n, a, d); \
	n->tags[_blk >> 3] |= (0x80 >> (_blk & 7)); \
}

/* Macro for marking a buddy block free. */
/* n = color node, a = block address, d = shift value for divisor */
#define MARK_FREE(n, a, d) \
{ \
	register u_int32 _blk = BLKNUM(n, a, d); \
	n->tags[_blk >> 3] &= (~(0x80 >> (_blk & 7))); \
}
	
/* Macro for testing the free status of a block. */
/* n = color node, b = block number, d = shift value for divisor */
#define IS_ALLOCATED(n, b, d) (n->tags[b >> 3] & ((0x80 >> (b & 7))))

#endif /* _BUDDY */


/* basic (old-style) free memory and fragment list */
typedef struct memlist {
	struct memlist
		*nxt,		/* ptr to next (higher addr) free block */
		*prv;		/* ptr to previous (lower addr) free block */
	u_int32
		blksiz,		/* size of this block */
		resv[1];	/* free block continues; at least 4 more bytes */
} mem_list, *Mem_list;


/* Buddy allocator structure definitions. */
#ifdef _BUDDY

/* Free block list structure definition */
typedef struct free_block_list {
	Mem_list
		nxt,
		prv;
} fblk_list, *Fblk_list;


/* memory list - one node per 'color' of memory for the buddy allocator */
typedef struct memcolor {
	unsigned char
		*lolim,		/* beginning absolute address for this type	*/
		*hilim;		/* ending absolute address +1 for this type	*/
	struct memcolor
		*nxt,		/* pointer to next color node				*/
		*prv;		/* pointer to previous color node			*/
	Mem_list
		free[2];	/* head of free list						*/
	u_int32
		frags,		/* total number of memory fragments			*/
		totfree;	/* total amount of memory in list			*/
	unsigned char
		*dma_addr;	/* translation address for dma's, etc.		*/
	u_int16
		access,		/* accessability							*/
		type,		/* memory type code							*/
		prior,		/* memory allocation priority				*/
		alloctype;	/* allocator type to use for this memory	*/
	u_int32
		lock,		/* resource lock variable */
		lktype,		/* type of resource lock (shared vs. local mem) */
		pow2siz,	/* power of two size of memory total		*/
		rsrv2[2];	/* reserved space							*/
	fblk_list
		fblks[28];	/* free memory block lists					*/
	unsigned char
		tags[1];	/* tree of 1-bit block tags: 0=free, 1=busy	*/
} mem_color, *Mem_color;


#else /* ! _BUDDY */


/* basic memory list - one node per 'color' of memory */
typedef struct memcolor {
	unsigned char
		*lolim,		/* beginning absolute address for this type 	*/
		*hilim;		/* ending absolute address +1 for this type 	*/
	struct memcolor
		*nxt,		/* ptr to next color node 						*/
		*prv;		/* ptr to previous color node 					*/
	Mem_list
		free[2];	/* head of free list ptr 						*/
	u_int32
		frags,		/* total number of memory fragments 			*/
		totfree;	/* total amount of memory in list 				*/
	unsigned char
		*dma_addr;	/* translation address for dma's, etc. 			*/
	u_int16
		access,		/* accessability 								*/
		type,		/* memory type code 							*/
		prior,		/* memory allocation priority 					*/
		alloctype;	/* allocator type to use for this memory		*/
	u_int32
		lock,		/* resource lock variable */
		lktype,		/* type of resource lock (shared vs. local mem) */
		granule,	/* granularity; block size of memory units 		*/
		rsrv2[2];	/* reserved space 								*/
} mem_color, *Mem_color;

#endif /* _BUDDY */


/* Shared and NVRAM need this at *lolim */
struct mem2 {
	u_int16	inized;		/* check pattern; memory initialized? */
	u_int16	status;		/* access semaphore */
	u_int32	free;		/* OFFSET (from lolim) to free list ptr */
	void	*mdir;		/* auxillary module directory ptr ? */
	void	*resv;		/* other stuff ? (ram disk ptr, ...) */
};


/* MemDefs module													*/
typedef mh_com *Mh_mem, mh_mem;

/* initialization table (in memdefs module data area) */
typedef struct mem_table {
	u_int16
		type,		/* memory type code */
		prior,		/* memory allocation priority */
		access,		/* access permissions */
		blksiz;		/* search block size */
	unsigned char
		*lolim,		/* beginning absolute address for this type */
		*hilim;		/* ending absolute address +1 for this type */
	u_int32
		descr;		/* optional description string offset */
	u_int32
		dma_addr,	/* address translation address for dma's, etc. */
		rsvd2[2];	/* reserved, must be zero */
} *Mem_tbl, mem_tbl;


/* access bit definitions */
#define B_USERRAM	(0x01)	/* memory allocatable by user procs */
#define B_PARITY	(0x02)	/* parity memory; must be initialized */
#define B_ROM		(0x04)	/* read-only memory; searched for modules */
#define B_NVRAM		(0x08)	/* non-volatile RAM; searched for modules */
#define B_SHARED	(0x10)	/* shared memory */

#endif /* _ALLOC_H */
