#if !defined(_IO_H)
#define _IO_H

/*
 * $Header:   /h0/MWOS/OS9000/SRC/DEFS/VCS/io.h_v   1.13   20 Jan 1996 19:50:30   ric  $
 * $Revision:   1.13  $
 */

/*--------------------------------------------------------------------------,
|                                                                           |
|              Copyright 1996 by Microware Systems Corporation              |
|                          Reproduced Under License                         |
|                                                                           |
|  This source code is the proprietary confidential property of Microware   |
|  Systems Corporation, and is provided to licensee for documentation and   |
|  educational purposes only. Reproduction, publication, or distribution    |
|  in any form to any party other than the licensee is strictly prohibited. |
|                                                                           |
|---------------------------------------------------------------------------|
|                                                                           |
|  Edition History:                                                         |
|   #   Date    Comments                                                By  |
|  -- -------- -------------------------------------------------------- --- |
|   1 88/02/23 Began modifications for Portable OS9                     DJN |
|   2 88/03/03 Added path delimiter '/' definition                      djl |
|   3 88/04/04 Added more path element definitions                      djl |
|	4 88/04/19 Added polling table definitions							rg  |
|   5 90/01/30 Added DT_GFM												tah	|
|	6 90/03/07 Added "pd_plist" pathlist variable to path descritpors.	afh |
|	7 93/01/04 Added DT_MPFM											rg  |
|	8 93/01/03 Added DT_RTNFM and DT_SPF defines.						afh |
|	9 94/02/01 Modified for 2.0 release (structures field additions).	afh |
|  10 94/05/12 Added DT_INET define.									afh |
|  11 94/05/17 Added pd_state field to path descriptor common section.	afh |
|  12 95/03/24 Added "v_fm_globs" and "v_dr_globs" fields to the device		|
|			   list table entry.										afh |
|  13 95/05/01 Added DT_NRF (non-volitile RAM) file manager code.		afh |
|  14 95/09/27 Fixed typo error in the "pd_async" field of "pd_com".	afh |
|  15 95/10/12 Added BUILD_DESC define to force u_int32 dd_port			GbG |
|					---- OS-9000/PPC V2.0 Release ----						|
|																			|
`--------------------------------------------------------------------------*/

#if !defined(_TYPES_H)
#include <types.h>
#endif

#if !defined(_MODULE_H)
#include <module.h>
#endif

#if !defined(_LOCK_H)
#include <lock.h>
#endif



#ifndef DT_SCF
#define DT_SCF	0	/* sequential character file type 	*/
#define DT_RBF	1	/* random block file type		 	*/
#define DT_PIPE	2	/* pipe file type					*/
#define DT_SBF	3	/* sequential block file type		*/
#define DT_NFM	4	/* network file type				*/
#define DT_CDFM	5	/* compact disc file type			*/
#define DT_UCM	6	/* user communication manager		*/
#define DT_SOCK	7	/* socket communication manager		*/
#define DT_PTTY	8	/* pseudo-keyboard manager			*/
#define DT_GFM	9	/* graphics file manager			*/
#define	DT_PCF	10	/* ms-dos file manager 				*/
#define DT_NRF	11	/* non-volitile RAM file manager	*/
#define DT_ISDN	12	/* ISDN file manager				*/
#define DT_MPFM	13	/* MPFM file manager				*/
#define DT_RTNFM 14 /* Real-Time Network file manager 	*/
#define DT_SPF	15	/* Serial Protocol file manager 	*/
#define DT_INET 16  /* Inet file manager				*/
/** DT-CODES UP TO 127 RESERVED FOR MICROWARE USE ONLY **/
#endif

/* path delimiter definitions */
#ifndef PATH_DELIM
#define	PATH_DELIM		'/'
#define	PATH_ENTIRE		'@'
#define	PATH_DIR		'.'
#endif

/* pd_state bit field definitions */
#define PD_SYSTATE 0x00000001	/* indicates I/O request from system state */


/* I/O process descriptor pointer definition */
typedef struct io_proc *Io_proc;

/* Device descriptor data definitions */
typedef struct {
#if defined(BUILD_DESC)
	u_int32
		dd_port;		/* device port address 			*/
#else
	void
		*dd_port;		/* device port address 			*/
#endif
	u_int16
		dd_lu_num,		/* logical unit number 			*/
		dd_pd_size,		/* path descriptor size 		*/
		dd_type,		/* device type 					*/
		dd_mode;		/* device mode capabilities 	*/
	u_int32
		dd_fmgr,		/* file manager name offset 	*/
		dd_drvr;		/* device driver name offset	*/
	u_int16
		dd_class,		/* sequential or random 		*/
		dd_dscres;		/* (reserved) 					*/
} *Dd_com, dd_com;


/* Device list element definition */
typedef struct devtab {
	u_int32
		v_sync;			/* device list entry identification code 	*/
	struct devtab
		*v_nxt_dev,		/* pointer to next element in list 			*/
		*v_prv_dev;		/* pointer to previous element in list		*/
	mh_fman
		*v_fm_mod;		/* pointer to file manager module 			*/
	void
		*v_fm_stat;		/* pointer to file manager static storage 	*/
	mh_drvr
		*v_dr_mod;		/* pointer to driver module 				*/
	void
		*v_dr_stat;		/* pointer to driver static storage 		*/
	mh_dev
		*v_dd_mod;		/* pointer to device descriptor module 		*/
	void
		*v_lu_stat,		/* pointer to logical unit static storage 	*/
		*v_port;		/* port address */
	struct pathcom
		*v_paths;		/* Linked list of open paths on this device.*/
	u_int16
		v_lu_num,		/* logical unit number						*/
		v_mode,			/* Device mode capabilities 				*/
		v_pd_size,		/* Size of path descriptor 					*/
		v_use_cnt;		/* number of paths open on this device 		*/
	lock_id
		v_lid;			/* Queue ID for device list entry. 			*/
	lk_desc
		v_lock;			/* lock structure for device list entry		*/
	process_id
		v_cproc;		/* current process 							*/
	u_int32
		v_lu_size;		/* size of logical unit static storage 		*/
	u_int16
		v_type,			/* device type 								*/
		v_class,		/* device class 							*/
		v_iuse_cnt,		/* count of intended users 					*/
		v_res;			/* reserved word 							*/
	u_int32
		v_fm_globs,		/* file manager total static globals pointer*/
		v_dr_globs,		/* driver total static globals pointer		*/
		v_rsrv[2];		/* reserved space							*/
} dev_list,*Dev_list;


/* Path descriptor common header definition */
typedef struct pathcom {
	path_id
		pd_id;			/* path number 							*/
	Dev_list
		pd_dev;			/* device list element pointer 			*/
	owner_id
		pd_own;			/* group/user number of path's creator 	*/
	struct pathcom
		*pd_paths,		/* list of open paths on device 		*/
		*pd_dpd;		/* default directory path 				*/
	u_int16
		pd_mode,		/* mode (read/write/update) 			*/
		pd_count,		/* actual number of open images 		*/
		pd_type,		/* device type 							*/
		pd_class;		/* device class (sequential or random) 	*/
	process_id
		pd_cproc;		/* current process id 					*/
	u_char
		*pd_plbuf,		/* pointer to partial pathlist 			*/
		*pd_plist;		/* pointer to complete pathlist 		*/
	u_int32
		pd_plbsz;		/* size of pathlist buffer 				*/
	lk_desc
		pd_lock;		/* Queue ID for path descriptor 		*/
	void
		*pd_async;		/* asynchronous I/O resource pointer	*/
	u_int32
		pd_state,		/* status bits (e.g. PD_SYSTATE)		*/
		pd_rsrv[7];		/* reserved space 						*/
} pd_com,*Pd_com;


/* Alias list element definition */
typedef struct list_as *As_list;
typedef struct list_as {
	u_int32
		as_size;		/* size of list element 				*/
	As_list
		as_prev,		/* previous element in list 			*/
		as_next;		/* Next element in list 				*/
	u_int16
		as_scnt,		/* number of elements in source string 	*/
		as_ssize,		/* size of source (alias) string 		*/
		as_tsize;		/* size of target string 				*/
} as_list;


/* I/O process descriptor definition */
typedef struct io_proc {
	u_int32
		iop_sync;				/* I/O process descriptor identifier (code) */
	process_id
		iop_id;					/* process (and I/O process) identifier		*/
	Io_proc
		iop_pproc,				/* previous process in new I/O queue 		*/
		iop_nproc;				/* next process in new I/O queue 			*/
	process_id
		iop_dlkn;				/* next process in deadlock chain 			*/
	u_int32
		iop_sched;				/* process scheduling priority 				*/
	owner_id
		iop_owner;				/* process owner 							*/
	u_int16
		iop_prior,				/* process priority 						*/
		iop_rsrvd;				/* reserved 								*/
	u_int32
		iop_rbytes,				/* bytes read by process 					*/
		iop_wbytes;				/* bytes written by process 				*/
	path_id
		iop_paths[NUMPATHS],	/* path translation table 					*/
		iop_de_path,			/* default execution directory path 		*/
		iop_dd_path;			/* default data directory path 				*/
	As_list
		iop_as_cur;				/* current alias list element when reading 	*/
	Pr_desc
		iop_rpthrds[NUMPATHS],	/* representative process threads for paths */		
		iop_de_rpthrd,			/* default execution directory path thread	*/
		iop_dd_rpthrd;			/* default data directory path thread		*/
	u_int32
		iop_resvd[4];			/* reserved space							*/
} io_proc;


/* Interrupt Polling Table format */
/*   Used for both vectored and autovector interrupts. */
/*   Warning: these variables must be declared in the following */
/*   order due to optimized code in the exception handler. */
typedef struct pol_tbl {
	struct pol_tbl	
		*q_link;		/* ptr to next entry in polling tbl */
	void
		*q_serv,		/* Absolute service routine address */
		*q_poll;		/* Absolute polling address */
	u_char
		*q_stat,		/* Static storage address */
		q_prty,			/* Priority (lower numbers are polled first) */
		q_rsv1;			/* reserved */
} pol_tbl, *Pol_tbl;


/* These definitions are for device class.  Software which checks */
/* this field should test the bits only, as the rest will probably */
/* be defined in the future. */
#define DC_SEQ		0x0001
#define DC_RND		0x0002


#if defined(_ANSI_EXT) || defined(__STDC__)
#if defined(__cplusplus)
extern "C" {
#endif /* __cplusplus */
error_code _os_attach(char *, u_int32, dev_list **);
error_code _os_detach(dev_list *);
error_code _os_getpd(path_id, pd_com **);
error_code _os_get_ioproc(process_id, io_proc **);
error_code _os_alias(char *, char *);
error_code _os_getdl(dev_list **);
error_code _os_rdalst(char *, u_int32 *);
error_code _os_tranpn(process_id, path_id, path_id *);
#if defined(__cplusplus)
}
#endif /* __cplusplus */
#endif

#endif
