#if !defined(_MODDIR_H)
#define _MODDIR_H

/*
 * $Header:   /h0/MWOS/OS9000/SRC/DEFS/VCS/moddir.h_v   1.6   20 Jan 1996 19:50:46   ric  $
 * $Revision:   1.6  $
 */

/*--------------------------------------------------------------------------,
|                                                                           |
|              Copyright 1996 by Microware Systems Corporation              |
|                          Reproduced Under License                         |
|                                                                           |
|  This source code is the proprietary confidential property of Microware   |
|  Systems Corporation, and is provided to licensee for documentation and   |
|  educational purposes only. Reproduction, publication, or distribution    |
|  in any form to any party other than the licensee is strictly prohibited. |
|                                                                           |
|---------------------------------------------------------------------------|
|                                                                           |
|  Edition History:                                                         |
|   #   Date    Comments                                                By  |
|  -- -------- -------------------------------------------------------- --- |
|   1 88/08/24 Created                                                  afh |
|	2 92/01/21 Renamed md_reserved field to md_lock field, this field		|
|			   will be used for node protection.						afh |
|   3 94/01/27 Added shared memory support variables.					afh |
|					---- OS-9000/PPC V2.0 Release ----						|
|                                                                           |
`---------------------------------------------------------------------------*/

#if !defined(_TYPES_H)
#include <types.h>
#endif

#if !defined(_MODULE_H)
#include <module.h>
#endif


#define md_group		md_owner.grp_usr.grp
#define md_user			md_owner.grp_usr.usr
#define md_group_user	md_owner.group_user

/* definitions of "md_status" flag bits */
#define MD_MDIR			0x00000001	/* identifies node as a directory node */
#define MD_NODIRCHG		0x00010000	/* directory tree not modifiable */
#define MD_NOMODCHG		0x00020000  /* module tree not modifiable */
#define MD_SHARED		0x80000000	/* shared module directory entry */

typedef struct module_dir mod_dir, *Mod_dir;

/* Module Directory - Module Entry Definition */
struct module_dir  {
	unsigned char
		*md_name;		/* module directory name 							*/
	owner_id
		md_owner;		/* owner group/user numbers 						*/
	u_int16
		md_access,		/* access permissions to module directory 			*/
		md_linkcnt;		/* directory/module link count 						*/
	Mh_com
		md_modptr,		/* module pointer 									*/
		md_modgrp;		/* module group pointer 							*/
	u_int32
		md_static;		/* module group memory size 						*/
	u_int16
		md_modchk,		/* module header checksum 							*/
		md_usecnt,		/* number of processes using module 				*/
		md_color,		/* memory color of module directory entry node 		*/
		md_rsrv1;		/* reserved word for alignment 						*/
	u_int32
		md_size,		/* size of module/directory 						*/
		md_status,		/* status flags related to module directory 		*/
		md_lock,		/* module diretory entry lock 						*/
		md_type;		/* module directory type							*/
	Mod_dir
		md_pardir,		/* pointer to parent module directory node 			*/
		md_parent,		/* parent directory/module node 					*/
		md_dirs,		/* head pointer to subordinate directories 			*/
		md_mods,		/* head pointer to modules contained in directory 	*/
		md_left,		/* module left pointer 								*/
		md_rght,		/* module right pointer 							*/
		md_next;		/* pointer to next module directory entry in group	*/
	u_int32
		md_rsrv2[5];	/* reserved for future use 							*/
};


#if defined(_ANSI_EXT) || defined(__STDC__) || defined(__cplusplus)
#if defined(__cplusplus)
extern "C" {
#endif /* __cplusplus */
error_code _os_altmdir(char *);
error_code _os_chmdir(char *);
error_code _os_cmdperm(char *, u_int32);
error_code _os_delmdir(char *);
error_code _os_get_mdp(char *, char *);
error_code _os_makmdir(char *, u_int32);
error_code _os_fmod(u_int32 *, mod_dir **, char *);
#if defined(__cplusplus)
}
#endif /* __cplusplus */
#endif

#endif

