#if !defined(_MODES_H)
#define _MODES_H

/*
 * $Header:   /h0/MWOS/OS9000/SRC/DEFS/VCS/modes.h_v   1.7   20 Jan 1996 20:08:32   ric  $
 * $Revision:   1.7  $
 */

/*--------------------------------------------------------------------------,
|																			|
|				Copyright 1996 by Microware Systems Corporation				|
|							Reproduced Under License						|
|																			|
|  This source code is the proprietary confidential property of Microware	|
|  Systems Corporation, and is provided to licensee for documentation and	|
|  educational purposes only. Reproduction, publication, or distribution	|
|  in any form to any party other than the licensee is strictly prohibited.	|
|																			|
|---------------------------------------------------------------------------|
|																			|
|	OS-9000 file access and permission modes								|
|																			|
| edition history															|
|	#	date     comments												by  |
|  -- -------- -------------------------------------------------------- --- |
|	1 96/01/20 ---- OS-9000/PPC V2.0 Release ----						rry |
`--------------------------------------------------------------------------*/

/* File access modes */
#define S_IFMT		 0xffff		/* mask for type of file */
#define	S_ITRUNC	 0x0100		/* truncate on open mode */
#define	S_ICONTIG	 0x0200		/* ensure contiguous file mode */
#define	S_IEXCL		 0x0400		/* error if file exists on create mode */
#define	S_ICREAT	 0x0800		/* create file mode */
#define	S_IAPPEND	 0x1000		/* append to file mode */
#define S_ISIZE		 0x2000		/* set initial file size */
#define S_ISHARE	 0x4000		/* non-sharable mode */
#define S_IFDIR		 0x8000		/* directory mode */
#define	S_IBLKMODE	 0x10000 	/* open in block allocation mode */

#define FAM_READ	 0x0001		/* read mode */
#define FAM_WRITE	 0x0002		/* write mode */
#define FAM_EXEC	 0x0004		/* exceute mode (search execution directory) */
#define FAM_APPEND	 0x1000		/* append mode */
#define FAM_SIZE	 0x2000		/* initial size specified mode */
#define FAM_NONSHARE 0x4000		/* non-sharable mode */
#define FAM_DIR		 0x8000		/* directory mode */
#define FAM_BLKMODE  0x10000	/* block allocation mode */
#define FAM_NOCREATE 0x0400		/* don't recreate existing file mode */

/* File access permissions */
#define S_IPRM		0xffff		/* mask for permission bits */
#define S_IREAD		0x0001	 	/* owner read mode/permission */
#define S_IWRITE	0x0002		/* owner write mode/permission */
#define S_IEXEC		0x0004		/* owner execute mode/permission */
#define	S_ISEARCH	0x0004		/* search permission (directories) */
#define	S_IGREAD	0x0010		/* group read permission */
#define	S_IGWRITE	0x0020		/* group write permission */
#define	S_IGEXEC	0x0040		/* group execute permission */
#define	S_IGSEARCH	0x0040		/* group search permission (directories) */
#define S_IOREAD	0x0100		/* public read permission */
#define S_IOWRITE	0x0200		/* public write permission */
#define S_IOEXEC	0x0400		/* public execute permission */
#define	S_IOSEARCH	0x0400		/* public search permission (directories) */

#define FAP_READ	0x0001		/* file created with owner read permission */
#define FAP_WRITE	0x0002		/* file created with owner write permission */
#define FAP_EXEC	0x0004		/* file created with owner execute permission*/
#define FAP_GREAD	0x0010		/* file created with group read permission */
#define FAP_GWRITE	0x0020		/* file created with group write permission */
#define FAP_GEXEC	0x0040		/* file created with group execute permission*/
#define FAP_PREAD	0x0100		/* file created with world read permission */
#define FAP_PWRITE	0x0200		/* file created with world write permission */
#define FAP_PEXEC	0x0400		/* file created with world execute permission*/

#if defined(_ANSI_EXT) || defined(__STDC__) || defined(__cplusplus)

#if !defined(_TYPES_H)
#include <types.h>
#endif

#if defined(__cplusplus)
extern "C" {
#endif /* __cplusplus */
error_code _os_chdir(char *, u_int32);
error_code _os_close(path_id);
error_code _os_create(char *, u_int32, path_id *, u_int32, ...);
error_code _os_delete(char *, u_int32);
error_code _os_dup(path_id, path_id *);
error_code _os_makdir(char *, u_int32, u_int32, ...);
error_code _os_open(char *, u_int32, path_id *);
error_code _os_read(path_id, void *, u_int32 *);
error_code _os_readln(path_id, void *, u_int32 *);
error_code _os_seek(path_id, u_int32);
error_code _os_write(path_id, void *, u_int32 *);
error_code _os_writeln(path_id, void *, u_int32 *);
#if defined(__cplusplus)
}
#endif /* __cplusplus */

#elif !defined(_MPF68K) && !defined(_MPF386)

#if !defined(_TYPES_H)
#include <types.h>
#endif

#if defined(__cplusplus)
extern "C" {
#endif /* __cplusplus */
error_code _os_create(char *, unsigned long, path_id *, unsigned long, ...);
error_code _os_makdir(char *, unsigned long, unsigned long, ...);
#if defined(__cplusplus)
}
#endif /* __cplusplus */

#endif

#endif
