#if !defined(_PROCESS_H)
#define _PROCESS_H

/*
 * $Header:   /h0/MWOS/OS9000/SRC/DEFS/VCS/process.h_v   1.18   20 Jan 1996 19:51:02   ric  $
 * $Revision:   1.18  $
 */

/*--------------------------------------------------------------------------,
|                                                                           |
|              Copyright 1996 by Microware Systems Corporation              |
|                          Reproduced Under License                         |
|                                                                           |
|  This source code is the proprietary confidential property of Microware   |
|  Systems Corporation, and is provided to licensee for documentation and   |
|  educational purposes only. Reproduction, publication, or distribution    |
|  in any form to any party other than the licensee is strictly prohibited. |
|                                                                           |
|---------------------------------------------------------------------------|
|                                                                           |
|  Edition History:                                                         |
|   #   Date    Comments                                                By  |
|  -- -------- -------------------------------------------------------- --- |
|  01 87/02/23 Began modifications for Portable OS9                     DJN |
|     88/02/29 Changed fields to start with p_                          rg  |
|	  88/02/29 Brought up to version 2.2 of os9							rg	|
|     89/02/07 Added linked module accounting block.					afh |
|  02 90/01/10 Changed "p_sid" & "p_cid" to "p_lockqp" & "p_lockqn"			|
|			   and added "p_dlockn".							 		afh |
|  03 90/05/03 Changed signal queue to a signal queue block.			afh |
|  04 91/10/08 Moved system defined signals to "signal.h".				afh |
|  05 92/03/31 Moved "THREAD_ID" into this file.						afh |
|  06 94/01/24 Rearranged & added new fields to the process descriptor.	afh |
|  07 94/04/07 Removed "p_fpexcpt", and "p_fpexstk" from the process 		|
|			   descriptor for PowerPC.									afh |
|  08 94/07/08 Added FPU usage bit to "p_state" definitions.			afh |
|  09 94/08/08 Increased process system state stack size.				afh |
|  10 94/09/09 Added p_dbgfreg to PowerPC process descriptor.			afh |
|  11 94/11/17 Simplified to include regs.h.							afh |
|  12 95/01/13 Fixed size of p_bpvalue array for PowerPC.				afh |
|  13 95/02/08 Conditionalized the presense of "LINKOFFSET".			afh |
|  14 95/05/02 Added "Q_SEMA" process queue identifier definition.		afh |
|  15 95/11/21 Added "p_dbgrsc" field.									afh |
|					---- OS-9000/PPC V2.0 Release ----						|
|																			|
`--------------------------------------------------------------------------*/


/* OS-9000 process descriptor definitions */
#if !defined(_TYPES_H)
#include <types.h>
#endif

#if !defined(_MODULE_H)
#include <module.h>
#endif

#if !defined(_MODDIR_H)
#include <moddir.h>
#endif

#if !defined(_SIGNAL_H)
#include <signal.h>
#endif


#if !defined(_REGS_H)
#include <regs.h>
#endif


#if !defined(_ALLOC_H)
#include <alloc.h>
#endif


#if defined(_MPFPOWERPC)
#define STACKSIZE (16*1024)	/* size of system state stack for processes		*/
#else
#define STACKSIZE (4*1024)	/* size of system state stack for processes		*/
#endif /* _MPFPOWERPC */

#ifdef COMPAT_BIAS
#define LINKOFFSET 0x8000	/* process static data bias value				*/
#endif

#define NUMPATHS 32			/* number of paths per process 					*/
#define DEFIOSIZE 32	  	/* maximum number of paths per process			*/
#define SUBMAX 16			/* number of per process subroutine modules 	*/
#define TRAPMAX 16			/* number of per process trap handlers			*/
#define BRKPTS 16			/* maximum number of break points per process	*/

#define EVENTS 15			/* number of events per event mapping table		*/
#define EV_SLOTS 2			/* number of status slots per event in table	*/

#define EVTBLSIZ ((u_int32)((EVENTS*EV_SLOTS)+2)*4) /* |event_id|link_cnt| 	*/

#define CHILDREN 10			/* number of children per status block			*/
#define CHILD_SLOTSZ 3		/* number of status slots per child in block	*/

/* child status block size:  1 unit = |child ID|status|exit status|			*/
#define CHILD_BLKSZ ((u_int32)((CHILDREN*CHILD_SLOTSZ)+2)*4)

/* children status bit definitions for */
#define ACTIVE_CHILD 0x01 	/* active child flag in parent's child block	*/

/* process memory image definitions */
#define MEMIMGSZ ((u_int32)32*2*4)
#define MEMSIZE(slot) (*(slot+1))
#define NEXTBLK(block) ((u_int32*)*(block+1))
#define NEXT_MSLOT(slot) (slot+2)
#define FIRST_MSLOT(block) (block+2)
#define LAST_MSLOT(block) (block+64)

#ifndef _MP
#define _GET_PID(p_id) (p_id)						/* get process ID 	*/
#define _MAKE_PID(p_id) (p_id)						/* make process ID	*/
#else
#define _GET_PID(id) (id & 0x0000FFFF)				/* get process ID 	*/
#define _MAKE_PID(pid) ((GLOB(d_mpid) << 16) | pid)	/* make process ID	*/
#endif /* _MP */


/* definitions for process descriptor ownership */
#define p_user p_owner.grp_usr.usr
#define p_group p_owner.grp_usr.grp
#define p_group_user p_owner.group_user

/* Signal flag bits (in P$SigFlg) */
#define B_SIGMASK 	0		/* signals are masked when set */
#define B_WAKEUP	0x80	/* wakeup is pending when set */

/* definitions for thread block ownership */
#define t_user t_owner.grp_usr.usr
#define t_group t_owner.grp_usr.grp
#define t_group_user t_owner.group_user

#define THREAD_ID 0xafafafaf	/* thread block identifier (sync) */

/* definition of flags of the thread block flags variable */
#define TH_DELPB 0x00000001	/* delete parameter block of thread block */
#define TH_SPOWN 0x00000002	/* flag to make the system process own the thread */

/* Thread Execution Block */
typedef struct thread {
	u_int32
		t_id;			 /* reserved 										*/
	process_id
		t_proc;			 /* owner process ID (zero if none) 				*/
	u_int32
		t_msiz;			 /* thread block memory size 						*/
	owner_id
		t_owner;		 /* owner's group/user number 						*/
	struct thread
		*t_next,		 /* next thread in doubly linked list 				*/
		*t_prev,		 /* previous thread in doubly linked list 			*/
		*t_linkn,		 /* next list of associated threads (owner link) 	*/
		*t_linkp;		 /* previous list of associated threads (owner link)*/
	u_int32
		t_cycle,		 /* wakeup cycle period 							*/
		t_wktime,		 /* wakeup time 									*/
		t_flags;		 /* thread block flags 								*/
	u_int32
		(*t_function)(); /* function to execute 							*/
	void
		*t_func_pb;		 /* parameter block to pass to function 			*/
} thread, *Thread;




/* Process State Flag Bits */
#define FPUPROC		0x400   /* xxxx x1xx xxxx xxxx process using FPU */
#define RTPROC		0x200	/* xxxx xx1x xxxx xxxx representative thread proc */
#define DBGPROC		0x100	/* xxxx xxx1 xxxx xxxx process is a debug process */
#define SYSSTATE 	0x80	/* xxxx xxxx 1xxx xxxx executing in system state */
#define TIMSLEEP 	0x40	/* xxxx xxxx x1xx xxxx process in timed sleep */
#define TIMOUT 		0x20	/* xxxx xxxx xx1x xxxx time slice has expired */
#define IMGCHG 		0x10	/* xxxx xxxx xxx1 xxxx SPU/MMU protection map has changed */
#define SIGNAL		0x08	/* xxxx xxxx xxxx 1xxx signal pending flag */
#define TRACEIT		0x04	/* xxxx xxxx xxxx x1xx need to trace this process */
#define CONDEMN 	0x02 	/* xxxx xxxx xxxx xx1x process is condemned */
#define DEAD 		0x01	/* xxxx xxxx xxxx xxx1 process has terminated */

/* Process State Flag Bits Numbers */
#define FPUPROCBT	0x400  /* xxxx x1xx xxxx xxxx process using FPU 		 */
#define RTPROCBT	0x200  /* xxxx xx1x xxxx xxxx representative thread proc */
#define DBGPROCBT	0x100  /* xxxx xxx1 xxxx xxxx process is a debug process */
#define SYSSTATEBT 	0x80   /* xxxx xxxx 1xxx xxxx executing in system state  */
#define TIMSLEEPBT 	0x40   /* xxxx xxxx x1xx xxxx timed sleep 				 */
#define TIMOUTBT	0x20   /* xxxx xxxx xx1x xxxx time slice has expired 	 */
#define IMGCHGBT	0x10   /* xxxx xxxx xxx1 xxxx SPU/MMU memory map has changed */
#define TRACEITBT	0x04   /* xxxx xxxx xxxx x1xx need to trace this process */
#define CONDEMNBT 	0x02   /* xxxx xxxx xxxx xx1x process is condemned 		 */
#define DEADBT 		0x01   /* xxxx xxxx xxxx xxx1 process has terminated 	 */

/* Process Queue ID codes */
#define Q_NONE		' '		/* not in any queue 						*/
#define Q_DEAD		'-' 	/* no queue: dead process 					*/
#define Q_ACTIVE	'a'		/* active process queue 					*/
#define Q_DEBUG		'd'		/* no queue: inactively debugging 			*/
#define Q_EVENT		'e'		/* event queue 								*/
#define Q_SLEEP		's'		/* sleep queue 								*/
#define Q_WAIT		'w' 	/* waiting queue 							*/
#define Q_CURRNT	'*' 	/* no queue: currently running 				*/
#define Q_SUSPEND	'z'		/* no queue: state saved and inactive 		*/
#define Q_SEMA		'p'		/* process is suspended in semaphore queue  */
#define Q_REMOTE	'r'		/* remote processor request wait queue 		*/
	
/* Child Process Status Bits */
#define CS_ACTIVE	0x80000000	/* child process is active (has not exited)	*/
#define CS_EXIT		0x40000000	/* notify parent of exiting child			*/


#if defined(_ANSI_EXT) || defined(__STDC__) || defined(__cplusplus)
#if defined(__cplusplus)
extern "C" {
#endif /* __cplusplus */
error_code _os_chain(u_int32, u_int32, char *, void *, u_int32, u_int32, u_int32);
error_code _os_chainm(u_int32, u_int32, mh_com *, void *, u_int32, u_int32);
error_code _os_cpy_ioproc(process_id, void *, u_int32);
error_code _os_cpymem(process_id, void *, void *, u_int32);
error_code _os_ddlk(process_id);
//error_code _os_exec(u_int32 *, u_int32, u_int32, void *, char **, char **, u_int32, ...);
error_code _os_exit(status_code);
error_code _os_fork(u_int32 *, u_int32, char *, void *, u_int32, u_int32, process_id *, u_int32, u_int32);
error_code _os_forkm(u_int32, u_int32, mh_com *, void *, u_int32, u_int32, process_id *, u_int32);
error_code _os_get_prtbl(void *, u_int32 *);
error_code _os_gprdsc(process_id, void *, u_int32 *);
error_code _os_id(process_id *, u_int16 *, u_int16 *, int32 *, u_int16 *, u_int16 *);
error_code _os_permit(void *, u_int32, u_int32, process_id);
error_code _os_protect(void *, u_int32, u_int32, process_id);
error_code _os_setpr(process_id, u_int32);
error_code _os_setuid(owner_id);
error_code _os_suspend(process_id);
error_code _os_sysdbg(void *, void *);
error_code _os_wait(process_id *, status_code *);
error_code _os_aproc(process_id);
error_code _os_ioexit(process_id, u_int32);
error_code _os_iofork(process_id, process_id, u_int32);
error_code _os_nproc(void);
error_code _os_rtnprc(process_id);
#elif !defined(_MPF68K) && !defined(_MPF386)
error_code _os_exec(unsigned long (*)(), unsigned long, unsigned long, void *, char **, char **, unsigned long, ...);
#endif
#if defined(__cplusplus)
}
#endif /* __cplusplus */

#endif
