#if !defined(_SCF_H)
#define _SCF_H

/*
 * $Header:   /h0/MWOS/OS9000/SRC/DEFS/VCS/scf.h_v   1.6   20 Jan 1996 19:51:26   ric  $
 * $Revision:   1.6  $
 */

/*--------------------------------------------------------------------------,
|                                                                           |
|              Copyright 1996 by Microware Systems Corporation              |
|                          Reproduced Under License                         |
|                                                                           |
|  This source code is the proprietary confidential property of Microware   |
|  Systems Corporation, and is provided to licensee for documentation and   |
|  educational purposes only. Reproduction, publication, or distribution    |
|  in any form to any party other than the licensee is strictly prohibited. |
|                                                                           |
|---------------------------------------------------------------------------|
| scf.h: definitions and data structres for the SCF file manager, drivers, 	|
|		 and descriptors.													|
|																			|
|	Edition History:														|
|	#   Date    Comments												By	|
|	-- -------- ------------------------------------------------------- ---	|
|	01 88/03/09 Conversion to OS-9000 begins.							jal	|
|	02 88/03/25 Separated scf device options from unit static storage.	jal	|
|	03 88/04/12 Added file manager static storage structure.            jal |
|	04 88/12/06 Re-organized and standardized structure names.			afh |
|	05 89/03/24 More renaming of structure fields.						afh |
|	06 90/02/16 Added "v_attached" field to driver statics structure.	afh |
|	07 94/01/10 Used one of the reserved field of the logical unit			|
|				static storage for a "user counter".					afh |
|					---- OS-9000/PPC V2.0 Release ----						|
|																			|
`--------------------------------------------------------------------------*/
#if !defined(_IO_H)
#include <io.h>
#endif

#ifndef NUM_IRQS
#define NUM_IRQS 8
#endif

typedef struct scf_fm_stat		*Scf_fm_stat;
typedef struct scf_drvr_stat	*Scf_drvr_stat;
typedef struct scf_lu_stat		*Scf_lu_stat;
typedef struct scf_lu_opts		*Scf_lu_opts;
typedef struct scf_path_desc	*Scf_path_desc;
typedef struct scf_path_opts	*Scf_path_opts;


/* SCF file manager static storage.	*/
typedef struct scf_fm_stat{
	u_int32
		func_count;
	error_code
		(*v_attach)(),	/* address of Scf's "attach" function */
		(*v_chgdir)(),	/* address of Scf's "chgdir" function */
		(*v_close)(),	/* address of Scf's "close" function */
		(*v_create)(),	/* address of Scf's "create" function */
		(*v_delete)(),	/* address of Scf's "delete" function */
		(*v_detach)(),	/* address of Scf's "detach" function */
		(*v_dup)(),		/* address of Scf's "dup" function */
		(*v_getstat)(),	/* address of Scf's "getstat" function */
		(*v_makdir)(),	/* address of Scf's "makdir" function */
		(*v_open)(),	/* address of Scf's "open" function */
		(*v_read)(),	/* address of Scf's "read" function */
		(*v_readln)(),	/* address of Scf's "readln" function */
		(*v_seek)(),	/* address of Scf's "seek" function */
		(*v_setstat)(),	/* address of Scf's "setstat" function */
		(*v_write)(),	/* address of Scf's "write" function */
		(*v_writeln)();	/* address of Scf's "writeln" function */
	error_code
		(*v_edfunc[16])(); /* Scf's editing function pointer array	*/
	u_int16
		v_rsrvd[4];		/* reserved space */
} scf_fm_stat;


/* SCF driver interrupt service routine entry table. */
typedef struct irq_entry *Irq_entry;
typedef struct irq_entry {
	hardware_vector
		v_vector_offset;	/* interrupt routine's vector offset (usually 0) */
	u_int32
		(*v_irqentry)();	/* address of interrupt service routine */
} irq_entry;


/* SCF driver static storage. */
typedef struct scf_drvr_stat{
	error_code
		(*v_init)(),		/* address of driver's "init" function */
		(*v_read)(),		/* address of driver's "read" function */
		(*v_write)(),		/* address of driver's "write" function */
		(*v_getstat)(),		/* address of driver's "get_status" function */
		(*v_setstat)(),		/* address of driver's "put_status" function */
		(*v_terminate)(),	/* address of driver's "terminate" function */
		(*v_entxirq)();		/* address of driver's "entxirq" function */
							/* 	i.e. (enable transmitter interrupts) */
	Dev_list
		v_dev_entry;		/* device list entry pointer for device */
							/* (initialized by SCF before calling driver) */
	u_int16
		v_attached,			/* driver attached flag (maintained by driver) */
		v_rsrvd[7];			/* reserved for future user */
	u_int32
		v_irqcnt;			/* number of driver interrupt service routines */
	irq_entry
		v_irqrtns[8];		/* interrupt service routine entries, Note: the */
							/* first entry is assumed to be the input routine */
} scf_drvr_stat;


/* SCF logical unit static storage options section */
typedef struct scf_lu_opts  {
	u_int16
		v_optsize;		/* options section size */
	u_char
		v_class,		/* device type;	0 = SCF */
		v_err,			/* accumulated errors */
		v_pause,		/* immediate pause request */
		v_line,			/* lines left until end of page */
		v_intr,			/* keyboard interrupt character */
		v_quit,			/* keyboard quit character */
		v_psch,			/* keyboard pause character */
		v_xon,			/* x-on character */
		v_xoff,			/* x-off character */
		v_baud,			/* Baud rate */
		v_parity,		/* Parity */
		v_stopbits,		/* Stop bits */
		v_wordsize,		/* Word size */
		v_rtsstate,		/* RTS state: disable = 0; enable = non-zero */
		v_dcdstate,		/* current state of DCD line */
		v_reserved[9];	/* reserved for future use */
} scf_lu_opts;
		

/* SCF unit static storage */
typedef struct scf_lu_stat{
	hardware_vector
		v_vector;		/* irq vector number */
	u_char
		v_irqlevel,		/* irq interrupt level */
		v_priority,		/* irq polling priority */
		v_pollin,		/* polled input flag; 1 = polled, 0 = irq driven */
		v_pollout,		/* polled output flag; 1 = polled, 0 = irq driven */
		v_inhalt,		/* input halted flag(non-zero if XOFF has been sent) */
		v_hangup,		/* set non-0 when data carrier is lost */
		v_outhalt;		/* output IRQ's disabled when non-Zero */
	u_int16
		v_lu_num,		/* driver accessible copy of logical unit number */
		v_wait;			/* flags whether a process is waiting on input/output */
	u_int32
 		v_irqmask,		/* Interrupt mask word */
		v_savirq_fm,	/* previous interrupt mask word	(SCF use only) */
		v_savirq_dv,	/* previous interrupt mask word	(driver use only) */
		v_savirq_ll;	/* previous interrupt mask word	(low level use only) */
	process_id
		v_wake,			/* id of process to wake up (process waiting on I/O) */
		v_busy,			/* id of process currently using device */
		v_lproc,		/* number of the last process to use this unit */
		v_sigproc[3],	/* process to signal on SS_SSIG request */
						/* signal code */
						/* associated (system) path number */
		v_dcdoff[3],	/* process to signal on loss of DCD */
						/* signal process */
						/* associated (system) path number */
		v_dcdon[3];		/* process to signal on loss of DCD */
						/* signal code */
						/* associated (system) path number */
	Scf_lu_stat
		v_outdev;		/* output device's static storage pointer */
	u_int32
		v_pdbufsize,	/* SCF's path buffer size for this device */
		v_maxbuff;		/* Send XOFF when buffer is this full */
	u_int32
		v_insize,		/* size of input buffer */
		v_incount;		/* number of bytes in input buffer */
	u_char
		*v_inbufad,		/* input buffer address */
		*v_infill,		/* input buffer next-in pointer */
		*v_inempty,		/* input buffer next-out pointer */
		*v_inend;		/* input buffer end of buffer pointer */
	u_int32
		v_outsize,		/* size of output buffer */
		v_outcount;		/* number of bytes in output buffer */
	u_char
		*v_outbufad,	/* output buffer address */
		*v_outfill,		/* output buffer next-in pointer */
		*v_outempty,	/* output buffer next-out pointer */
		*v_outend;		/* output buffer end of buffer pointer */
	lock_id
		v_lockid;		/* I/O lock I.D. number */
	u_int32
		v_use_cnt,		/* logical unit user counter */
		v_resrvd[5];	/* reserved space */
	Scf_path_opts
		v_pdopt;		/* pointer to path descriptor options section */
	scf_lu_opts
		v_opt;			/* logical unit options section */
#ifdef DEV_SPECIFICS
	DEV_SPECIFICS		/* this is expanded into driver specific static */
#endif					/* variables if defined (these variables are usually */
						/* defined in the "scxxxx.h" for a specific driver) */
} scf_lu_stat;


/* Path Descriptor options input mapping table entry structure */
typedef struct inmap_entry *Inmap_entry;
typedef struct inmap_entry {
	u_int16
		type,		/* character mapping type */
		func_code; 	/* scf editing function code */
	u_int32
		size;		/* size of associated string */
	void
		*string;	/* pointer to associated string */
} inmap_entry;
	

/* SCF path descriptor options structure */
typedef struct scf_path_opts {
	u_int16
 		pd_optsize,		/* path options table size */
		pd_extra;		/* maintain long allignment */
	inmap_entry
		pd_inmap[32];	/* Input control character mapping table */
	u_char
		pd_eorch,		/* end of record character (read only) */
		pd_eofch,		/* end of file character */
		pd_tabch,		/* Tab character (0 = none) */
		pd_bellch,		/* bell (line overflow) */
		pd_bspch;		/* backspace echo character */

	/* Input line editing mode control flags */
	u_char
		pd_case,		/* case				0 = both 
											1 = upper case only */
		pd_backsp,		/* backspace		0 = backspace
											1 = backspace, space, backspace */
		pd_delete,		/* delete			0 = carriage return, line feed
											1 = backspace over line */
		pd_echo,		/* echo				0 = no echo	*/
		pd_alf,			/* auto-linefeed	0 = no auto line feed */
		pd_pause,		/* pause			0 = no end of page pause */
		pd_insm;		/* insert mode		0 = type over
											1 = insert at cursor */
	/* Additional input editing variables */
	u_char
		pd_nulls,		/* end of line null count */
		pd_page,		/* lines per page */
		pd_tabsiz,		/* tab field size */
		pd_err,			/* most recent I/O error status */

		pd_rsvd[2];		/* reserved */
	u_int32
		pd_col,			/* current column number */
		pd_time;		/* time out value for unblocked reads */
	Dev_list
		pd_deventry;	/* Device table address (copy) */
} scf_path_opts;


/* SCF complete path descriptor structure */
typedef struct scf_path_desc {
	struct pathcom
		pd_common;		/* common path descriptor structure */
	Dev_list
		pd_outdev;		/* device tbl pointer for echo device */
	u_char
		*pd_ubuf,		/* user buffer base address */
		*pd_pbuf,		/* path buffer base address */
		*pd_pbufpos;	/* current path buffer position */
	u_int32
		pd_endobuf,		/* end of buffer position */
		pd_curpos,		/* cursor position counter */
		pd_reqcnt,		/* number of bytes requested by the caller */
		pd_evl;			/* readln end of visible line counter */
	u_char
		pd_echoflag,	/* flags whether echoing output is ok for this device */
		pd_lost;		/* non-zero if path has become dead */
						/* (ie: data-carrier-detect lost) */
	u_int16
		pd_reserved[7];	/* reserved	space */
	scf_path_opts
		pd_opt;			/* SCF path descriptor options */
} scf_path_desc;
	
/* SCF Device descriptor module data area */
typedef struct scf_desc		*Scf_desc;
typedef struct scf_desc {
	dd_com
		dd_descom;		/* common device descriptor variables */
	u_int32
		dd_outdev;		/* secondary output device name offset */
	u_int16
		dd_rsvd_scf[2];	/* reserved space */
} scf_desc;


/* scf_lu_opts->v_err: error bit assignments. */
#define SOVERRUN	0x01
#define DCD_LOST	0x02
#define NOT_CTS		0x04
/* bit 3 not used	*/
#define HOVERRUN	0x10
#define PARITYERR	0x20
#define FRAMING		0x40
#define BREAKERR	0x80

/* scf_lu_stat->v_wait values */
#define WT_INPUT	1	/* process waiting on input flag */
#define WT_OUTPUT	2	/* process wainting on output flag */

/* scf_lu_stat->v_outhalt bit definitions (output halted flags) */
#define OH_XOFF		0x01		/* V_XOFF received; awaiting V_XON */
#define OH_EMPTY	0x02		/* output buffer is empty */
#define OH_IRQON	0x80		/* transmitter IRQ is turned on */

/* scf_lu_stat->v_inhalt bit definitions */
#define FLAGBIT		0x80		/* flags input halted */

/* scf_lu_stat->v_pollin & scf_lu_stat->v_pollout values */
#define IRQDRIVEN	0			/* unit's I/O is interrupt driven */
#define POLLED		1			/* unit's I/O is polled */

/* Other SCF related constant definitions */
#define pd_options	path_desc->pd_opt
#define lu_options	unit_stat->v_opt
#define PDSIZE		sizeof(scf_path_desc)
#define MAKEUPCASE(c) (c -= ('a' - 'A'))	/* convert lower case to upper */
#define MINBUFF			10			/* minimum buffer size */
#define LOWCOUNT		10			/* output buffer low count */
#define CUSOR_POS		0
#define VISIBLE_LINE	1
#define UNINITIALIZED	0

/* SCF device baud rate codes (used with lu_options.v_baud) */
#define HARDWIRED	0x00	/* baud rate generator is hardware selected	*/
#define BAUD50		0x01	/* baud rate = 50 */
#define BAUD75		0x02	/* baud rate = 75 */
#define BAUD110		0x03	/* baud rate = 110 */
#define BAUD134_5	0x04	/* baud rate = 134.5 */
#define BAUD150		0x05	/* baud rate = 150 */
#define BAUD300		0x06	/* baud rate = 300 */
#define BAUD600		0x07	/* baud rate = 600 */
#define BAUD1200	0x08	/* baud rate = 1200 */
#define BAUD1800	0x09	/* baud rate = 1800 */
#define BAUD2000	0x0A	/* baud rate = 2000 */
#define BAUD2400	0x0B	/* baud rate = 2400 */
#define BAUD3600	0x0C	/* baud rate = 3600 */
#define BAUD4800	0x0D	/* baud rate = 4800 */
#define BAUD7200	0x0E	/* baud rate = 7200 */
#define BAUD9600	0x0F	/* baud rate = 9600 */
#define BAUD19200	0x10	/* baud rate = 19200 */
#define BAUD31250	0x11	/* baud rate = 31250 (MIDI) */
#define BAUDMIDI	0x11	/* baud rate = 31250 (MIDI) */
#define BAUD38400	0x12	/* baud rate = 38400 */

/* Baud rate codes 0x13 - 0x7F are undefined and reserved */
/* Baud rate codes 0x80 - 0xFE may be user defined */

#define EXTERNAL	0xFF	/* baud rate is externally produced */

/*#define SCFBTAB		"\
\x00\x00\x00\x4B\x00\x6E\x00\x87\x00\x96\x01\x2C\x02\x58\x04\xB0\x07\x08\
\x07\xD0\x09\x60\x0E\x10\x12\xC0\x1C\x20\x25\x80\x4B\x00\x7A\x12\x96\x00"
*/

/* SCF device parity codes (used with lu_options.v_parity) */
#define NOPARITY		0
#define ODDPARITY		1
#define EVENPARITY		2
#define MARKPARITY		3
#define SPACEPARITY		4

/* SCF device stop bits codes (used with lu_options.v_stopbits) */
#define ONESTOP			0
#define ONE_5STOP		1
#define TWOSTOP			2

/* SCF device wordsize codes (used with lu_options.v_wordsize) */
#define WORDSIZE5		5
#define WORDSIZE6		6
#define WORDSIZE7		7
#define WORDSIZE8		8

/* SCF "ready to send" (RTS) state flag (used with lu_options.v_rtsstate) */
#define RTSDISABLED		0
#define RTSENABLED		1

/* ASCII control & special character codes */
#define C_NULL		0x00
#define CTRL_A		0x01
#define CTRL_B		0x02
#define CTRL_C		0x03
#define CTRL_D		0x04
#define CTRL_E		0x05
#define CTRL_F		0x06
#define CTRL_G		0x07
#define CTRL_H		0x08
#define CTRL_I		0x09
#define CTRL_J		0x0A
#define CTRL_K		0x0B
#define CTRL_L		0x0C
#define CTRL_M		0x0D
#define CTRL_N		0x0E
#define CTRL_O		0x0F
#define CTRL_P		0x10
#define CTRL_Q		0x11
#define CTRL_R		0x12
#define CTRL_S		0x13
#define CTRL_T		0x14
#define CTRL_U		0x15
#define CTRL_V		0x16
#define CTRL_W		0x17
#define CTRL_X		0x18
#define CTRL_Y		0x19
#define CTRL_Z		0x1A
#define C_SPACE		0x20
#define C_COMMA		0x2C
#define C_PERIOD	0x2E
#define C_SLASH		0x2F

/* SCF/OS-9 compatible "standard" character codes */
#define C_REPEAT	0x01
#define C_INTR		0x03
#define C_REPRINT	0x04
#define C_QUIT		0x05
#define C_BELL		0x07
#define C_BACKSPACE	0x08
#define C_TAB		0x09
#define C_LINEFEED	0x0A
#define C_FORMFEED	0x0C
#define C_CR		0x0D
#define C_XOFF		0x13
#define C_XON		0x11
#define C_PAUSE		0x17
#define C_DELLINE	CTRL_X
#define C_EOF		0x1B

/* Input mapping type codes	*/
#define IGNORE			0
#define PASSTHRU		1
#define EDFUNCTION		2

/* Other constants */
#define NOEDFUNCS		16
#define NOCTRLKEYS		32

/* SCF editing function mapping codes */
#define MOVLEFT		0x00	/* move cursor to the left (formerly pd_bsp) */
#define MOVRIGHT	0x01	/* move cursor to the right */
#define MOVBEG		0x02	/* move cursor to the beginning of the line */
#define MOVEND		0x03	/* move cursor to the end of the line */
#define REPRINT		0x04	/* reprint the current line	to cursor position */
#define TRUNCATE	0x05	/* truncate the line at the cursor position */
#define DELCHRL		0x06	/* delete character to the left */
#define DELCHRU		0x07	/* delete character under the cursor */
#define DELWRDL		0x08	/* delete word to the left */
#define DELWRDR		0x09	/* delete word to the right */
#define DELINE		0x0A	/* delete the entire line */
#define UNDEF1		0x0B	/* undefined (reserved) */
#define MODETOGL	0x0C	/* input mode toggle (type over vs. insert) */
#define UNDEF2		0x0D	/* undefined (reserved) */
#define ENDOREC		0x0E	/* end of record (read only) */
#define ENDOFILE	0x0F	/* end of file */

#define JAMSIZE		35
#define JAMMER		"\
\x62\x1b\x59\x74\x3b\x01\x17\x59\x68\x27\
\x09\x00\x0b\x0c\x0f\x42\x0c\x64\x08\x60\
\x0c\x72\x15\x67\x41\x0f\x0a\x44\x4f\x1b\
\x1c\x0d\x17\x01\x7e";

#if defined(_ANSI_EXT) || defined(__STDC__) || defined(__cplusplus)
#if defined(__cplusplus)
extern "C" {
#endif /* __cplusplus */
error_code _os_ss_dcoff(path_id, signal_code);
error_code _os_ss_dcon(path_id, signal_code);
error_code _os_ss_dopt(path_id, u_int32, void *);
error_code _os_ss_dsrts(path_id);
error_code _os_ss_enrts(path_id);
error_code _os_ss_fillbuff(path_id, char *, u_int32);
#if defined(__cplusplus)
}
#endif /* __cplusplus */
#endif

#endif	/* define scf */

