#if !defined(_SG_CODES_H)
#define	_SG_CODES_H

/*
 * $Header:   /h0/MWOS/OS9000/SRC/DEFS/VCS/sg_codes.h_v   1.12   20 Jan 1996 19:51:40   ric  $
 * $Revision:   1.12  $
 */

/*--------------------------------------------------------------------------,
|                                                                           |
|              Copyright 1996 by Microware Systems Corporation              |
|                          Reproduced Under License                         |
|                                                                           |
|  This source code is the proprietary confidential property of Microware   |
|  Systems Corporation, and is provided to licensee for documentation and   |
|  educational purposes only. Reproduction, publication, or distribution    |
|  in any form to any party other than the licensee is strictly prohibited. |
|                                                                           |
|---------------------------------------------------------------------------|
|                                                                           |
|  Edition History:                                                         |
|   #   Date    Comments                                                By  |
|  -- -------- -------------------------------------------------------- --- |
|   1 88/03/03 Began modifications for Portable OS9                     djl |
|	2 90/04/03 Added SS_EDT getstat code.								afh |
|   3 90/04/06 Added SS_FLUSHMAP setstat code.                          djl |
|   4 90/05/31 Added GFM get/set stat codes								tje	|
|	5 91/07/24 Added SS_COPYPD get status code.							afh |
|	6 94/01/13 Added SS_PMOD get/set stat code.							afh |
|	7 94/01/20 Added SS_VOLSTORE getstat code.							afh |
|	8 94/03/31 Added SS_RTNFM getstat/setstat code.						afh |
|   9 95/01/16 Added SS_SOCKMAN getstat/setstat code.					afh |
|  10 95/05/01 Added SS_FREE getstat/setstat code.						afh |
|  11 95/05/11 Added SS_SPF getstat/setstat code.						afh |
|					---- OS-9000/PPC V2.0 Release ----						|
|																		 	|
`--------------------------------------------------------------------------*/

/*
	Get/SetStat function codes
*/
#define	SS_PATHOPT	0x00	/* read/write PD options						*/
#define	SS_READY	0x01	/* check for device ready						*/
#define	SS_SIZE		0x02	/* read/Write file size							*/
#define	SS_RESET	0x03	/* device restore								*/
#define	SS_WTRACK	0x04	/* device write track							*/
#define	SS_POS		0x05	/* get file current position					*/
#define	SS_EOF		0x06	/* test for End of File							*/
#define	SS_LINK		0x07	/* link to Status routines						*/
#define	SS_ULINK	0x08	/* unlink Status routines						*/
#define	SS_FEED		0x09	/* destructive forward skip (form feed)			*/
#define	SS_FREEZE	0x0a	/* freeze DD_ information						*/
#define	SS_SPT		0x0b	/* set DD_TKS to given value					*/
#define	SS_SQD		0x0c	/* sequence down hard disk						*/
#define	SS_DCMD		0x0d	/* send direct command to device				*/
#define	SS_DEVNAME	0x0e	/* return device name							*/
#define	SS_FD		0x0f	/* return file descriptor						*/
#define	SS_TICKS	0x10	/* set lockout honor duration					*/
#define	SS_LOCK		0x11	/* lock/release record							*/
#define	SS_DSTAT	0x12	/* return display status						*/
#define	SS_JOY		0x13	/* return joystick value						*/
#define	SS_BLKRD	0x14	/* block read									*/
#define	SS_BLKWR	0x15	/* block write									*/
#define	SS_RETEN	0x16	/* retension cycle								*/
#define	SS_WFM		0x17	/* write file mark								*/
#define	SS_RFM		0x18	/* read past file mark							*/
#define	SS_ELOG		0x19	/* read error log								*/
#define	SS_SENDSIG	0x1a	/* send signal on data ready					*/
#define	SS_RELEASE	0x1b	/* release device								*/
#define	SS_ATTR		0x1c	/* set file attributes							*/
#define	SS_BREAK	0x1d	/* send break out serial device					*/
#define	SS_RSBIT	0x1e	/* reserve bitmap sector (for disk reorg)		*/
#define	SS_RMS		0x1f	/* get/set Motorola RMS status					*/
#define	SS_FDINFO	0x20	/* get FD info for specified FD sector			*/
#define	SS_ACRTC	0x21	/* get/set Hitachi ACRTC status					*/
#define	SS_IFC		0x22	/* serial input flow control					*/
#define	SS_OFC		0x23	/* serial output flow control					*/
#define	SS_ENRTS	0x24	/* enable RTS (modem control)					*/
#define	SS_DSRTS	0x25	/* disable RTS (modem control)					*/
#define	SS_DCON		0x26	/* send signal DCD TRUE							*/
#define	SS_DCOFF	0x27	/* send signal DCD FALSE						*/
#define	SS_SKIP		0x28	/* skip block(s)								*/
#define	SS_MODE		0x29	/* set RBF access mode							*/
#define	SS_OPEN		0x2a	/* notification of new path opened				*/
#define	SS_CLOSE	0x2b	/* notification of path being closed			*/
#define	SS_SOUND	0x2c	/* produce audible sound						*/
#define	SS_DSIZE	0x2d	/* get drive size (in sectors)					*/
#define SS_SEVENT	0x2e	/* set event on data ready						*/
#define SS_DEVTYPE	0x2f	/* get the device type 							*/
#define SS_DEVOPT	0x79	/* get/set device (default) path options 		*/
#define SS_EDT		0x7a	/* file manager - device driver edition getstat */
#define	SS_RENAME   0x7b	/* rename current file							*/
#define	SS_FILLBUFF	0x7c	/* fill the path buffer							*/
#define	SS_SHOWUSE	0x7d	/* show the use count of driver/fm functions	*/
#define	SS_FdAddr	0x7e	/* get fd block address for open file			*/
#define	SS_HDLINK	0x7f	/* create a hard link to a(n rbf) file			*/
#define SS_LUOPT	0x80	/* get/set logical unit options					*/

#define	SS_CACHE	0x30	/* cache enable setstat code 					*/
#define	SS_CSTATS	0x31	/* get cache statistics getstat code			*/
#define	SS_PARITY	0x32	/* compute the parity of a block				*/
#define SS_SKIPEND	0x33	/* skip to end of recorded data on a tape		*/
#define	SS_FLUSHMAP 0x34	/* flush rbf bitmap                     		*/
#define SS_COPYPD	0x35	/* Copy path descriptor get status				*/

#define SS_FREE		0x43	/* Return free space get status					*/

#define SS_VOLSTORE 0x45	/* Return volume storage statistics getstat		*/
#define SS_ISDN		0x47	/* Get/Set Stat code for ISDN (with subcodes)	*/
#define SS_PMOD		0x48	/* Protocol Module get/setstat, with subcodes	*/
#define SS_SPF		0x48	/* SPF getstat/setstat with subcodes			*/
#define SS_RTNFM	0x49	/* Real-Time Network FM get/setstat w/ subcodes */


/*
	Get/Set Stat codes for GFM 
*/
#define	SS_SM		0x4e	/* GFM's soundmap control status code			*/
#define	SS_SD		0x4f	/* GFM's sound data manipulation status code	*/
#define	SS_SC		0x50	/* GFM's sound control status code				*/
#define	SS_DM		0x51	/* GFM's drawmap control status code			*/
#define	SS_GC		0x52	/* GFM's graphics cursor status code			*/
#define	SS_RG		0x53	/* GFM's region status code						*/
#define	SS_DP		0x54	/* GFM's drawing parameters status code			*/
#define	SS_DR		0x55	/* GFM's graphics drawing status code			*/
#define	SS_DC		0x56	/* GFM's display control status code			*/
#define	SS_VIQ		0x57	/* GFM's video inquiry status code				*/
#define	SS_CO		0x58	/* GFM's character output status code			*/
#define	SS_PT		0x59	/* GFM's pointer status code					*/
#define SS_KB		0x5b	/* GFM's keyboard status code 					*/

/*
	Get/SetStat function codes for sockets
*/

#define SS_Bind		0x6c	/* bind a socket name							*/
#define SS_Listen	0x6d	/* listen for connections						*/
#define SS_Connect	0x6e	/* initiate a connection						*/
#define SS_Resv		0x6f	/* socket characteristics specification			*/
#define SS_Accept	0x70	/* accept socket connections					*/
#define SS_Recv		0x71	/* receive data									*/
#define SS_Send		0x72	/* send data									*/
#define SS_GNam		0x73	/* get socket name								*/
#define SS_SOpt		0x74	/* set socket option							*/
#define SS_GOpt		0x75	/* get socket option							*/
#define SS_Shut		0x76	/* shutdown socket connection					*/
#define SS_SendTo	0x77	/* send to address								*/
#define SS_RecvFr	0x78	/* receive from address							*/
#define SS_Install	0x79	/* install upper level protocol (ULP) */
							/* handler on ifman list */
#define SS_PCmd		0x7a	/* protocol direct command */

/* more GFM and CDFM codes */
#define SS_SN		0x8c	/* GFM's screen functions 						*/
#define SS_AR		0x8d	/* GFM's action region functions 				*/
#define SS_AC		0x8f	/* GFM's action cursor functions 				*/
#define SS_MS		0x8e	/* GFM's message functions 						*/
#define SS_CDFD		0x90	/* CDFM return file descriptor information */
#define SS_CChan	0x91	/* CDFM change channel request */
#define SS_FG		0x92	/* GFM's frame grabber functions				*/
#define SS_SOCKMAN  0x94	/* Sockman get/setstat code with subcodes.		*/

/*
	Function codes for GFM
*/
/* SS_SM setstat function codes */
#define SM_CREAT	1		/* create soundmap */
#define SM_OUT		2		/* output soundmap */
#define SM_OFF		3		/* stop output of soundmap */
#define SM_CLOSE	4		/* close a soundmap */
#define SM_LOOP		5		/* set soundmap looping */
#define SM_IN		6		/* input soundmap */

/* SS_SM getstat function codes */
#define SM_INFO		1		/* get soundmap info */
#define SM_STAT		2		/* get soundmap status */

/* SS_FG setstat function codes */
#define FG_GRAB		1		/* grab one frame */
#define FG_GAIN		2		/* set frame grabber gain */
#define FG_OFFSET	3		/* set frame grabber voltage offset */

/* SS_FG getstat function codes */
#define FG_INFO		1		/* get frame grabber information */

/* SS_DM function codes */
#define DM_CREAT	1		/* create drawmap */
#define DM_ORG		2		/* set drawmap origin */
#define DM_COPY		3		/* copy drawmap to drawmap */
#define DM_EXCH		4		/* exchange drawmap to drawmap */
#define DM_TCPY		5		/* copy drawmap to drawmap with transparency */
#define DM_TEXC		6		/* exchange drawmap to drawmap with transparency */
#define DM_WRITE	7		/* write data to drawmap */
#define DM_IRWR		8		/* irregular write to drawmap */
#define DM_READ		9		/* read data from drawmap */
#define DM_WRPIX	10		/* write a pixel */
#define DM_RDPIX	11		/* read a pixel */
#define DM_CLOSE	12		/* close drawmap */
#define DM_DMDUP	13		/* duplicate a drawmap */

/* SS_GC function codes */
#define GC_POS		1		/* position graphics cursor */
#define GC_SHOW		2		/* show graphics cursor */
#define GC_HIDE		3		/* hide graphics cursor */
#define GC_PTN		4		/* set graphics cursor pattern */
#define GC_COL		5		/* set graphics cursor color */
#define GC_ORG		6		/* set graphics cursor origin */

/* SS_RG function codes */
#define RG_CREAT	1		/* create region */
#define RG_ISECT	2		/* region intersection */
#define RG_UNION	3		/* region union */
#define RG_DIFF		4		/* region difference */
#define RG_XOR		5		/* region XOR */
#define RG_MOVE		6		/* region move */
#define RG_DEL		7		/* delete a region */

/* SS_DP function codes */
#define DP_PTN		1		/* set draw pattern */
#define DP_PALN		2		/* set pattern alignment */
#define DP_SCMM		3		/* set character mapping method */
#define DP_SCR		4		/* set color register */
#define DP_GFNT		5		/* get a font */
#define DP_AFNT		6		/* activate a font */
#define DP_DFNT		7		/* deactivate a font */
#define DP_RFNT		8		/* release a font */
#define DP_CLIP		9		/* set clipping region */
#define DP_PNSZ		10		/* set pen size */
#define DP_PSTYL	11		/* set pen style */
#define DP_TCOL		12		/* set transparency color */

/* SS_DR function codes */
#define DR_DOT		1		/* draw a dot */
#define DR_LINE		2		/* draw a line */
#define DR_PLIN		3		/* draw a poly-line */
#define DR_CARC		4		/* draw a circular arc */
#define DR_EARC		5		/* draw an elliptical arc */
#define DR_RECT		6		/* draw a rectangle */
#define DR_ERECT	7		/* draw an elliptical cornered rectangle */
#define DR_PGON		8		/* draw a polygon */
#define DR_CIRC		9		/* draw a circle */
#define DR_CWDG		10		/* draw a circular wedge */
#define DR_ELPS		11		/* draw an ellipse */
#define DR_EWDG		12		/* draw an elliptical wedge */
#define DR_DRGN		13		/* draw a region */
#define DR_BFIL		14		/* border fill */
#define DR_FFIL		15		/* flood fill */
#define DR_COPY		16		/* copy data in a drawmap */
#define DR_TEXT		17		/* draw text */
#define DR_JTXT		18		/* draw justified text */

/* SS_DC setstat function codes */
#define DC_SENDSIG	1		/* send signal on video event */
#define DC_RELEASE	2		/* release pending signal */
#define DC_SETCLUT	3		/* set a clut */
#define DC_SETCLUTS 4		/* set a range of cluts */
#define DC_MAPDM	5		/* map a drawmap */
#define DC_OFF		6		/* turn off display */

/* SS_DC getstat function codes */
#define DC_DSPLSIZ	1		/* get the display size and characteristics */
#define DC_GETCLUT	2		/* get a clut */
#define DC_GETCLUTS 3		/* get a range of cluts */
#define DC_EVENT	4		/* get event name */

/* SS_VIQ getstat functions */
#define VIQ_TXTL	1		/* calculate text length */
#define VIQ_CPOS	2		/* return relative character positions */
#define VIQ_JCPS	3		/* return character positions for justified text */
#define VIQ_FDTA	4		/* get font data */
#define VIQ_GDTA	5		/* get glyph data */
#define VIQ_PNTR	6		/* test for point in a region */
#define VIQ_RLOC	7		/* inquire region location */
#define VIQ_RINFO	8		/* return region info */
#define VIQ_DMINFO	9		/* return drawmap info */

/* SS_CO setstat routines */
#define CO_COD		1		/* set character output drawmap */
#define CO_SCMM		2		/* set character output map method */
#define CO_AFNT		3		/* activate font */
#define CO_DFNT		4		/* deactivate font */

/* SS_PT setstat functions */
#define PT_SENDSIG	1		/* send sig on pointer change */
#define PT_RELEASE	2		/* release pending signal */
#define PT_POS		3		/* position pointer */
#define PT_ORG		4		/* set pointer origin */
#define PT_CALIB	5		/* calibrate pointer (for touchscreen) */

/* SS_PT getstat functions */
#define PT_COORD	1		/* get pointer coords */

/* SS_KB setstat functions */
#define KB_SENDSIG	1		/* send signal on char ready */
#define KB_RELEASE	2		/* release pending signal */

/* SS_KB getstat functions */
#define KB_RDY		1		/* check keyboard ready */


/* SS_SN setstat functions */
#define SN_OPEN		1		/* open a screen */
#define SN_CLOSE	2		/* close a screen */
#define SN_RAISE	3		/* raise a screen */
#define SN_LOWER	4		/* lower a screen */
#define SN_ACT		5		/* activate a screen */
#define SN_DEACT	6		/* deactivate a screen */
#define SN_CPACT	7		/* activate cursor process for screen */
#define SN_CPDEACT	8		/* deactivate cursor process for screen */
#define SN_ALINK	9		/* link action region to screen */
#define SN_CP		10		/* run cp once for screen */
#define SN_DMLINK	11		/* link drawmap to screen */
#define SN_CLUTLNK	12		/* link clut to screen */


/* SS_SN getstat functions */
#define SN_INFO		1		/* return screen info */
#define SN_GETACT	2		/* return active screen */


/* SS_AR setstat functions */
#define AR_OPEN		1		/* open action region */
#define AR_REDEFINE 2		/* redefine action region */
#define AR_CLOSE	3		/* close action region */
#define AR_CLOSESUB 4		/* close sub-action regions */
#define AR_RAISE	5		/* raise action region */
#define AR_LOWER	6		/* lower action region */
#define AR_ACT		7		/* activate action region */
#define AR_DEACT	8		/* deactivate action region */
#define AR_MOVE		9		/* move action region */
#define AR_MASK		10		/* set action region mask */
#define AR_UNGRAB	11		/* ungrab messages */
#define AR_GRAB		12		/* grab messages */

/* SS_AR getstat functions */
#define AR_INFO		1		/* return action region info */
#define AR_FIND		2		/* find action region for a point */
#define AR_RELXY	3		/* return relative coordinates */
#define AR_ABSXY	4		/* return absolute coordinates */


/* SS_MS setstat functions */
#define MS_READ		1		/* read a message */
#define MS_WRITE	2		/* write a message */
#define MS_UNREAD	3		/* unread a message */
#define MS_SENDSIG	4		/* send signal on message */
#define MS_RELEASE	5		/* release signal pending */
#define MS_FLUSH	6		/* flush message queue */
#define MS_JOURN	7		/* journal messages */

/* SS_MS getstat functions */
#define MS_STAT		1		/* get input device status */
#define MS_READY	2		/* message ready? */


/* SS_AC setstat functions */
#define AC_POS		1		/* set action cursor position */
#define AC_ACT		2		/* activate action cursor */
#define AC_DEACT	3		/* deactivate action cursor */
#define AC_PTN		4		/* set pattern */
#define AC_COL		5		/* set color */
#define AC_ORG		6		/* set origin */
#define AC_TRACK	7		/* track action cursor */

#if defined(_ANSI_EXT) || defined(__STDC__) || defined(__cplusplus)

#if !defined(_TYPES_H)
#include <types.h>
#endif

#if defined(__cplusplus)
extern "C" {
#endif /* __cplusplus */
error_code _os_getstat(path_id, u_int32, void *);
error_code _os_gs_cpypd(path_id, u_int32 *, void *);
error_code _os_gs_devnm(path_id, char *);
error_code _os_gs_devtyp(path_id, u_int16 *, u_int16 *);
error_code _os_gs_dopt(path_id, u_int32 *, void *);
error_code _os_gs_eof(path_id);
error_code _os_gs_luopt(path_id, u_int32 *, void *);
error_code _os_gs_popt(path_id, u_int32 *, void *);
error_code _os_gs_pos(path_id, u_int32 *);
error_code _os_gs_ready(path_id, u_int32 *);
error_code _os_gs_size(path_id, u_int32 *);
error_code _os_setstat(path_id, u_int32, void *);
error_code _os_sgetstat(path_id, u_int32, void *);
error_code _os_sgs_devnm(path_id, char *);
error_code _os_ss_attr(path_id, u_int32);
error_code _os_ss_break(path_id);
error_code _os_ss_dopt(path_id, u_int32, void *);
error_code _os_ss_luopt(path_id, u_int32, void *);
error_code _os_ss_popt(path_id, u_int32, void *);
error_code _os_ss_relea(path_id);
error_code _os_ss_rename(path_id, char *);
error_code _os_ss_reset(path_id);
error_code _os_ss_sendsig(path_id, signal_code);
error_code _os_ss_size(path_id, u_int32);
#if defined(__cplusplus)
}
#endif /* __cplusplus */
#endif

#endif
