/********************************************************************
   Library for access to the ASIC chip

   Functions :

   error_code asic_get_status( unsigned int *status ) ;
   error_code asic_clear_trigger( TRIGGER_TYPE trig ) ;
   error_code asic_enable_trigger( TRIGGER_TYPE trig ) ;
   error_code asic_disable_trigger( TRIGGER_TYPE trig ) ;
   error_code asic_slow_get_size( unsigned int nbytes) ;
   error_code asic_fast_set_addr( unsigned int *addr ) ;

   error_code asic_set_thresholdss( TRIGGER_TYPE trig, unsigned int p1,
                                    unsigned int p2 ) ;
*********************************************************************/
#include <stdio.h>
#include <stdlib.h>

#include "augererr.h"

#define _ASIC_LIB_MAIN_
#include "asiclib.h"


error_code
asic_get_status( unsigned int *status )
{
  *status = *(ASIC_STATUS_ADDR) ;
  return SUCCESS ;
}

error_code
asic_clear_trigger( TRIGGER_TYPE trig )
{
  return SUCCESS ;
}

error_code
asic_enable_trigger( TRIGGER_TYPE trig )
{
#if defined(TEST_ASIC)
  *(ASIC_CONTROL_ADDR) = FAST_TRIGGER_ENABLE ;
#else
  /* Different bits to set, according to the trigger type */
#endif
  return SUCCESS ;
}

error_code
asic_disable_trigger( TRIGGER_TYPE trig )
{
#if defined(TEST_ASIC)
  *(ASIC_CONTROL_ADDR) = FAST_TRIGGER_DISABLE ;
#else
  /* Different bits to set, according to the trigger type */
#endif
  return SUCCESS ;
}

error_code
asic_slow_get_size( unsigned int *nwords )
{
  return SUCCESS ;
}

error_code
asic_fast_set_addr( unsigned int *addr )
{
  return SUCCESS ;
}

error_code
asic_set_thresholds( TRIGGER_TYPE trig, unsigned int p1,
		     unsigned int p2 )
{
  return SUCCESS ;
}

error_code
asic_set_times( TRIGGER_TYPE trig, unsigned int p1,
		unsigned int p2 )
{
  return SUCCESS ;
}

TRIGGER_TYPE
asic_which_trigger()
{
  unsigned int status ;
#if defined(TEST_ASIC)
  status = *(ASIC_STATUS_ADDR) ;
  if ( status & FAST_STATUS_MASK ) return TRIGGER_FAST_0 ;
  else if ( status & SLOW_STATUS_MASK ) return TRIGGER_SLOW ;
  else return TRIGGER_UNKNOWN ;
#else
  return IS_FAST0 ;
#endif
}
