/*  CRC-32b version 1.03 by Craig Bruce, 27-Jan-94
**
**  Based on "File Verification Using CRC" by Mark R. Nelson in Dr. Dobb's
**  Journal, May 1992, pp. 64-67.  This program DOES generate the same CRC
**  values as ZMODEM and PKZIP
**
**  v1.00: original release.
**  v1.01: fixed printf formats.
**  v1.02: fixed something else.
**  v1.03: replaced CRC constant table by generator function.
**
**  v1.04: changed the name getcrc to crc32
**         changed the arguments , now a table of unsigned chars
**         L. Guglielmi
*/

#include <stdio.h>
#include <stdlib.h>

#include "crc32.h"

static unsigned long crcTable[256];
static int Initialised = 0 ;

/****************************************************************************/
static
void crcgen()
{
  unsigned long	crc, poly;
  int	i, j;
  
  poly = 0xEDB88320L;
  for (i=0; i<256; i++) {
    crc = i;
    for (j=8; j>0; j--) {
      if (crc&1) {
	crc = (crc >> 1) ^ poly;
      } else {
	crc >>= 1;
      }
    }
    crcTable[i] = crc;
  }
  Initialised = 1 ;
}

unsigned long
crc32( unsigned char *p, int count )
{
  unsigned long crc = 0xFFFFFFFF ;
  int i = 0 ;

  if ( !Initialised ) crcgen() ;
  for( ; i<count ; i++, p++ )
    crc = ((crc>>8) & 0x00FFFFFF) ^ crcTable[ (crc^(*p)) & 0xFF ];
  return crc ^ 0xFFFFFFFF ;
}

