#include <stdio.h>
#include <stdlib.h>
#include <types.h>
#include <const.h>


#include "dmalib.h"

void
dma_finish()
{
  exit( 0 ) ;
}

void
dma_setup_test( int burst, int prior )
{
  u_int32 dmacr ;

  set_dmasr( 0xFFFFFFFF ) ;
  /* FAST dma setup : Burst, High Bus Priority */
  /* Pour FastTrack FE, incrementer l'adresse de la source */
  dmacr = DMA_TO_MEM | DMA_WIDTH32 | DMA_DEST_INCR |
    DMA_FLYBY | DMA_TCE | DMA_TCD ;
  if( burst ) dmacr |= DMA_BURST ;
  if( prior ) dmacr |= DMA_BUS_PRIOR ;
  set_dmacr_fast( dmacr ) ;
#if 0
  /* SLOW dma setup : Burst, Low Bus Priority */
  dmacr = DMA_TO_MEM | DMA_WIDTH32 | DMA_DEST_INCR |
    DMA_FLYBY | DMA_TCE | DMA_TCD | DMA_BURST ;
  set_dmacr_slow( dmacr ) ;
#endif
}

void
dma_setup()
{
  u_int32 dmacr ;

  set_dmasr( 0xFFFFFFFF ) ;
  /* FAST dma setup : Burst, High Bus Priority */
  /* Pour FastTrack FE, incrementer l'adresse de la source */
  dmacr = DMA_TO_MEM | DMA_WIDTH32 | DMA_DEST_INCR |
    DMA_FLYBY | DMA_TCE | DMA_TCD | DMA_BURST | DMA_BUS_PRIOR ;
  set_dmacr_fast( dmacr ) ;
#if 0
  /* SLOW dma setup : Burst, Low Bus Priority */
  dmacr = DMA_TO_MEM | DMA_WIDTH32 | DMA_DEST_INCR |
    DMA_FLYBY | DMA_TCE | DMA_TCD | DMA_BURST ;
  set_dmacr_slow( dmacr ) ;
#endif
}

void
dma_set_fast( u_int32 *buff, int nwords )
{
  u_int32 dmacr ;

  set_dmasr( 0xFFFFFFFF ) ;
  /* prepare DMA count */
  set_dmact_fast( nwords ) ;
  /* prepare DMA address */
  set_dmada_fast( buff ) ;
}

void
dma_wait_fast()
{
  while ( !(get_dmasr() & DMA_FAST_END) ) ;
}

void
dma_start_fast()
{
  /* Enable DMA channel 1 */
  set_dmasr( 0xFFFFFFFF ) ;
  set_dmacr_fast( get_dmacr_fast() | DMA_ENABLE ) ;
}

void
dma_stop_fast()
{
  set_dmasr( 0xFFFFFFFF ) ;
}

void
dma_set_slow( u_int32 *buff, int nwords )
{
  u_int32 dmacr ;

  set_dmasr( 0xFFFFFFFF ) ;
  /* prepare DMA count */
  set_dmact_slow( nwords ) ;
  /* prepare DMA address */
  set_dmada_slow( buff ) ;
}

void
dma_wait_slow()
{
  while ( get_dmasr() & DMA_SLOW_END ) ;
}

void
dma_start_slow()
{
  /* Enable DMA channel 1 */
  set_dmasr( 0xFFFFFFFF ) ;
  set_dmacr_slow( get_dmacr_slow() | DMA_ENABLE ) ;
}

void
dma_stop_slow()
{
  set_dmasr( 0xFFFFFFFF ) ;
}
