#include <stdio.h>
#include <stdlib.h>
#include <types.h>
#include <const.h>


#include "dmalib.h"

typedef struct {
  unsigned int mask, shift ;
  char *name ;
} DMA_CR_BITS ;

DMA_CR_BITS DmaBits[] = {
  1, 31, "Channel Enable",
  1, 30, "Interrupt Enable",
  1, 29, "Direction",
  1, 28, "Periph Location",
  3, 26, "Periph Width",
  1, 25, "Dest Increment",
  1, 24, "Srce Increment",
  1, 23, "Priority",
  3, 21, "Transfer Mode",
  3, 19, "Periph Setup",
  0x3f, 13, "Periph Wait",
  0x7, 10, "Periph Hold",
  0x1, 9, "End od Transfer",
  0x1, 8, "TC Enable",
  1, 7, "Chaining Enable",
  1, 6, "Burst Enable",
  1, 5, "ECE Chain Enable",
  1, 4, "TCD Chain Enable",
  0, 0, NULL
} ;
  
dma_show( FILE *fout )
{
  DMA_CR_BITS *p = DmaBits ;
  unsigned int value = get_dmacr_fast() ;

  fprintf( fout, "Dma CR: %08x\n", value ) ;
  for( ; p->name ; p++ )
    fprintf( fout, "%-18s : %x\n", p->name, (value >> p->shift) & p->mask ) ;
}
